/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.lucene.search.join.ScoreMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.action.GetMonitorRequest;
import org.opensearch.alerting.action.GetMonitorResponse;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportGetMonitorAction;
import org.opensearch.alerting.transport.TransportGetMonitorActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014J\u001f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lorg/opensearch/alerting/transport/TransportGetMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/GetMonitorRequest;", "Lorg/opensearch/alerting/action/GetMonitorResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "getMonitorRequest", "actionListener", "Lorg/opensearch/action/ActionListener;", "getAssociatedWorkflows", "", "Lorg/opensearch/alerting/action/GetMonitorResponse$AssociatedWorkflow;", "id", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-alerting"})
public final class TransportGetMonitorAction
extends HandledTransportAction<GetMonitorRequest, GetMonitorResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opendistro/alerting/monitor/get", transportService, actionFilters, GetMonitorRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetMonitorRequest getMonitorRequest, @NotNull ActionListener<GetMonitorResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)getMonitorRequest), (String)"getMonitorRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        User user = this.readUserFromThreadContext(this.client);
        GetRequest getRequest = new GetRequest(".opendistro-alerting-config", getMonitorRequest.getMonitorId()).version(getMonitorRequest.getVersion()).fetchSourceContext(getMonitorRequest.getSrcContext());
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.getClient().get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this, user, getMonitorRequest){
                final /* synthetic */ ActionListener<GetMonitorResponse> $actionListener;
                final /* synthetic */ TransportGetMonitorAction this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ GetMonitorRequest $getMonitorRequest;
                {
                    this.$actionListener = $actionListener;
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$getMonitorRequest = $getMonitorRequest;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Monitor not found.", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    Ref.ObjectRef monitor = new Ref.ObjectRef();
                    if (!response2.isSourceEmpty()) {
                        Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                        TransportGetMonitorAction transportGetMonitorAction = this.this$0;
                        User user = this.$user;
                        ActionListener<GetMonitorResponse> actionListener = this.$actionListener;
                        GetMonitorRequest getMonitorRequest = this.$getMonitorRequest;
                        Throwable throwable = null;
                        try {
                            XContentParser xcp = (XContentParser)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                            String string = response2.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                            monitor.element = (Monitor)ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                            Monitor monitor2 = (Monitor)monitor.element;
                            if (!transportGetMonitorAction.checkUserPermissionsWithResource(user, (User)(monitor2 == null ? null : monitor2.getUser()), actionListener, "monitor", getMonitorRequest.getMonitorId())) {
                                return;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    try {
                        BuildersKt.launch$default((CoroutineScope)TransportGetMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, response2, this.$actionListener, (Ref.ObjectRef<Monitor>)monitor, null){
                            int label;
                            final /* synthetic */ TransportGetMonitorAction this$0;
                            final /* synthetic */ GetResponse $response;
                            final /* synthetic */ ActionListener<GetMonitorResponse> $actionListener;
                            final /* synthetic */ Ref.ObjectRef<Monitor> $monitor;
                            {
                                this.this$0 = $receiver;
                                this.$response = $response;
                                this.$actionListener = $actionListener;
                                this.$monitor = $monitor;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        var3_3 = this.$response.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"response.id");
                                        this.label = 1;
                                        v0 = TransportGetMonitorAction.access$getAssociatedWorkflows(this.this$0, var3_3, (Continuation)this);
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        associatedCompositeMonitors = (List)v0;
                                        var3_3 = this.$response.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"response.id");
                                        this.$actionListener.onResponse((Object)new GetMonitorResponse(var3_3, this.$response.getVersion(), this.$response.getSeqNo(), this.$response.getPrimaryTerm(), RestStatus.OK, (Monitor)this.$monitor.element, associatedCompositeMonitors));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                    catch (Exception e) {
                        TransportGetMonitorActionKt.access$getLog$p().error("Failed to get associate workflows in get monitor action", (Throwable)e);
                    }
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object getAssociatedWorkflows(String var1_1, Continuation<? super List<GetMonitorResponse.AssociatedWorkflow>> var2_2) {
        if (!(var2_2 instanceof getAssociatedWorkflows.1)) ** GOTO lbl-1000
        var16_3 = var2_2;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TransportGetMonitorAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransportGetMonitorAction.access$getAssociatedWorkflows(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                associatedWorkflows = new ArrayList<E>();
                queryBuilder = QueryBuilders.nestedQuery((String)"workflow.inputs.composite_input.sequence.delegates", (QueryBuilder)((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"workflow.inputs.composite_input.sequence.delegates.monitor_id", (Object)id))), (ScoreMode)ScoreMode.None);
                var6_9 = new String[]{".opendistro-alerting-config"};
                searchRequest = new SearchRequest().indices(var6_9).source(new SearchSourceBuilder().query((QueryBuilder)queryBuilder).fetchField("_id"));
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.L$2 = associatedWorkflows;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this, searchRequest){
                    final /* synthetic */ TransportGetMonitorAction this$0;
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.this$0 = $receiver;
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        this.this$0.getClient().search(this.$searchRequest, it);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var17_5) goto lbl25
lbl24:
                // 1 sources

                return var17_5;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                associatedWorkflows = (List)$continuation.L$2;
                id = (String)$continuation.L$1;
                this = (TransportGetMonitorAction)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    response = (SearchResponse)v0;
                    for (SearchHit hit : response.getHits()) {
                        var9_13 = (Closeable)XContentType.JSON.xContent().createParser(this.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        var10_14 = null;
                        try {
                            hitsParser = (XContentParser)var9_13;
                            $i$a$-use-TransportGetMonitorAction$getAssociatedWorkflows$2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)hitsParser, (String)"hitsParser");
                            var13_19 = hit.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)var13_19, (String)"hit.id");
                            workflow = ScheduledJob.Companion.parse(hitsParser, var13_19, hit.getVersion());
                            if (workflow instanceof Workflow) {
                                var13_19 = hit.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)var13_19, (String)"hit.id");
                                associatedWorkflows.add(new GetMonitorResponse.AssociatedWorkflow(var13_19, workflow.getName()));
                            }
                            var11_15 = Unit.INSTANCE;
                        }
                        catch (Throwable var11_16) {
                            var10_14 = var11_16;
                            throw var11_16;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var9_13, (Throwable)var10_14);
                        }
                    }
                    return associatedWorkflows;
                }
                catch (Exception e) {
                    TransportGetMonitorActionKt.access$getLog$p().error("failed to fetch associated workflows for monitor " + id, (Throwable)e);
                    return CollectionsKt.emptyList();
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.isAdmin(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    public static final /* synthetic */ Object access$getAssociatedWorkflows(TransportGetMonitorAction $this, String id, Continuation $completion) {
        return $this.getAssociatedWorkflows(id, (Continuation<? super List<GetMonitorResponse.AssociatedWorkflow>>)$completion);
    }
}

