/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.settings;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.opensearch.action.admin.indices.recovery.RecoveryRequest;
import org.opensearch.alerting.util.clusterMetricsMonitorHelpers.CatIndicesRequestWrapper;
import org.opensearch.alerting.util.clusterMetricsMonitorHelpers.CatShardsRequestWrapper;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.alerting.model.ClusterMetricsInput;
import org.opensearch.commons.alerting.util.IndexUtils;
import org.opensearch.core.xcontent.XContent;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/opensearch/alerting/settings/SupportedClusterMetricsSettings;", "Lorg/opensearch/commons/alerting/settings/SupportedClusterMetricsSettings;", "()V", "validateApiType", "", "clusterMetricsInput", "Lorg/opensearch/commons/alerting/model/ClusterMetricsInput;", "Companion", "opensearch-alerting"})
public final class SupportedClusterMetricsSettings
implements org.opensearch.commons.alerting.settings.SupportedClusterMetricsSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RESOURCE_FILE = "supported_json_payloads.json";
    @NotNull
    private static HashMap<String, Map<String, ArrayList<String>>> supportedApiList = new HashMap();

    public SupportedClusterMetricsSettings() {
        IndexUtils.Companion.setSupportedClusterMetricsSettings((org.opensearch.commons.alerting.settings.SupportedClusterMetricsSettings)this);
    }

    public void validateApiType(@NotNull ClusterMetricsInput clusterMetricsInput) {
        Intrinsics.checkNotNullParameter((Object)clusterMetricsInput, (String)"clusterMetricsInput");
        Companion.validateApiTyped(clusterMetricsInput);
    }

    static {
        URL supportedJsonPayloads = SupportedClusterMetricsSettings.class.getResource(RESOURCE_FILE);
        if (supportedJsonPayloads != null) {
            URL uRL = supportedJsonPayloads;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            Map map = XContentHelper.convertToMap((XContent)((XContent)JsonXContent.jsonXContent), (String)new String(byArray, charset), (boolean)false);
            if (map == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<kotlin.String, kotlin.collections.Map<kotlin.String, java.util.ArrayList<kotlin.String>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.String> }>>{ kotlin.collections.TypeAliasesKt.HashMap<kotlin.String, kotlin.collections.Map<kotlin.String, java.util.ArrayList<kotlin.String>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.String> }>> }");
            }
            supportedApiList = (HashMap)map;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\t0\u00072\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000Rb\u0010\u0005\u001aV\u0012\u0004\u0012\u00020\u0004\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\t0\u00070\u0006j*\u0012\u0004\u0012\u00020\u0004\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\t0\u0007`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/alerting/settings/SupportedClusterMetricsSettings$Companion;", "", "()V", "RESOURCE_FILE", "", "supportedApiList", "Ljava/util/HashMap;", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "getSupportedJsonPayload", "path", "resolveToActionRequest", "Lorg/opensearch/action/ActionRequest;", "clusterMetricsInput", "Lorg/opensearch/commons/alerting/model/ClusterMetricsInput;", "validateApiTyped", "", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, ArrayList<String>> getSupportedJsonPayload(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Map map = (Map)supportedApiList.get(path);
            if (map == null) {
                throw new IllegalArgumentException("API path not in supportedApiList.");
            }
            return map;
        }

        @NotNull
        public final ActionRequest resolveToActionRequest(@NotNull ClusterMetricsInput clusterMetricsInput) {
            ActionRequest actionRequest;
            Intrinsics.checkNotNullParameter((Object)clusterMetricsInput, (String)"clusterMetricsInput");
            String pathParams = clusterMetricsInput.parsePathParams();
            switch (WhenMappings.$EnumSwitchMapping$0[clusterMetricsInput.getClusterMetricType().ordinal()]) {
                case 1: {
                    actionRequest = new CatIndicesRequestWrapper(pathParams);
                    break;
                }
                case 2: {
                    actionRequest = (ActionRequest)new PendingClusterTasksRequest();
                    break;
                }
                case 3: {
                    if (((CharSequence)pathParams).length() == 0) {
                        return (ActionRequest)new RecoveryRequest();
                    }
                    String[] stringArray = new String[]{","};
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)pathParams, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                    if (stringArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    String[] pathParamsArray = stringArray2;
                    return (ActionRequest)new RecoveryRequest(Arrays.copyOf(pathParamsArray, pathParamsArray.length));
                }
                case 4: {
                    actionRequest = new CatShardsRequestWrapper(pathParams);
                    break;
                }
                case 5: {
                    String[] pathParamsArray = new String[]{"_all"};
                    return (ActionRequest)new GetSnapshotsRequest(pathParams, pathParamsArray);
                }
                case 6: {
                    actionRequest = (ActionRequest)new ListTasksRequest();
                    break;
                }
                case 7: {
                    if (((CharSequence)pathParams).length() == 0) {
                        return (ActionRequest)new ClusterHealthRequest();
                    }
                    Object $this$toTypedArray$iv = new String[]{","};
                    $this$toTypedArray$iv = StringsKt.split$default((CharSequence)pathParams, (String[])$this$toTypedArray$iv, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Object thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    String[] pathParamsArray = stringArray;
                    return (ActionRequest)new ClusterHealthRequest(Arrays.copyOf(pathParamsArray, pathParamsArray.length));
                }
                case 8: {
                    ClusterStateRequest pathParamsArray = new ClusterStateRequest().routingTable(false).nodes(false);
                    Intrinsics.checkNotNullExpressionValue((Object)pathParamsArray, (String)"ClusterStateRequest().ro\u2026Table(false).nodes(false)");
                    actionRequest = (ActionRequest)pathParamsArray;
                    break;
                }
                case 9: {
                    if (((CharSequence)pathParams).length() == 0) {
                        return (ActionRequest)new ClusterStatsRequest(new String[0]);
                    }
                    Object $this$toTypedArray$iv = new String[]{","};
                    $this$toTypedArray$iv = StringsKt.split$default((CharSequence)pathParams, (String[])$this$toTypedArray$iv, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Object thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    String[] pathParamsArray = stringArray;
                    return (ActionRequest)new ClusterStatsRequest(Arrays.copyOf(pathParamsArray, pathParamsArray.length));
                }
                case 10: {
                    String[] stringArray = new String[]{"os", "process", "jvm", "thread_pool", "fs", "transport", "http", "breaker", "script", "discovery", "ingest", "adaptive_selection", "script_cache", "indexing_pressure", "shard_indexing_pressure"};
                    NodesStatsRequest nodesStatsRequest = new NodesStatsRequest().addMetrics(stringArray);
                    Intrinsics.checkNotNullExpressionValue((Object)nodesStatsRequest, (String)"NodesStatsRequest().addM\u2026essure\"\n                )");
                    actionRequest = (ActionRequest)nodesStatsRequest;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported API.");
                }
            }
            return actionRequest;
        }

        public final void validateApiTyped(@NotNull ClusterMetricsInput clusterMetricsInput) {
            Intrinsics.checkNotNullParameter((Object)clusterMetricsInput, (String)"clusterMetricsInput");
            if (!supportedApiList.keySet().contains(clusterMetricsInput.getClusterMetricType().getDefaultPath())) {
                throw new IllegalArgumentException("API path not in supportedApiList.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ClusterMetricsInput.ClusterMetricType.values().length];
                nArray[ClusterMetricsInput.ClusterMetricType.CAT_INDICES.ordinal()] = 1;
                nArray[ClusterMetricsInput.ClusterMetricType.CAT_PENDING_TASKS.ordinal()] = 2;
                nArray[ClusterMetricsInput.ClusterMetricType.CAT_RECOVERY.ordinal()] = 3;
                nArray[ClusterMetricsInput.ClusterMetricType.CAT_SHARDS.ordinal()] = 4;
                nArray[ClusterMetricsInput.ClusterMetricType.CAT_SNAPSHOTS.ordinal()] = 5;
                nArray[ClusterMetricsInput.ClusterMetricType.CAT_TASKS.ordinal()] = 6;
                nArray[ClusterMetricsInput.ClusterMetricType.CLUSTER_HEALTH.ordinal()] = 7;
                nArray[ClusterMetricsInput.ClusterMetricType.CLUSTER_SETTINGS.ordinal()] = 8;
                nArray[ClusterMetricsInput.ClusterMetricType.CLUSTER_STATS.ordinal()] = 9;
                nArray[ClusterMetricsInput.ClusterMetricType.NODES_STATS.ordinal()] = 10;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

