/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.resthandler.RestAcknowledgeAlertActionKt;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.action.AcknowledgeAlertRequest;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/alerting/resthandler/RestAcknowledgeAlertAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getAlertIds", "", "", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "getName", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestAcknowledgeAlertAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "acknowledge_alert_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/{monitorID}/_acknowledge/alerts", RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_MONITOR_BASE_URI + "/{monitorID}/_acknowledge/alerts")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestAcknowledgeAlertActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.MONITOR_BASE_URI + "/{monitorID}/_acknowledge/alerts");
        String monitorId = request.param("monitorID");
        CharSequence charSequence = monitorId;
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean $i$a$-require-RestAcknowledgeAlertAction$prepareRequest$32 = false;
            String $i$a$-require-RestAcknowledgeAlertAction$prepareRequest$32 = "Missing monitor id.";
            throw new IllegalArgumentException($i$a$-require-RestAcknowledgeAlertAction$prepareRequest$32.toString());
        }
        XContentParser $i$a$-require-RestAcknowledgeAlertAction$prepareRequest$32 = request.contentParser();
        Intrinsics.checkNotNullExpressionValue((Object)$i$a$-require-RestAcknowledgeAlertAction$prepareRequest$32, (String)"request.contentParser()");
        List<String> alertIds = this.getAlertIds($i$a$-require-RestAcknowledgeAlertAction$prepareRequest$32);
        if (!(!((Collection)alertIds).isEmpty())) {
            boolean $i$a$-require-RestAcknowledgeAlertAction$prepareRequest$42 = false;
            String $i$a$-require-RestAcknowledgeAlertAction$prepareRequest$42 = "You must provide at least one alert id.";
            throw new IllegalArgumentException($i$a$-require-RestAcknowledgeAlertAction$prepareRequest$42.toString());
        }
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh", WriteRequest.RefreshPolicy.IMMEDIATE.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"refreshPolicy");
        AcknowledgeAlertRequest acknowledgeAlertRequest = new AcknowledgeAlertRequest(monitorId, alertIds, refreshPolicy);
        return arg_0 -> RestAcknowledgeAlertAction.prepareRequest$lambda-2(client, acknowledgeAlertRequest, arg_0);
    }

    private final List<String> getAlertIds(XContentParser xcp) {
        List ids = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (!Intrinsics.areEqual((Object)fieldName, (Object)"alerts")) continue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                String string = xcp.text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xcp.text()");
                ids.add(string);
            }
        }
        return ids;
    }

    private static final void prepareRequest$lambda-2(NodeClient $client, AcknowledgeAlertRequest $acknowledgeAlertRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$acknowledgeAlertRequest, (String)"$acknowledgeAlertRequest");
        $client.execute(AlertingActions.ACKNOWLEDGE_ALERTS_ACTION_TYPE, (ActionRequest)$acknowledgeAlertRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

