/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.model.ActionRunResult;
import org.opensearch.alerting.model.MonitorRunResultKt;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\"\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/alerting/model/TriggerRunResult;", "Lorg/opensearch/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "triggerName", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getError", "()Ljava/lang/Exception;", "setError", "(Ljava/lang/Exception;)V", "getTriggerName", "()Ljava/lang/String;", "setTriggerName", "(Ljava/lang/String;)V", "alertError", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "internalXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toXContent", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
public abstract class TriggerRunResult
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String triggerName;
    @Nullable
    private Exception error;

    public TriggerRunResult(@NotNull String triggerName, @Nullable Exception error) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        this.triggerName = triggerName;
        this.error = error;
    }

    public /* synthetic */ TriggerRunResult(String string, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            exception = null;
        }
        this(string, exception);
    }

    @NotNull
    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.triggerName = string;
    }

    @Nullable
    public Exception getError() {
        return this.error;
    }

    public void setError(@Nullable Exception exception) {
        this.error = exception;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().field("name", this.getTriggerName());
        this.internalXContent(builder, params);
        Exception exception = this.getError();
        String msg = exception == null ? null : exception.getMessage();
        builder.field("error", msg).endObject();
        return builder;
    }

    @NotNull
    public abstract XContentBuilder internalXContent(@NotNull XContentBuilder var1, @NotNull ToXContent.Params var2);

    @Nullable
    public AlertError alertError() {
        if (this.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception);
            return new AlertError(instant, "Failed evaluating trigger:\n" + MonitorRunResultKt.userErrorMessage(exception));
        }
        return null;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getTriggerName());
        out.writeException((Throwable)this.getError());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0018\u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0004\u00a8\u0006\b"}, d2={"Lorg/opensearch/alerting/model/TriggerRunResult$Companion;", "", "()V", "suppressWarning", "", "", "Lorg/opensearch/alerting/model/ActionRunResult;", "map", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, ActionRunResult> suppressWarning(@Nullable Map<String, Object> map) {
            Map<String, Object> map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, org.opensearch.alerting.model.ActionRunResult>");
            }
            return TypeIntrinsics.asMutableMap(map2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

