/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.AlertService;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.model.ActionRunResult;
import org.opensearch.alerting.model.QueryLevelTriggerRunResult;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.script.ChainedAlertTriggerExecutionContext;
import org.opensearch.alerting.script.DocumentLevelTriggerExecutionContext;
import org.opensearch.alerting.script.QueryLevelTriggerExecutionContext;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.alerting.workflow.WorkflowRunContext;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.commons.alerting.model.ActionExecutionResult;
import org.opensearch.commons.alerting.model.AggregationResultBucket;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.ChainedAlertTrigger;
import org.opensearch.commons.alerting.model.DataSources;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.NoOpTrigger;
import org.opensearch.commons.alerting.model.QueryLevelTrigger;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.model.action.AlertCategory;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.VersionType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 `2\u00020\u0001:\u0001`B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 JF\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\u0019\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(J2\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010+\u001a\u0004\u0018\u00010(J4\u0010,\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\"\u00104\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0018\u0018\u000106Jj\u00107\u001a\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180 062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00109\u001a\u00020:2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00180;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(J;\u0010>\u001a\u001a\u0012\u0004\u0012\u00020?\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00180;062\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010+\u001a\u0004\u0018\u00010(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J1\u0010A\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0006\u0012\u0004\u0018\u00010\u0018062\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010+\u001a\u0004\u0018\u00010(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J)\u0010B\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJA\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010K\u001a\u00020L2\b\b\u0002\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010PJ5\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010H\u001a\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010K\u001a\u00020LH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010RJ+\u0010S\u001a\u00020T2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010U\u001a\u00020V2\b\u0010+\u001a\u0004\u0018\u00010(H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010WJ,\u0010X\u001a\u00020\u00182\u0006\u0010Y\u001a\u00020\u00182\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020[062\b\u0010%\u001a\u0004\u0018\u00010&J5\u0010\\\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010]\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010+\u001a\u0004\u0018\u00010(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010^J$\u0010_\u001a\b\u0012\u0004\u0012\u00020&0 *\n\u0012\u0004\u0012\u00020&\u0018\u00010 2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006a"}, d2={"Lorg/opensearch/alerting/AlertService;", "", "client", "Lorg/opensearch/client/Client;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "alertIndices", "Lorg/opensearch/alerting/alerts/AlertIndices;", "(Lorg/opensearch/client/Client;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/alerting/alerts/AlertIndices;)V", "getAlertIndices", "()Lorg/opensearch/alerting/alerts/AlertIndices;", "getClient", "()Lorg/opensearch/client/Client;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "clearMonitorErrorAlert", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "(Lorg/opensearch/commons/alerting/model/Monitor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "composeChainedAlert", "Lorg/opensearch/commons/alerting/model/Alert;", "ctx", "Lorg/opensearch/alerting/script/ChainedAlertTriggerExecutionContext;", "executionId", "", "workflow", "Lorg/opensearch/commons/alerting/model/Workflow;", "associatedAlertIds", "", "composeDocLevelAlert", "findings", "relatedDocIds", "Lorg/opensearch/alerting/script/DocumentLevelTriggerExecutionContext;", "alertError", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "workflorwRunContext", "Lorg/opensearch/alerting/workflow/WorkflowRunContext;", "composeMonitorErrorAlert", "id", "workflowRunContext", "composeQueryLevelAlert", "Lorg/opensearch/alerting/script/QueryLevelTriggerExecutionContext;", "result", "Lorg/opensearch/alerting/model/QueryLevelTriggerRunResult;", "contentParser", "Lorg/opensearch/core/xcontent/XContentParser;", "bytesReference", "Lorg/opensearch/common/bytes/BytesReference;", "convertToCompletedAlerts", "currentAlerts", "", "getCategorizedAlertsForBucketLevelMonitor", "Lorg/opensearch/commons/alerting/model/action/AlertCategory;", "trigger", "Lorg/opensearch/commons/alerting/model/BucketLevelTrigger;", "", "aggResultBuckets", "Lorg/opensearch/commons/alerting/model/AggregationResultBucket;", "loadCurrentAlertsForBucketLevelMonitor", "Lorg/opensearch/commons/alerting/model/Trigger;", "(Lorg/opensearch/commons/alerting/model/Monitor;Lorg/opensearch/alerting/workflow/WorkflowRunContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadCurrentAlertsForQueryLevelMonitor", "moveClearedErrorAlertsToHistory", "monitorId", "alertIndex", "alertHistoryIndex", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveAlerts", "dataSources", "Lorg/opensearch/commons/alerting/model/DataSources;", "alerts", "retryPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "allowUpdatingAcknowledgedAlert", "", "routingId", "(Lorg/opensearch/commons/alerting/model/DataSources;Ljava/util/List;Lorg/opensearch/action/bulk/BackoffPolicy;ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveNewAlerts", "(Lorg/opensearch/commons/alerting/model/DataSources;Ljava/util/List;Lorg/opensearch/action/bulk/BackoffPolicy;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchAlerts", "Lorg/opensearch/action/search/SearchResponse;", "size", "", "(Lorg/opensearch/commons/alerting/model/Monitor;ILorg/opensearch/alerting/workflow/WorkflowRunContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateActionResultsForBucketLevelAlert", "currentAlert", "actionResults", "Lorg/opensearch/alerting/model/ActionRunResult;", "upsertMonitorErrorAlert", "errorMessage", "(Lorg/opensearch/commons/alerting/model/Monitor;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/alerting/workflow/WorkflowRunContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "Companion", "opensearch-alerting"})
public final class AlertService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final AlertIndices alertIndices;
    private final Logger logger;
    public static final int MAX_BUCKET_LEVEL_MONITOR_ALERT_SEARCH_COUNT = 500;
    @NotNull
    public static final String ERROR_ALERT_ID_PREFIX = "error-alert";
    @NotNull
    private static final TimeValue ALERTS_SEARCH_TIMEOUT = new TimeValue(5L, TimeUnit.MINUTES);

    public AlertService(@NotNull Client client, @NotNull NamedXContentRegistry xContentRegistry, @NotNull AlertIndices alertIndices) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)alertIndices, (String)"alertIndices");
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.alertIndices = alertIndices;
        this.logger = LogManager.getLogger(AlertService.class);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final AlertIndices getAlertIndices() {
        return this.alertIndices;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object loadCurrentAlertsForQueryLevelMonitor(@NotNull Monitor var1_1, @Nullable WorkflowRunContext var2_2, @NotNull Continuation<? super Map<Trigger, Alert>> var3_3) {
        if (!(var3_3 instanceof loadCurrentAlertsForQueryLevelMonitor.1)) ** GOTO lbl-1000
        var24_4 = var3_3;
        if ((var24_4.label & -2147483648) != 0) {
            var24_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AlertService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadCurrentAlertsForQueryLevelMonitor(null, null, (Continuation<? super Map<Trigger, Alert>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var25_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = monitor;
                $continuation.label = 1;
                v0 = this.searchAlerts(monitor, monitor.getTriggers().size() * 2, (WorkflowRunContext)workflowRunContext, (Continuation<? super SearchResponse>)$continuation);
                if (v0 == var25_6) {
                    return var25_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                monitor = (Monitor)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                searchAlertsResponse = (SearchResponse)v0;
                var6_8 = searchAlertsResponse.getHits();
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"searchAlertsResponse.hits");
                $this$map$iv = (Iterable)var6_8;
                $i$f$map = false;
                var8_10 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var13_17 = (SearchHit)item$iv$iv;
                    var20_20 = destination$iv$iv;
                    $i$a$-map-AlertService$loadCurrentAlertsForQueryLevelMonitor$foundAlerts$1 = false;
                    var15_19 /* !! */  = it.getSourceRef();
                    Intrinsics.checkNotNullExpressionValue((Object)var15_19 /* !! */ , (String)"it.sourceRef");
                    v1 = this.contentParser(var15_19 /* !! */ );
                    var15_19 /* !! */  = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var15_19 /* !! */ , (String)"it.id");
                    var20_20.add(Alert.Companion.parse(v1, (String)var15_19 /* !! */ , it.getVersion()));
                }
                $this$groupBy$iv = (List)destination$iv$iv;
                $i$f$groupBy = false;
                $this$mapTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$groupByTo = false;
                var11_14 = $this$groupByTo$iv$iv.iterator();
                while (var11_14.hasNext()) {
                    element$iv$iv = var11_14.next();
                    it = (Alert)element$iv$iv;
                    $i$a$-groupBy-AlertService$loadCurrentAlertsForQueryLevelMonitor$foundAlerts$2 = false;
                    key$iv$iv = it.getTriggerId();
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                        answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        v2 /* !! */  = answer$iv$iv$iv;
                    } else {
                        v2 /* !! */  = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)v2 /* !! */ ;
                    list$iv$iv.add(element$iv$iv);
                }
                foundAlerts = destination$iv$iv;
                $this$forEach$iv = foundAlerts.values();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    alerts = (List)element$iv;
                    $i$a$-forEach-AlertService$loadCurrentAlertsForQueryLevelMonitor$2 = false;
                    if (alerts.size() <= 1) continue;
                    this.logger.warn("Found multiple alerts for same trigger: " + alerts);
                }
                $this$associateWith$iv = monitor.getTriggers();
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                    list$iv$iv = (Trigger)element$iv$iv;
                    var21_27 = element$iv$iv;
                    var20_20 = result$iv;
                    $i$a$-associateWith-AlertService$loadCurrentAlertsForQueryLevelMonitor$3 = false;
                    v3 = (List)foundAlerts.get(trigger.getId());
                    var22_28 = v3 == null ? null : (Alert)CollectionsKt.firstOrNull((List)v3);
                    var20_20.put(var21_27, var22_28);
                }
                return result$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object loadCurrentAlertsForBucketLevelMonitor(@NotNull Monitor var1_1, @Nullable WorkflowRunContext var2_2, @NotNull Continuation<? super Map<Trigger, ? extends Map<String, Alert>>> var3_3) {
        if (!(var3_3 instanceof loadCurrentAlertsForBucketLevelMonitor.1)) ** GOTO lbl-1000
        var39_4 = var3_3;
        if ((var39_4.label & -2147483648) != 0) {
            var39_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AlertService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadCurrentAlertsForBucketLevelMonitor(null, null, (Continuation<? super Map<Trigger, ? extends Map<String, Alert>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var40_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = monitor;
                $continuation.label = 1;
                v0 = this.searchAlerts(monitor, 500, (WorkflowRunContext)workflowRunContext, (Continuation<? super SearchResponse>)$continuation);
                if (v0 == var40_6) {
                    return var40_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                monitor = (Monitor)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                searchAlertsResponse = (SearchResponse)v0;
                var6_8 = searchAlertsResponse.getHits();
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"searchAlertsResponse.hits");
                $this$map$iv = (Iterable)var6_8;
                $i$f$map = false;
                var8_10 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var13_16 = (SearchHit)item$iv$iv;
                    var35_14 = destination$iv$iv;
                    $i$a$-map-AlertService$loadCurrentAlertsForBucketLevelMonitor$foundAlerts$1 = false;
                    var15_18 /* !! */  = it.getSourceRef();
                    Intrinsics.checkNotNullExpressionValue((Object)var15_18 /* !! */ , (String)"it.sourceRef");
                    v1 = this.contentParser(var15_18 /* !! */ );
                    var15_18 /* !! */  = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var15_18 /* !! */ , (String)"it.id");
                    var35_14.add(Alert.Companion.parse(v1, (String)var15_18 /* !! */ , it.getVersion()));
                }
                $this$groupBy$iv = (List)destination$iv$iv;
                $i$f$groupBy = false;
                $this$mapTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    it = (Alert)element$iv$iv;
                    $i$a$-groupBy-AlertService$loadCurrentAlertsForBucketLevelMonitor$foundAlerts$2 = false;
                    key$iv$iv = it.getTriggerId();
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv /* !! */  = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv /* !! */  == null) {
                        $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                        answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        v2 /* !! */  = answer$iv$iv$iv;
                    } else {
                        v2 /* !! */  = value$iv$iv$iv /* !! */ ;
                    }
                    list$iv$iv = (List)v2 /* !! */ ;
                    list$iv$iv.add(element$iv$iv);
                }
                foundAlerts = destination$iv$iv;
                $this$associateWith$iv = monitor.getTriggers();
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                    list$iv$iv = (Trigger)element$iv$iv;
                    var36_40 = element$iv$iv;
                    var35_14 = result$iv;
                    $i$a$-associateWith-AlertService$loadCurrentAlertsForBucketLevelMonitor$2 = false;
                    var15_18 /* !! */  = (List)foundAlerts.get(trigger.getId());
                    if (var15_18 /* !! */  == null) {
                        v3 /* !! */  = null;
                    } else {
                        $this$mapNotNull$iv = (Iterable)var15_18 /* !! */ ;
                        $i$f$mapNotNull = false;
                        value$iv$iv$iv /* !! */  = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        var23_28 = $this$forEach$iv$iv$iv.iterator();
                        while (var23_28.hasNext()) {
                            element$iv$iv = element$iv$iv$iv = var23_28.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            alert = (Alert)element$iv$iv;
                            $i$a$-mapNotNull-AlertService$loadCurrentAlertsForBucketLevelMonitor$2$1 = false;
                            if (alert.getAggregationResultBucket() == null) {
                                v4 = null;
                            } else {
                                $i$a$-let-AlertService$loadCurrentAlertsForBucketLevelMonitor$2$1$1 = false;
                                v4 = TuplesKt.to((Object)AlertingUtilsKt.getBucketKeysHash(it), (Object)alert);
                            }
                            if (v4 == null) continue;
                            it$iv$iv = v4;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        var33_38 = (List)destination$iv$iv;
                        v5 = MapsKt.toMap((Iterable)var33_38);
                        v3 /* !! */  = v5 == null ? null : MapsKt.toMutableMap((Map)v5);
                    }
                    var34_39 = v3 /* !! */ ;
                    var37_41 = var34_39 == null ? (Map)new LinkedHashMap<K, V>() : var34_39;
                    var35_14.put(var36_40, var37_41);
                }
                return result$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Alert composeQueryLevelAlert(@NotNull QueryLevelTriggerExecutionContext ctx, @NotNull QueryLevelTriggerRunResult result, @Nullable AlertError alertError, @NotNull String executionId, @Nullable WorkflowRunContext workflorwRunContext) {
        String string;
        Alert alert;
        Map<String, ActionRunResult> $this$map$iv;
        boolean $i$f$map2;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Instant currentTime = Instant.now();
        Alert currentAlert = ctx.getAlert();
        List updatedActionExecutionResults = new ArrayList();
        Set currentActionIds = new LinkedHashSet();
        if (currentAlert != null) {
            Map.Entry<Object, Object> it;
            Object $this$filter$iv;
            for (ActionExecutionResult actionExecutionResult : currentAlert.getActionExecutionResults()) {
                String string2 = actionExecutionResult.getActionId();
                currentActionIds.add(string2);
                ActionRunResult actionRunResult = result.getActionResults().get(string2);
                if (actionRunResult == null) {
                    updatedActionExecutionResults.add(actionExecutionResult);
                    continue;
                }
                if (actionRunResult.getThrottled()) {
                    updatedActionExecutionResults.add(ActionExecutionResult.copy$default((ActionExecutionResult)actionExecutionResult, null, null, (int)(actionExecutionResult.getThrottledCount() + 1), (int)3, null));
                    continue;
                }
                updatedActionExecutionResults.add(ActionExecutionResult.copy$default((ActionExecutionResult)actionExecutionResult, null, (Instant)actionRunResult.getExecutionTime(), (int)0, (int)5, null));
            }
            Map<String, ActionRunResult> map = result.getActionResults();
            List list = updatedActionExecutionResults;
            boolean $i$f$filter = false;
            void var12_17 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            for (Map.Entry entry : var12_17.entrySet()) {
                it = entry;
                boolean bl = false;
                if (!(!currentActionIds.contains(it.getKey()))) continue;
                destination$iv$iv.put(entry.getKey(), entry.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            $i$f$map2 = false;
            Map<String, ActionRunResult> map2 = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry<Object, Object> entry : map2.entrySet()) {
                it = entry;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(new ActionExecutionResult((String)it.getKey(), ((ActionRunResult)it.getValue()).getExecutionTime(), ((ActionRunResult)it.getValue()).getThrottled() ? 1 : 0));
            }
            list.addAll((List)destination$iv$iv);
        } else {
            $this$map$iv = result.getActionResults();
            List list = updatedActionExecutionResults;
            $i$f$map2 = false;
            Map<String, ActionRunResult> map = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Map.Entry<String, ActionRunResult>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ActionRunResult> entry;
                Map.Entry<String, ActionRunResult> it = entry = iterator.next();
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(new ActionExecutionResult(it.getKey(), it.getValue().getExecutionTime(), it.getValue().getThrottled() ? 1 : 0));
            }
            list.addAll((List)destination$iv$iv);
        }
        Alert alert2 = currentAlert;
        List<AlertError> updatedHistory = this.update((List<AlertError>)(alert2 == null ? null : alert2.getErrorHistory()), alertError);
        if (alertError == null && !result.getTriggered()) {
            Alert $i$f$map2 = currentAlert;
            if ($i$f$map2 == null) {
                return null;
            }
            Alert.State state = Alert.State.COMPLETED;
            int n = IndexUtils.Companion.getAlertIndexSchemaVersion();
            alert = Alert.copy$default((Alert)$i$f$map2, null, (long)0L, (int)n, null, null, null, null, (long)0L, null, null, null, null, null, (Alert.State)state, null, (Instant)currentTime, null, null, null, updatedHistory, null, (List)updatedActionExecutionResults, null, null, null, (int)30629883, null);
            return alert;
        }
        if (alertError == null) {
            Alert alert3 = currentAlert;
            if (alert3 == null ? false : alert3.isAcknowledged()) {
                alert = null;
                return alert;
            }
        }
        if (currentAlert != null) {
            Alert.State alertState = alertError == null ? Alert.State.ACTIVE : Alert.State.ERROR;
            AlertError alertError2 = alertError;
            String string3 = alertError2 == null ? null : alertError2.getMessage();
            int n = IndexUtils.Companion.getAlertIndexSchemaVersion();
            alert = Alert.copy$default((Alert)currentAlert, null, (long)0L, (int)n, null, null, null, null, (long)0L, null, null, null, null, null, (Alert.State)alertState, null, null, (Instant)currentTime, null, (String)string3, updatedHistory, null, (List)updatedActionExecutionResults, null, null, null, (int)30597115, null);
            return alert;
        }
        WorkflowRunContext workflowRunContext = workflorwRunContext;
        Alert.State alertState = (workflowRunContext == null ? false : workflowRunContext.getAuditDelegateMonitorAlerts()) ? Alert.State.AUDIT : (alertError == null ? Alert.State.ACTIVE : Alert.State.ERROR);
        Monitor monitor = ctx.getMonitor();
        QueryLevelTrigger queryLevelTrigger = ctx.getTrigger();
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        AlertError alertError3 = alertError;
        String string4 = alertError3 == null ? null : alertError3.getMessage();
        int n = IndexUtils.Companion.getAlertIndexSchemaVersion();
        WorkflowRunContext workflowRunContext2 = workflorwRunContext;
        if (workflowRunContext2 == null) {
            string = "";
        } else {
            string = workflowRunContext2.getWorkflowId();
            if (string == null) {
                string = "";
            }
        }
        alert = new Alert(monitor, queryLevelTrigger, currentTime, currentTime, alertState, string4, updatedHistory, updatedActionExecutionResults, n, executionId, string);
        return alert;
    }

    @NotNull
    public final Alert composeDocLevelAlert(@NotNull List<String> findings, @NotNull List<String> relatedDocIds, @NotNull DocumentLevelTriggerExecutionContext ctx, @Nullable AlertError alertError, @NotNull String executionId, @Nullable WorkflowRunContext workflorwRunContext) {
        String string;
        Intrinsics.checkNotNullParameter(findings, (String)"findings");
        Intrinsics.checkNotNullParameter(relatedDocIds, (String)"relatedDocIds");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Instant currentTime = Instant.now();
        WorkflowRunContext workflowRunContext = workflorwRunContext;
        Alert.State alertState = (workflowRunContext == null ? false : workflowRunContext.getAuditDelegateMonitorAlerts()) ? Alert.State.AUDIT : (alertError == null ? Alert.State.ACTIVE : Alert.State.ERROR);
        String string2 = UUID.randomUUID().toString();
        Monitor monitor = ctx.getMonitor();
        DocumentLevelTrigger documentLevelTrigger = ctx.getTrigger();
        AlertError alertError2 = alertError;
        String string3 = alertError2 == null ? null : alertError2.getMessage();
        int n = IndexUtils.Companion.getAlertIndexSchemaVersion();
        WorkflowRunContext workflowRunContext2 = workflorwRunContext;
        if (workflowRunContext2 == null) {
            string = "";
        } else {
            string = workflowRunContext2.getWorkflowId();
            if (string == null) {
                string = "";
            }
        }
        String string4 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        return new Alert(string2, monitor, documentLevelTrigger, findings, relatedDocIds, currentTime, currentTime, alertState, string3, null, null, n, executionId, string4, 1536, null);
    }

    @NotNull
    public final Alert composeMonitorErrorAlert(@NotNull String id, @NotNull Monitor monitor, @NotNull AlertError alertError, @Nullable String executionId, @Nullable WorkflowRunContext workflowRunContext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)alertError, (String)"alertError");
        Instant currentTime = Instant.now();
        WorkflowRunContext workflowRunContext2 = workflowRunContext;
        Alert.State alertState = (workflowRunContext2 == null ? false : workflowRunContext2.getAuditDelegateMonitorAlerts()) ? Alert.State.AUDIT : Alert.State.ERROR;
        NoOpTrigger noOpTrigger = new NoOpTrigger(null, null, null, null, 15, null);
        AlertError alertError2 = alertError;
        String string2 = alertError2.getMessage();
        int n = IndexUtils.Companion.getAlertIndexSchemaVersion();
        WorkflowRunContext workflowRunContext3 = workflowRunContext;
        if (workflowRunContext3 == null) {
            string = "";
        } else {
            string = workflowRunContext3.getWorkflowId();
            if (string == null) {
                string = "";
            }
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        return new Alert(id, monitor, noOpTrigger, currentTime, currentTime, alertState, string2, null, n, string3, executionId, 128, null);
    }

    @NotNull
    public final Alert composeChainedAlert(@NotNull ChainedAlertTriggerExecutionContext ctx, @NotNull String executionId, @NotNull Workflow workflow, @NotNull List<String> associatedAlertIds) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
        Intrinsics.checkNotNullParameter(associatedAlertIds, (String)"associatedAlertIds");
        Instant instant = Instant.now();
        Instant instant2 = Instant.now();
        Alert.State state = Alert.State.ACTIVE;
        ChainedAlertTrigger chainedAlertTrigger = ctx.getTrigger();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return new Alert(instant, instant2, state, null, -1, executionId, chainedAlertTrigger, workflow, associatedAlertIds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Alert updateActionResultsForBucketLevelAlert(@NotNull Alert currentAlert, @NotNull Map<String, ActionRunResult> actionResults, @Nullable AlertError alertError) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        String actionId;
        Intrinsics.checkNotNullParameter((Object)currentAlert, (String)"currentAlert");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        List updatedActionExecutionResults = new ArrayList();
        Set currentActionIds = new LinkedHashSet();
        for (ActionExecutionResult actionExecutionResult : currentAlert.getActionExecutionResults()) {
            actionId = actionExecutionResult.getActionId();
            currentActionIds.add(actionId);
            ActionRunResult actionRunResult = actionResults.get(actionId);
            if (actionRunResult == null) {
                updatedActionExecutionResults.add(actionExecutionResult);
                continue;
            }
            if (actionRunResult.getThrottled()) {
                updatedActionExecutionResults.add(ActionExecutionResult.copy$default((ActionExecutionResult)actionExecutionResult, null, null, (int)(actionExecutionResult.getThrottledCount() + 1), (int)3, null));
                continue;
            }
            updatedActionExecutionResults.add(ActionExecutionResult.copy$default((ActionExecutionResult)actionExecutionResult, null, (Instant)actionRunResult.getExecutionTime(), (int)0, (int)5, null));
        }
        Map<String, ActionRunResult> map = actionResults;
        List list = updatedActionExecutionResults;
        boolean $i$f$filter = false;
        actionId = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!currentActionIds.contains(it.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(new ActionExecutionResult((String)it.getKey(), ((ActionRunResult)it.getValue()).getExecutionTime(), ((ActionRunResult)it.getValue()).getThrottled() ? 1 : 0));
        }
        list.addAll((List)destination$iv$iv);
        List<AlertError> updatedErrorHistory = this.update(currentAlert.getErrorHistory(), alertError);
        return alertError == null ? Alert.copy$default((Alert)currentAlert, null, (long)0L, (int)0, null, null, null, null, (long)0L, null, null, null, null, null, null, null, null, null, null, null, updatedErrorHistory, null, (List)updatedActionExecutionResults, null, null, null, (int)30932991, null) : Alert.copy$default((Alert)currentAlert, null, (long)0L, (int)0, null, null, null, null, (long)0L, null, null, null, null, null, (Alert.State)Alert.State.ERROR, null, null, null, null, (String)alertError.getMessage(), updatedErrorHistory, null, (List)updatedActionExecutionResults, null, null, null, (int)30662655, null);
    }

    @NotNull
    public final Map<AlertCategory, List<Alert>> getCategorizedAlertsForBucketLevelMonitor(@NotNull Monitor monitor, @NotNull BucketLevelTrigger trigger, @NotNull Map<String, Alert> currentAlerts, @NotNull List<AggregationResultBucket> aggResultBuckets, @NotNull List<String> findings, @NotNull String executionId, @Nullable WorkflowRunContext workflorwRunContext) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter(currentAlerts, (String)"currentAlerts");
        Intrinsics.checkNotNullParameter(aggResultBuckets, (String)"aggResultBuckets");
        Intrinsics.checkNotNullParameter(findings, (String)"findings");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        List dedupedAlerts = new ArrayList();
        List newAlerts = new ArrayList();
        Instant currentTime = Instant.now();
        Iterable $this$forEach$iv = aggResultBuckets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            AggregationResultBucket aggAlertBucket = (AggregationResultBucket)element$iv;
            boolean bl = false;
            Alert currentAlert = currentAlerts.get(AlertingUtilsKt.getBucketKeysHash(aggAlertBucket));
            if (currentAlert != null) {
                dedupedAlerts.add(Alert.copy$default((Alert)currentAlert, null, (long)0L, (int)0, null, null, null, null, (long)0L, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (AggregationResultBucket)aggAlertBucket, null, null, (int)0x1BFFFFF, null));
                currentAlerts.remove(AlertingUtilsKt.getBucketKeysHash(aggAlertBucket));
                continue;
            }
            WorkflowRunContext workflowRunContext = workflorwRunContext;
            Alert.State alertState = (workflowRunContext == null ? false : workflowRunContext.getAuditDelegateMonitorAlerts()) ? Alert.State.AUDIT : Alert.State.ACTIVE;
            Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
            List list = new ArrayList();
            List list2 = new ArrayList();
            int n = IndexUtils.Companion.getAlertIndexSchemaVersion();
            WorkflowRunContext workflowRunContext2 = workflorwRunContext;
            if (workflowRunContext2 == null) {
                string = "";
            } else {
                string = workflowRunContext2.getWorkflowId();
                if (string == null) {
                    string = "";
                }
            }
            Alert newAlert = new Alert(monitor, trigger, currentTime, currentTime, alertState, null, list, list2, n, aggAlertBucket, findings, executionId, string);
            newAlerts.add(newAlert);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)AlertCategory.DEDUPED, (Object)dedupedAlerts), TuplesKt.to((Object)AlertCategory.NEW, (Object)newAlerts)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Alert> convertToCompletedAlerts(@Nullable Map<String, Alert> currentAlerts) {
        List list;
        Instant currentTime = Instant.now();
        Map<String, Alert> map = currentAlerts;
        if (map == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Map<String, Alert> $this$map$iv = map;
            boolean $i$f$map = false;
            Map<String, Alert> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Alert alert = (Alert)it.getValue();
                Alert.State state = Alert.State.COMPLETED;
                int n = IndexUtils.Companion.getAlertIndexSchemaVersion();
                collection.add(Alert.copy$default((Alert)alert, null, (long)0L, (int)n, null, null, null, null, (long)0L, null, null, null, null, null, (Alert.State)state, null, (Instant)currentTime, null, null, null, null, null, null, null, null, null, (int)33251323, null));
            }
            list = (List)destination$iv$iv;
        }
        List list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object upsertMonitorErrorAlert(@NotNull Monitor var1_1, @NotNull String var2_2, @Nullable String var3_3, @Nullable WorkflowRunContext var4_4, @NotNull Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof upsertMonitorErrorAlert.1)) ** GOTO lbl-1000
        var19_6 = var5_5;
        if ((var19_6.label & -2147483648) != 0) {
            var19_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ AlertService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.upsertMonitorErrorAlert(null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                newErrorAlertId = "error-alert-" + monitor.getId() + "-" + UUID.randomUUID();
                var8_10 = new String[]{monitor.getDataSources().getAlertsIndex()};
                searchRequest = new SearchRequest(var8_10).source(new SearchSourceBuilder().sort("start_time", SortOrder.DESC).query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)monitor.getId())).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (String)Alert.State.ERROR.name()))));
                $continuation.L$0 = this;
                $continuation.L$1 = monitor;
                $continuation.L$2 = errorMessage;
                $continuation.L$3 = executionId;
                $continuation.L$4 = workflowRunContext;
                $continuation.L$5 = newErrorAlertId;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(searchRequest){
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.search(this.$searchRequest, it);
                    }
                }), (Continuation)$continuation);
                if (v0 == var20_8) {
                    return var20_8;
                }
                ** GOTO lbl35
            }
            case 1: {
                newErrorAlertId = (String)$continuation.L$5;
                workflowRunContext = (WorkflowRunContext)$continuation.L$4;
                executionId = (String)$continuation.L$3;
                errorMessage = (String)$continuation.L$2;
                monitor = (Monitor)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                searchResponse = (SearchResponse)v0;
                var10_12 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)var10_12, (String)"now()");
                alert = this.composeMonitorErrorAlert((String)newErrorAlertId, monitor, new AlertError(var10_12, errorMessage), executionId, workflowRunContext);
                if (searchResponse.getHits().getTotalHits().value > 0L) {
                    if (searchResponse.getHits().getTotalHits().value > 1L) {
                        this.logger.warn("There are [" + searchResponse.getHits().getTotalHits().value + "] error alerts for monitor [" + monitor.getId() + "]");
                    }
                    hit = searchResponse.getHits().getHits()[0];
                    var12_14 = hit.getSourceRef();
                    Intrinsics.checkNotNullExpressionValue((Object)var12_14, (String)"hit.sourceRef");
                    xcp = this.contentParser(var12_14);
                    var13_16 = hit.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var13_16, (String)"hit.id");
                    existingErrorAlert = Alert.Companion.parse((XContentParser)xcp, var13_16, hit.getVersion());
                    currentTime = Instant.now();
                    if (!Intrinsics.areEqual((Object)alert.getErrorMessage(), (Object)existingErrorAlert.getErrorMessage())) {
                        v1 = existingErrorAlert.getErrorHistory();
                        v2 = existingErrorAlert.getStartTime();
                        v3 = existingErrorAlert.getErrorMessage();
                        Intrinsics.checkNotNull((Object)v3);
                        newErrorHistory = this.update(v1, new AlertError(v2, v3));
                        var15_18 = alert;
                        var16_19 = existingErrorAlert.getId();
                        var17_20 = newErrorHistory;
                        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
                        v4 = Alert.copy$default((Alert)var15_18, (String)var16_19, (long)0L, (int)0, null, null, null, null, (long)0L, null, null, null, null, null, null, (Instant)currentTime, null, (Instant)currentTime, null, null, var17_20, null, null, null, null, null, (int)32948222, null);
                    } else {
                        v4 = Alert.copy$default((Alert)existingErrorAlert, null, (long)0L, (int)0, null, null, null, null, (long)0L, null, null, null, null, null, null, null, null, (Instant)currentTime, null, null, null, null, null, null, null, null, (int)0x1FEFFFF, null);
                    }
                    alert = v4;
                }
                v5 = new IndexRequest(monitor.getDataSources().getAlertsIndex()).routing(alert.getMonitorId());
                xcp = XContentFactory.jsonBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"jsonBuilder()");
                alertIndexRequest = ((IndexRequest)v5.source(alert.toXContentWithUser(xcp)).opType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(alert.getId());
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.label = 2;
                v6 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(alertIndexRequest){
                    final /* synthetic */ IndexRequest $alertIndexRequest;
                    {
                        this.$alertIndexRequest = $alertIndexRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.index(this.$alertIndexRequest, it);
                    }
                }), (Continuation)$continuation);
                if (v6 == var20_8) {
                    return var20_8;
                }
                ** GOTO lbl83
            }
            case 2: {
                this = (AlertService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl83:
                // 2 sources

                indexResponse = (IndexResponse)v6;
                this.logger.debug("Monitor error Alert successfully upserted. Op result: " + indexResponse.getResult());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object clearMonitorErrorAlert(@NotNull Monitor var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof clearMonitorErrorAlert.1)) ** GOTO lbl-1000
        var20_3 = var2_2;
        if ((var20_3.label & -2147483648) != 0) {
            var20_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AlertService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.clearMonitorErrorAlert(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                currentTime = Instant.now();
                var5_7 = new String[]{String.valueOf(monitor.getDataSources().getAlertsIndex())};
                searchRequest = new SearchRequest(var5_7).source(new SearchSourceBuilder().size(AlertingUtilsKt.getMAX_SEARCH_SIZE()).sort("start_time", SortOrder.DESC).query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)monitor.getId())).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (String)Alert.State.ERROR.name()))));
                searchRequest.setCancelAfterTimeInterval(AlertService.ALERTS_SEARCH_TIMEOUT);
                $continuation.L$0 = this;
                $continuation.L$1 = monitor;
                $continuation.L$2 = currentTime;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(searchRequest){
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.search(this.$searchRequest, it);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var21_5) goto lbl25
lbl24:
                // 1 sources

                return var21_5;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                currentTime = (Instant)$continuation.L$2;
                monitor = (Monitor)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                searchResponse = (SearchResponse)v0;
                if (searchResponse.getHits().getTotalHits().value == 0L) {
                    return Unit.INSTANCE;
                }
                indexRequests = new ArrayList<E>();
                var7_11 = searchResponse.getHits().getHits();
                Intrinsics.checkNotNullExpressionValue((Object)var7_11, (String)"searchResponse.hits.hits");
                $this$forEach$iv = var7_11;
                $i$f$forEach = false;
                var9_14 = $this$forEach$iv;
                var10_16 = 0;
                var11_18 = var9_14.length;
                while (var10_16 < var11_18) {
                    element$iv = var9_14[var10_16];
                    ++var10_16;
                    hit = (SearchHit)element$iv;
                    $i$a$-forEach-AlertService$clearMonitorErrorAlert$2 = false;
                    if (searchResponse.getHits().getTotalHits().value > 1L) {
                        this.logger.warn("Found [" + searchResponse.getHits().getTotalHits().value + "] error alerts for monitor [" + monitor.getId() + "] while clearing");
                    }
                    var15_24 = hit.getSourceRef();
                    Intrinsics.checkNotNullExpressionValue((Object)var15_24, (String)"hit.sourceRef");
                    xcp = this.contentParser(var15_24);
                    var17_28 = hit.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var17_28, (String)"hit.id");
                    existingErrorAlert = Alert.Companion.parse(xcp, var17_28, hit.getVersion());
                    updatedAlert = Alert.copy$default((Alert)existingErrorAlert, null, (long)0L, (int)0, null, null, null, null, (long)0L, null, null, null, null, null, null, null, (Instant)currentTime, null, null, null, null, null, null, null, null, null, (int)0x1FF7FFF, null);
                    v1 = indexRequests;
                    v2 = new IndexRequest(monitor.getDataSources().getAlertsIndex()).routing(monitor.getId()).id(updatedAlert.getId());
                    var18_29 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)var18_29, (String)"jsonBuilder()");
                    v1.add(v2.source(updatedAlert.toXContentWithUser(var18_29)).opType(DocWriteRequest.OpType.INDEX));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = monitor;
                $continuation.L$2 = currentTime;
                $continuation.label = 2;
                v3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>((List<IndexRequest>)indexRequests){
                    final /* synthetic */ List<IndexRequest> $indexRequests;
                    {
                        this.$indexRequests = $indexRequests;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.bulk(new BulkRequest().add((Iterable)this.$indexRequests).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), it);
                    }
                }), (Continuation)$continuation);
                ** if (v3 != var21_5) goto lbl75
lbl74:
                // 1 sources

                return var21_5;
lbl75:
                // 1 sources

                ** GOTO lbl84
            }
            case 2: {
                currentTime = (Instant)$continuation.L$2;
                monitor = (Monitor)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl84:
                    // 2 sources

                    if ((bulkResponse = (BulkResponse)v3).hasFailures()) {
                        $i$f$forEach = bulkResponse.getItems();
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach, (String)"bulkResponse.items");
                        $this$forEach$iv = $i$f$forEach;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            item = (BulkItemResponse)element$iv;
                            $i$a$-forEach-AlertService$clearMonitorErrorAlert$3 = false;
                            if (!item.isFailed()) continue;
                            this.logger.debug("Failed clearing error alert " + item.getId() + " of monitor [" + monitor.getId() + "]");
                        }
                    } else {
                        this.logger.debug("[" + bulkResponse.getItems().length + "] Error Alerts successfully cleared. End time set to: " + currentTime);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error clearing monitor error alerts for monitor [" + monitor.getId() + "]: " + ExceptionsHelper.detailedMessage((Throwable)e));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object moveClearedErrorAlertsToHistory(@NotNull String var1_1, @NotNull String var2_2, @NotNull String var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof moveClearedErrorAlertsToHistory.1)) ** GOTO lbl-1000
        var23_5 = var4_4;
        if ((var23_5.label & -2147483648) != 0) {
            var23_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AlertService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.moveClearedErrorAlertsToHistory(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var24_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_8 = new String[]{alertIndex};
                searchRequest = new SearchRequest(var6_8).source(new SearchSourceBuilder().size(AlertingUtilsKt.getMAX_SEARCH_SIZE()).query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)monitorId)).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (String)Alert.State.ERROR.name())).must((QueryBuilder)QueryBuilders.existsQuery((String)"end_time"))).version(Boxing.boxBoolean((boolean)true)));
                searchRequest.setCancelAfterTimeInterval(AlertService.ALERTS_SEARCH_TIMEOUT);
                $continuation.L$0 = this;
                $continuation.L$1 = alertIndex;
                $continuation.L$2 = alertHistoryIndex;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(searchRequest){
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.search(this.$searchRequest, it);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var24_7) goto lbl24
lbl23:
                // 1 sources

                return var24_7;
lbl24:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                alertHistoryIndex = (String)$continuation.L$2;
                alertIndex = (String)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                searchResponse = (SearchResponse)v0;
                if (searchResponse.getHits().getTotalHits().value == 0L) {
                    return Unit.INSTANCE;
                }
                copyRequests = new ArrayList<E>();
                var8_12 = searchResponse.getHits().getHits();
                Intrinsics.checkNotNullExpressionValue((Object)var8_12, (String)"searchResponse.hits.hits");
                $this$forEach$iv = var8_12;
                $i$f$forEach = false;
                var10_16 = $this$forEach$iv;
                var12_21 = var10_16.length;
                for (var11_18 = 0; var11_18 < var12_21; ++var11_18) {
                    element$iv = var10_16[var11_18];
                    hit = (SearchHit)element$iv;
                    $i$a$-forEach-AlertService$moveClearedErrorAlertsToHistory$2 = false;
                    var16_32 = hit.getSourceRef();
                    Intrinsics.checkNotNullExpressionValue((Object)var16_32, (String)"hit.sourceRef");
                    xcp = this.contentParser(var16_32);
                    var18_38 = hit.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var18_38, (String)"hit.id");
                    alert = Alert.Companion.parse(xcp, var18_38, hit.getVersion());
                    var18_38 = new IndexRequest(alertHistoryIndex).routing(alert.getMonitorId()).source(hit.getSourceRef(), (MediaType)XContentType.JSON).version(hit.getVersion()).versionType(VersionType.EXTERNAL_GTE).id(hit.getId()).timeout(MonitorRunnerService.INSTANCE.getMonitorCtx().getIndexTimeout());
                    Intrinsics.checkNotNullExpressionValue((Object)var18_38, (String)"IndexRequest(alertHistor\u2026.monitorCtx.indexTimeout)");
                    copyRequests.add(var18_38);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = alertIndex;
                $continuation.L$2 = alertHistoryIndex;
                $continuation.L$3 = searchResponse;
                $continuation.label = 2;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>((List<IndexRequest>)copyRequests){
                    final /* synthetic */ List<IndexRequest> $copyRequests;
                    {
                        this.$copyRequests = $copyRequests;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.bulk(new BulkRequest().add((Iterable)this.$copyRequests).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), it);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var24_7) goto lbl67
lbl66:
                // 1 sources

                return var24_7;
lbl67:
                // 1 sources

                ** GOTO lbl77
            }
            case 2: {
                searchResponse = (SearchResponse)$continuation.L$3;
                alertHistoryIndex = (String)$continuation.L$2;
                alertIndex = (String)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl77:
                // 2 sources

                if ((bulkResponse = (BulkResponse)v1).hasFailures()) {
                    $i$f$forEach = bulkResponse.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach, (String)"bulkResponse.items");
                    $this$forEach$iv = $i$f$forEach;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        item = (BulkItemResponse)element$iv;
                        $i$a$-forEach-AlertService$moveClearedErrorAlertsToHistory$3 = false;
                        if (!item.isFailed()) continue;
                        this.logger.error("Failed copying error alert [" + item.getId() + "] to history index [" + alertHistoryIndex + "]");
                    }
                    return Unit.INSTANCE;
                }
                $i$f$forEach = searchResponse.getHits().getHits();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach, (String)"searchResponse.hits.hits");
                $this$map$iv = $i$f$forEach;
                $i$f$map = false;
                var12_22 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    var19_39 = (SearchHit)item$iv$iv;
                    var21_41 = destination$iv$iv;
                    $i$a$-map-AlertService$moveClearedErrorAlertsToHistory$alertIds$1 = false;
                    var21_41.add(it.getId());
                }
                alertIds = (List)destination$iv$iv;
                $continuation.L$0 = this;
                $continuation.L$1 = alertIndex;
                $continuation.L$2 = alertIds;
                $continuation.L$3 = null;
                $continuation.label = 3;
                $i$f$map /* !! */  = $continuation;
                $this$mapTo$iv$iv = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)$i$f$map /* !! */ ));
                cont = (Continuation)$this$mapTo$iv$iv;
                $i$a$-suspendCoroutine-AlertService$moveClearedErrorAlertsToHistory$deleteResponse$1 = false;
                item = new String[]{alertIndex};
                ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((OpenSearchClient)this.getClient(), (ActionType)DeleteByQueryAction.INSTANCE).source(item)).filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)alertIds))).refresh(true)).timeout(AlertService.ALERTS_SEARCH_TIMEOUT)).execute((ActionListener)new ActionListener<BulkByScrollResponse>((Continuation<? super BulkByScrollResponse>)cont){
                    final /* synthetic */ Continuation<BulkByScrollResponse> $cont;
                    {
                        this.$cont = $cont;
                    }

                    public void onResponse(@NotNull BulkByScrollResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        this.$cont.resumeWith(Result.constructor-impl((Object)response2));
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        this.$cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
                    }
                });
                v2 = $this$mapTo$iv$iv.getOrThrow();
                if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v3 = v2;
                if (v2 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl135
            }
            case 3: {
                (List)$continuation.L$2;
                (String)$continuation.L$1;
                this = (AlertService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl135:
                    // 2 sources

                    deleteResponse = (BulkByScrollResponse)v3;
                    $i$f$map /* !! */  = deleteResponse.getBulkFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$map /* !! */ , (String)"deleteResponse.bulkFailures");
                    $this$forEach$iv = $i$f$map /* !! */ ;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (BulkItemResponse.Failure)element$iv;
                        $i$a$-forEach-AlertService$moveClearedErrorAlertsToHistory$4 = false;
                        this.logger.error("Failed deleting alert while moving cleared alerts: [" + it.getId() + "] cause: [" + it.getCause() + "] ");
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed moving cleared error alerts to history index: " + ExceptionsHelper.detailedMessage((Throwable)e));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object saveAlerts(@NotNull DataSources dataSources, @NotNull List<Alert> alerts, @NotNull BackoffPolicy retryPolicy, boolean allowUpdatingAcknowledgedAlert, @NotNull String routingId, @NotNull Continuation<? super Unit> $completion) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        String alertsIndex = dataSources.getAlertsIndex();
        String alertsHistoryIndex = dataSources.getAlertsHistoryIndex();
        Ref.ObjectRef requestsToRetry = new Ref.ObjectRef();
        Iterable iterable = alerts;
        Ref.ObjectRef objectRef = requestsToRetry;
        boolean $i$f$flatMap = false;
        void var12_13 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Alert alert = (Alert)element$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[alert.getState().ordinal()]) {
                case 1: 
                case 2: {
                    IndexRequest indexRequest = new IndexRequest(alertsIndex).routing(routingId);
                    XContentBuilder xContentBuilder2 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"jsonBuilder()");
                    IndexRequest indexRequest2 = indexRequest.source(alert.toXContentWithUser(xContentBuilder2)).id(!Intrinsics.areEqual((Object)alert.getId(), (Object)"") ? alert.getId() : null);
                    Intrinsics.checkNotNullExpressionValue((Object)indexRequest2, (String)"IndexRequest(alertsIndex\u2026O_ID) alert.id else null)");
                    list = CollectionsKt.listOf((Object)indexRequest2);
                    break;
                }
                case 3: {
                    IndexRequest indexRequest2;
                    XContentBuilder xContentBuilder2;
                    if (allowUpdatingAcknowledgedAlert) {
                        IndexRequest indexRequest = new IndexRequest(alertsIndex).routing(routingId);
                        xContentBuilder2 = XContentFactory.jsonBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"jsonBuilder()");
                        indexRequest2 = indexRequest.source(alert.toXContentWithUser(xContentBuilder2)).id(!Intrinsics.areEqual((Object)alert.getId(), (Object)"") ? alert.getId() : null);
                        Intrinsics.checkNotNullExpressionValue((Object)indexRequest2, (String)"IndexRequest(alertsIndex\u2026O_ID) alert.id else null)");
                        list = CollectionsKt.listOf((Object)indexRequest2);
                        break;
                    }
                    throw new IllegalStateException("Unexpected attempt to save " + alert.getState() + " alert: " + alert);
                }
                case 4: {
                    String index = this.getAlertIndices().isAlertHistoryEnabled() ? dataSources.getAlertsHistoryIndex() : dataSources.getAlertsIndex();
                    IndexRequest indexRequest = new IndexRequest(index).routing(routingId);
                    XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
                    XContentBuilder xContentBuilder2 = indexRequest.source(alert.toXContentWithUser(xContentBuilder)).id(!Intrinsics.areEqual((Object)alert.getId(), (Object)"") ? alert.getId() : null);
                    Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"IndexRequest(index)\n    \u2026O_ID) alert.id else null)");
                    list = CollectionsKt.listOf((Object)xContentBuilder2);
                    break;
                }
                case 5: {
                    throw new IllegalStateException("Unexpected attempt to save " + alert.getState() + " alert: " + alert);
                }
                case 6: {
                    IndexRequest indexRequest;
                    XContentBuilder xContentBuilder2;
                    IndexRequest indexRequest2 = new DocWriteRequest[2];
                    indexRequest2[0] = (DocWriteRequest)new DeleteRequest(alertsIndex, alert.getId()).routing(routingId);
                    if (this.getAlertIndices().isAlertHistoryEnabled()) {
                        IndexRequest indexRequest3 = new IndexRequest(alertsHistoryIndex).routing(routingId);
                        xContentBuilder2 = XContentFactory.jsonBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"jsonBuilder()");
                        indexRequest = indexRequest3.source(alert.toXContentWithUser(xContentBuilder2)).id(alert.getId());
                    } else {
                        indexRequest = null;
                    }
                    indexRequest2[1] = (DocWriteRequest)indexRequest;
                    list = CollectionsKt.listOfNotNull((Object[])indexRequest2);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        objectRef.element = (List)destination$iv$iv;
        if (((List)requestsToRetry.element).isEmpty()) {
            return Unit.INSTANCE;
        }
        iterable = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"logger");
        Object object = OpenSearchExtensionsKt.retry((BackoffPolicy)retryPolicy, (Logger)iterable, (List)CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(requestsToRetry, this, null){
            Object L$0;
            int label;
            final /* synthetic */ Ref.ObjectRef<List<DocWriteRequest<?>>> $requestsToRetry;
            final /* synthetic */ AlertService this$0;
            {
                this.$requestsToRetry = $requestsToRetry;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        bulkRequest = new BulkRequest().add((Iterable)this.$requestsToRetry.element).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        this.L$0 = bulkRequest;
                        this.label = 1;
                        v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.this$0.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(this.this$0, bulkRequest){
                            final /* synthetic */ AlertService this$0;
                            final /* synthetic */ BulkRequest $bulkRequest;
                            {
                                this.this$0 = $receiver;
                                this.$bulkRequest = $bulkRequest;
                                super(2);
                            }

                            public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                this.this$0.getClient().bulk(this.$bulkRequest, it);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        bulkRequest = (BulkRequest)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if ((v1 = (bulkResponse = (BulkResponse)v0).getItems()) == null) {
                            v1 = new BulkItemResponse[]{};
                        }
                        $this$filter$iv = v1;
                        $i$f$filter = false;
                        var7_8 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (void element$iv$iv : $this$filterTo$iv$iv) {
                            it = element$iv$iv;
                            $i$a$-filter-AlertService$saveAlerts$2$failedResponses$1 = false;
                            if (!it.isFailed()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        failedResponses = (List)destination$iv$iv;
                        $this$filter$iv = failedResponses;
                        var16_26 = this.$requestsToRetry;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        var10_13 = $this$filterTo$iv$iv.iterator();
                        while (var10_13.hasNext()) {
                            element$iv$iv = var10_13.next();
                            it = (BulkItemResponse)element$iv$iv;
                            $i$a$-filter-AlertService$saveAlerts$2$1 = false;
                            if (!(it.status() == RestStatus.TOO_MANY_REQUESTS)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (BulkItemResponse)item$iv$iv;
                            var17_27 = destination$iv$iv;
                            $i$a$-map-AlertService$saveAlerts$2$2 = false;
                            v2 = bulkRequest.requests().get(it.getItemId());
                            if (v2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.opensearch.action.index.IndexRequest");
                            }
                            var17_27.add((IndexRequest)v2);
                        }
                        var16_26.element = (List)destination$iv$iv;
                        if (!(((Collection)this.$requestsToRetry.element).isEmpty() == false)) ** GOTO lbl75
                        $this$first$iv = failedResponses;
                        $i$f$first = false;
                        for (T element$iv : $this$first$iv) {
                            it = (BulkItemResponse)element$iv;
                            $i$a$-first-AlertService$saveAlerts$2$retryCause$1 = false;
                            if (!(it.status() == RestStatus.TOO_MANY_REQUESTS)) continue;
                            ** GOTO lbl71
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl71:
                        // 1 sources

                        retryCause = ((BulkItemResponse)element$iv).getFailure().getCause();
                        var6_7 = ExceptionsHelper.convertToOpenSearchException((Exception)retryCause);
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"convertToOpenSearchException(retryCause)");
                        throw (Throwable)var6_7;
lbl75:
                        // 1 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object saveAlerts$default(AlertService alertService, DataSources dataSources, List list, BackoffPolicy backoffPolicy, boolean bl, String string, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return alertService.saveAlerts(dataSources, list, backoffPolicy, bl, string, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object saveNewAlerts(@NotNull DataSources var1_1, @NotNull List<Alert> var2_2, @NotNull BackoffPolicy var3_3, @NotNull Continuation<? super List<Alert>> var4_4) {
        if (!(var4_4 instanceof saveNewAlerts.1)) ** GOTO lbl-1000
        var22_5 = var4_4;
        if ((var22_5.label & -2147483648) != 0) {
            var22_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AlertService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveNewAlerts(null, null, null, (Continuation<? super List<Alert>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                savedAlerts = new ArrayList<E>();
                alertsBeingIndexed = new Ref.ObjectRef();
                alertsBeingIndexed.element = alerts;
                requestsToRetry = new Ref.ObjectRef();
                var8_11 = (Iterable)alerts;
                var19_12 = requestsToRetry;
                $i$f$map = false;
                var10_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var15_19 = (Alert)item$iv$iv;
                    var20_23 = destination$iv$iv;
                    $i$a$-map-AlertService$saveNewAlerts$requestsToRetry$1 = false;
                    if (alert.getState() != Alert.State.ACTIVE && alert.getState() != Alert.State.AUDIT) {
                        throw new IllegalStateException("Unexpected attempt to save new alert [" + (Alert)alert + "] with state [" + alert.getState() + "]");
                    }
                    if (!Intrinsics.areEqual((Object)alert.getId(), (Object)"")) {
                        throw new IllegalStateException("Unexpected attempt to save new alert [" + (Alert)alert + "] with an existing alert ID [" + alert.getId() + "]");
                    }
                    alertIndex = alert.getState() == Alert.State.AUDIT && this.getAlertIndices().isAlertHistoryEnabled() != false ? dataSources.getAlertsHistoryIndex() : dataSources.getAlertsIndex();
                    v0 = new IndexRequest(alertIndex).routing(alert.getMonitorId());
                    var18_22 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)var18_22, (String)"jsonBuilder()");
                    var20_23.add(v0.source(alert.toXContentWithUser(var18_22)));
                }
                var19_12.element = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                if (((List)requestsToRetry.element).isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                var8_11 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var8_11, (String)"logger");
                $continuation.L$0 = savedAlerts;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.retry((BackoffPolicy)retryPolicy, (Logger)var8_11, (List)CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>((Ref.ObjectRef<List<IndexRequest>>)requestsToRetry, this, (Ref.ObjectRef<List<Alert>>)alertsBeingIndexed, (List<Alert>)savedAlerts, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ Ref.ObjectRef<List<IndexRequest>> $requestsToRetry;
                    final /* synthetic */ AlertService this$0;
                    final /* synthetic */ Ref.ObjectRef<List<Alert>> $alertsBeingIndexed;
                    final /* synthetic */ List<Alert> $savedAlerts;
                    {
                        this.$requestsToRetry = $requestsToRetry;
                        this.this$0 = $receiver;
                        this.$alertsBeingIndexed = $alertsBeingIndexed;
                        this.$savedAlerts = $savedAlerts;
                        super(1, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                bulkRequest = new BulkRequest().add((Iterable)this.$requestsToRetry.element).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                this.L$0 = bulkRequest;
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.this$0.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(this.this$0, bulkRequest){
                                    final /* synthetic */ AlertService this$0;
                                    final /* synthetic */ BulkRequest $bulkRequest;
                                    {
                                        this.this$0 = $receiver;
                                        this.$bulkRequest = $bulkRequest;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        this.this$0.getClient().bulk(this.$bulkRequest, it);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var18_2) {
                                    return var18_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                bulkRequest = (BulkRequest)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                if ((v1 = (bulkResponse = (BulkResponse)v0).getItems()) == null) {
                                    v1 = new BulkItemResponse[]{};
                                }
                                $this$filter$iv = v1;
                                $i$f$filter = false;
                                var7_8 = $this$filter$iv;
                                destination$iv$iv = (Ref.ObjectRef<List<Alert>>)new ArrayList<E>();
                                $i$f$filterTo = false;
                                var10_13 = $this$filterTo$iv$iv;
                                var12_18 = ((void)var10_13).length;
                                for (var11_16 = 0; var11_16 < var12_18; ++var11_16) {
                                    element$iv$iv = var10_13[var11_16];
                                    it = element$iv$iv;
                                    $i$a$-filter-AlertService$saveNewAlerts$2$failedResponses$1 = false;
                                    if (!it.isFailed()) continue;
                                    destination$iv$iv.add((List<Alert>)element$iv$iv);
                                }
                                failedResponses = (List)destination$iv$iv;
                                this.$requestsToRetry.element = new ArrayList<E>();
                                alertsBeingRetried = new ArrayList<E>();
                                $i$f$filter /* !! */  = bulkResponse.getItems();
                                Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter /* !! */ , (String)"bulkResponse.items");
                                $i$f$filter /* !! */  = $i$f$filter /* !! */ ;
                                $this$filterTo$iv$iv = this.$requestsToRetry;
                                destination$iv$iv = this.$alertsBeingIndexed;
                                var9_12 = this.$savedAlerts;
                                $i$f$forEach = false;
                                for (void element$iv : $this$forEach$iv) {
                                    item = (BulkItemResponse)element$iv;
                                    $i$a$-forEach-AlertService$saveNewAlerts$2$1 = false;
                                    if (item.isFailed()) {
                                        if (item.status() != RestStatus.TOO_MANY_REQUESTS) continue;
                                        v2 = bulkRequest.requests().get(item.getItemId());
                                        if (v2 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type org.opensearch.action.index.IndexRequest");
                                        }
                                        ((List)$this$filterTo$iv$iv.element).add((IndexRequest)v2);
                                        alertsBeingRetried.add(((List)destination$iv$iv.element).get(item.getItemId()));
                                        continue;
                                    }
                                    v3 = (Alert)((List)destination$iv$iv.element).get(item.getItemId());
                                    var17_26 = item.getId();
                                    Intrinsics.checkNotNullExpressionValue((Object)var17_26, (String)"item.id");
                                    var9_12.add(Alert.copy$default((Alert)v3, (String)var17_26, (long)0L, (int)0, null, null, null, null, (long)0L, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (int)0x1FFFFFE, null));
                                }
                                this.$alertsBeingIndexed.element = alertsBeingRetried;
                                if (!(((Collection)this.$requestsToRetry.element).isEmpty() == false)) ** GOTO lbl77
                                $this$first$iv = failedResponses;
                                $i$f$first = false;
                                for (E element$iv : $this$first$iv) {
                                    it = (BulkItemResponse)element$iv;
                                    $i$a$-first-AlertService$saveNewAlerts$2$retryCause$1 = false;
                                    if (!(it.status() == RestStatus.TOO_MANY_REQUESTS)) continue;
                                    ** GOTO lbl73
                                }
                                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl73:
                                // 1 sources

                                retryCause = ((BulkItemResponse)element$iv).getFailure().getCause();
                                var7_8 = ExceptionsHelper.convertToOpenSearchException((Exception)retryCause);
                                Intrinsics.checkNotNullExpressionValue((Object)var7_8, (String)"convertToOpenSearchException(retryCause)");
                                throw (Throwable)var7_8;
lbl77:
                                // 1 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var23_7) {
                    return var23_7;
                }
                ** GOTO lbl52
            }
            case 1: {
                savedAlerts = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl52:
                // 2 sources

                return savedAlerts;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final XContentParser contentParser(BytesReference bytesReference) {
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)bytesReference, (MediaType)((MediaType)XContentType.JSON));
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
        return xcp;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object searchAlerts(Monitor var1_1, int var2_2, WorkflowRunContext var3_3, Continuation<? super SearchResponse> var4_4) {
        if (!(var4_4 instanceof searchAlerts.1)) ** GOTO lbl-1000
        var12_5 = var4_4;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ AlertService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertService.access$searchAlerts(this.this$0, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                monitorId = monitor.getId();
                alertIndex = monitor.getDataSources().getAlertsIndex();
                queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)monitorId));
                if (workflowRunContext != null) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"workflow_id", (String)workflowRunContext.getWorkflowId()));
                }
                searchSourceBuilder = new SearchSourceBuilder().size((int)size).query((QueryBuilder)queryBuilder);
                var10_12 = new String[]{alertIndex};
                searchRequest = new SearchRequest(var10_12).routing(monitorId).source(searchSourceBuilder);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this, searchRequest){
                    final /* synthetic */ AlertService this$0;
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.this$0 = $receiver;
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        this.this$0.getClient().search(this.$searchRequest, it);
                    }
                }), (Continuation)$continuation);
                if (v0 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl29
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                if ((searchResponse = (SearchResponse)v0).status() != RestStatus.OK) {
                    v1 = OpenSearchExtensionsKt.firstFailureOrNull((SearchResponse)searchResponse);
                    v2 /* !! */  = v1 == null ? null : v1.getCause();
                    if (v2 /* !! */  == null) {
                        v2 /* !! */  = new RuntimeException("Unknown error loading alerts");
                    }
                    throw v2 /* !! */ ;
                }
                return searchResponse;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<AlertError> update(List<AlertError> $this$update, AlertError alertError) {
        List list;
        if ($this$update == null && alertError == null) {
            list = CollectionsKt.emptyList();
        } else if ($this$update != null && alertError == null) {
            list = $this$update;
        } else if ($this$update == null && alertError != null) {
            list = CollectionsKt.listOf((Object)alertError);
        } else if ($this$update != null && alertError != null) {
            list = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)alertError), (Iterable)$this$update), (int)10);
        } else {
            throw new IllegalStateException("Unreachable code reached!");
        }
        return list;
    }

    public static final /* synthetic */ Object access$searchAlerts(AlertService $this, Monitor monitor, int size, WorkflowRunContext workflowRunContext, Continuation $completion) {
        return $this.searchAlerts(monitor, size, workflowRunContext, (Continuation<? super SearchResponse>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/alerting/AlertService$Companion;", "", "()V", "ALERTS_SEARCH_TIMEOUT", "Lorg/opensearch/common/unit/TimeValue;", "getALERTS_SEARCH_TIMEOUT", "()Lorg/opensearch/common/unit/TimeValue;", "ERROR_ALERT_ID_PREFIX", "", "MAX_BUCKET_LEVEL_MONITOR_ALERT_SEARCH_COUNT", "", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeValue getALERTS_SEARCH_TIMEOUT() {
            return ALERTS_SEARCH_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Alert.State.values().length];
            nArray[Alert.State.ACTIVE.ordinal()] = 1;
            nArray[Alert.State.ERROR.ordinal()] = 2;
            nArray[Alert.State.ACKNOWLEDGED.ordinal()] = 3;
            nArray[Alert.State.AUDIT.ordinal()] = 4;
            nArray[Alert.State.DELETED.ordinal()] = 5;
            nArray[Alert.State.COMPLETED.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

