/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.model.InputRunResults;
import org.opensearch.alerting.model.TriggerAfterKey;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.support.AggregationPath;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/alerting/util/AggregationQueryRewriter;", "", "()V", "Companion", "opensearch-alerting"})
public final class AggregationQueryRewriter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/alerting/util/AggregationQueryRewriter$Companion;", "", "()V", "getAfterKeysFromSearchResponse", "", "", "Lorg/opensearch/alerting/model/TriggerAfterKey;", "searchResponse", "Lorg/opensearch/action/search/SearchResponse;", "triggers", "", "Lorg/opensearch/commons/alerting/model/Trigger;", "prevBucketLevelTriggerAfterKeys", "rewriteQuery", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "query", "prevResult", "Lorg/opensearch/alerting/model/InputRunResults;", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SearchSourceBuilder rewriteQuery(@NotNull SearchSourceBuilder query, @Nullable InputRunResults prevResult, @NotNull List<? extends Trigger> triggers) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
            Iterable $this$forEach$iv = triggers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TriggerAfterKey triggerAfterKey;
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                if (!(trigger instanceof BucketLevelTrigger)) continue;
                query.aggregation((PipelineAggregationBuilder)((BucketLevelTrigger)trigger).getBucketSelector());
                InputRunResults inputRunResults = prevResult;
                if (inputRunResults == null) {
                    triggerAfterKey = null;
                } else {
                    Map<String, TriggerAfterKey> map = inputRunResults.getAggTriggersAfterKey();
                    triggerAfterKey = map == null ? null : map.get(trigger.getId());
                }
                if (triggerAfterKey == null) continue;
                AggregationPath parentBucketPath = AggregationPath.parse((String)((BucketLevelTrigger)trigger).getBucketSelector().getParentBucketPath());
                AggregatorFactories.Builder builder = query.aggregations();
                if (builder == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.search.aggregations.AggregatorFactories.Builder");
                }
                Collection aggBuilders = builder.getAggregatorFactories();
                AggregationBuilder factory = null;
                int n = 0;
                int n2 = parentBucketPath.getPathElements().size();
                while (n < n2) {
                    int i = n++;
                    factory = null;
                    for (AggregationBuilder aggFactory : aggBuilders) {
                        if (!aggFactory.getName().equals(((AggregationPath.PathElement)parentBucketPath.getPathElements().get((int)i)).name)) continue;
                        aggBuilders = aggFactory.getSubAggregations();
                        factory = aggFactory;
                        break;
                    }
                    if (factory != null) continue;
                    throw new IllegalArgumentException("ParentBucketPath: " + parentBucketPath + " not found in input query results");
                }
                if (factory instanceof CompositeAggregationBuilder) {
                    TriggerAfterKey triggerAfterKey2 = prevResult.getAggTriggersAfterKey().get(trigger.getId());
                    Intrinsics.checkNotNull((Object)triggerAfterKey2);
                    Map<String, Object> afterKey = triggerAfterKey2.getAfterKey();
                    ((CompositeAggregationBuilder)factory).aggregateAfter(afterKey);
                    continue;
                }
                throw new IllegalStateException("AfterKeys are not expected to be present in non CompositeAggregationBuilder");
            }
            return query;
        }

        @NotNull
        public final Map<String, TriggerAfterKey> getAfterKeysFromSearchResponse(@NotNull SearchResponse searchResponse2, @NotNull List<? extends Trigger> triggers, @Nullable Map<String, TriggerAfterKey> prevBucketLevelTriggerAfterKeys) {
            Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
            Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
            Map bucketLevelTriggerAfterKeys = new LinkedHashMap();
            Iterable $this$forEach$iv = triggers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                if (!(trigger instanceof BucketLevelTrigger)) continue;
                AggregationPath parentBucketPath = AggregationPath.parse((String)((BucketLevelTrigger)trigger).getBucketSelector().getParentBucketPath());
                Aggregations aggs = searchResponse2.getAggregations();
                int n = 0;
                int n2 = parentBucketPath.getPathElements().size() - 1;
                while (n < n2) {
                    int i = n++;
                    Object v = aggs.asMap().get(((AggregationPath.PathElement)parentBucketPath.getPathElements().get((int)i)).name);
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.opensearch.search.aggregations.bucket.SingleBucketAggregation");
                    }
                    aggs = ((SingleBucketAggregation)v).getAggregations();
                }
                Map map = aggs.getAsMap();
                List list = parentBucketPath.getPathElements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parentBucketPath.pathElements");
                Aggregation lastAgg = (Aggregation)map.get(((AggregationPath.PathElement)CollectionsKt.last((List)list)).name);
                if (!(lastAgg instanceof CompositeAggregation)) continue;
                Map afterKey = ((CompositeAggregation)lastAgg).afterKey();
                Map<String, TriggerAfterKey> map2 = prevBucketLevelTriggerAfterKeys;
                TriggerAfterKey prevTriggerAfterKey = map2 == null ? null : map2.get(trigger.getId());
                bucketLevelTriggerAfterKeys.put(trigger.getId(), prevTriggerAfterKey == null ? new TriggerAfterKey(afterKey, afterKey == null) : (prevTriggerAfterKey.getLastPage() ? prevTriggerAfterKey : (afterKey == null ? new TriggerAfterKey(prevTriggerAfterKey.getAfterKey(), true) : new TriggerAfterKey(afterKey, false))));
            }
            return bucketLevelTriggerAfterKeys;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

