/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.model.ActionRunResult;
import org.opensearch.alerting.model.MonitorRunResultKt;
import org.opensearch.alerting.model.TriggerRunResult;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.script.ScriptException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\u0011\u0010$\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bH\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003JE\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0013\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0016J\t\u00101\u001a\u00020\u0006H\u00d6\u0001J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00067"}, d2={"Lorg/opensearch/alerting/model/QueryLevelTriggerRunResult;", "Lorg/opensearch/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "triggerName", "", "triggered", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "actionResults", "", "Lorg/opensearch/alerting/model/ActionRunResult;", "(Ljava/lang/String;ZLjava/lang/Exception;Ljava/util/Map;)V", "getActionResults", "()Ljava/util/Map;", "setActionResults", "(Ljava/util/Map;)V", "getError", "()Ljava/lang/Exception;", "setError", "(Ljava/lang/Exception;)V", "getTriggerName", "()Ljava/lang/String;", "setTriggerName", "(Ljava/lang/String;)V", "getTriggered", "()Z", "setTriggered", "(Z)V", "alertError", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "internalXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "toString", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
public final class QueryLevelTriggerRunResult
extends TriggerRunResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String triggerName;
    private boolean triggered;
    @Nullable
    private Exception error;
    @NotNull
    private Map<String, ActionRunResult> actionResults;

    public QueryLevelTriggerRunResult(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        super(triggerName, error);
        this.triggerName = triggerName;
        this.triggered = triggered;
        this.error = error;
        this.actionResults = actionResults;
    }

    public /* synthetic */ QueryLevelTriggerRunResult(String string, boolean bl, Exception exception, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = new LinkedHashMap();
        }
        this(string, bl, exception, map);
    }

    @Override
    @NotNull
    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public void setTriggerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.triggerName = string;
    }

    public final boolean getTriggered() {
        return this.triggered;
    }

    public final void setTriggered(boolean bl) {
        this.triggered = bl;
    }

    @Override
    @Nullable
    public Exception getError() {
        return this.error;
    }

    @Override
    public void setError(@Nullable Exception exception) {
        this.error = exception;
    }

    @NotNull
    public final Map<String, ActionRunResult> getActionResults() {
        return this.actionResults;
    }

    public final void setActionResults(@NotNull Map<String, ActionRunResult> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.actionResults = map;
    }

    public QueryLevelTriggerRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Exception exception = sin.readException();
        boolean bl = sin.readBoolean();
        Map map = sin.readMap();
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, org.opensearch.alerting.model.ActionRunResult>");
        }
        Map map2 = TypeIntrinsics.asMutableMap((Object)map);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString()");
        this(string, bl, exception, map2);
    }

    @Override
    @Nullable
    public AlertError alertError() {
        if (this.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception);
            return new AlertError(instant, "Failed evaluating trigger:\n" + MonitorRunResultKt.userErrorMessage(exception));
        }
        for (ActionRunResult actionResult : this.actionResults.values()) {
            if (actionResult.getError() == null) continue;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            return new AlertError(instant, "Failed running action:\n" + MonitorRunResultKt.userErrorMessage(actionResult.getError()));
        }
        return null;
    }

    @Override
    @NotNull
    public XContentBuilder internalXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.getError() instanceof ScriptException) {
            Exception exception = this.getError();
            if (exception == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.opensearch.script.ScriptException");
            }
            this.setError(new Exception(((ScriptException)exception).toJsonString(), this.getError()));
        }
        XContentBuilder xContentBuilder = builder.field("triggered", this.triggered).field("action_results", this.actionResults);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder\n            .fie\u2026String, ActionRunResult>)");
        return xContentBuilder;
    }

    @Override
    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeBoolean(this.triggered);
        out.writeMap(this.actionResults);
    }

    @NotNull
    public final String component1() {
        return this.getTriggerName();
    }

    public final boolean component2() {
        return this.triggered;
    }

    @Nullable
    public final Exception component3() {
        return this.getError();
    }

    @NotNull
    public final Map<String, ActionRunResult> component4() {
        return this.actionResults;
    }

    @NotNull
    public final QueryLevelTriggerRunResult copy(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        return new QueryLevelTriggerRunResult(triggerName, triggered, error, actionResults);
    }

    public static /* synthetic */ QueryLevelTriggerRunResult copy$default(QueryLevelTriggerRunResult queryLevelTriggerRunResult, String string, boolean bl, Exception exception, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = queryLevelTriggerRunResult.getTriggerName();
        }
        if ((n & 2) != 0) {
            bl = queryLevelTriggerRunResult.triggered;
        }
        if ((n & 4) != 0) {
            exception = queryLevelTriggerRunResult.getError();
        }
        if ((n & 8) != 0) {
            map = queryLevelTriggerRunResult.actionResults;
        }
        return queryLevelTriggerRunResult.copy(string, bl, exception, map);
    }

    @NotNull
    public String toString() {
        return "QueryLevelTriggerRunResult(triggerName=" + this.getTriggerName() + ", triggered=" + this.triggered + ", error=" + this.getError() + ", actionResults=" + this.actionResults + ")";
    }

    public int hashCode() {
        int result = this.getTriggerName().hashCode();
        int n = this.triggered ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + (this.getError() == null ? 0 : this.getError().hashCode());
        result = result * 31 + ((Object)this.actionResults).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueryLevelTriggerRunResult)) {
            return false;
        }
        QueryLevelTriggerRunResult queryLevelTriggerRunResult = (QueryLevelTriggerRunResult)other;
        if (!Intrinsics.areEqual((Object)this.getTriggerName(), (Object)queryLevelTriggerRunResult.getTriggerName())) {
            return false;
        }
        if (this.triggered != queryLevelTriggerRunResult.triggered) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getError(), (Object)queryLevelTriggerRunResult.getError())) {
            return false;
        }
        return Intrinsics.areEqual(this.actionResults, queryLevelTriggerRunResult.actionResults);
    }

    @JvmStatic
    @NotNull
    public static final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/alerting/model/QueryLevelTriggerRunResult$Companion;", "", "()V", "readFrom", "Lorg/opensearch/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new QueryLevelTriggerRunResult(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

