/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.core.model.ClusterMetricsInput;
import org.opensearch.alerting.core.model.CronSchedule;
import org.opensearch.alerting.core.model.Input;
import org.opensearch.alerting.core.model.Schedule;
import org.opensearch.alerting.core.model.ScheduledJob;
import org.opensearch.alerting.core.model.SearchInput;
import org.opensearch.alerting.model.BucketLevelTrigger;
import org.opensearch.alerting.model.DocumentLevelTrigger;
import org.opensearch.alerting.model.QueryLevelTrigger;
import org.opensearch.alerting.model.Trigger;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.SupportedClusterMetricsSettings;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 Y2\u00020\u0001:\u0002YZB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u008f\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018\u0012\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\u0010\u001fJ\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001dJ\t\u0010:\u001a\u00020\u0006H\u00c6\u0003J\t\u0010;\u001a\u00020\u0016H\u00c6\u0003J\u000f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u00c6\u0003J\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u00c6\u0003J\u0015\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001dH\u00c6\u0003J\t\u0010?\u001a\u00020\bH\u00c6\u0003J\t\u0010@\u001a\u00020\u0006H\u00c6\u0003J\t\u0010A\u001a\u00020\u000bH\u00c6\u0003J\t\u0010B\u001a\u00020\rH\u00c6\u0003J\t\u0010C\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010E\u001a\u00020\u0012H\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u00a7\u0001\u0010G\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001dH\u00c6\u0001J \u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u000bH\u0002J\u0013\u0010N\u001a\u00020\u000b2\b\u0010O\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\u0018\u0010P\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010Q\u001a\u00020\u0016H\u00d6\u0001J\t\u0010R\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010S\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020LH\u0016J\u0016\u0010T\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020LJ\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010#R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010%R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010'R\u0014\u00101\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010%R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006["}, d2={"Lorg/opensearch/alerting/model/Monitor;", "Lorg/opensearch/alerting/core/model/ScheduledJob;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "id", "", "version", "", "name", "enabled", "", "schedule", "Lorg/opensearch/alerting/core/model/Schedule;", "lastUpdateTime", "Ljava/time/Instant;", "enabledTime", "monitorType", "Lorg/opensearch/alerting/model/Monitor$MonitorType;", "user", "Lorg/opensearch/commons/authuser/User;", "schemaVersion", "", "inputs", "", "Lorg/opensearch/alerting/core/model/Input;", "triggers", "Lorg/opensearch/alerting/model/Trigger;", "uiMetadata", "", "", "(Ljava/lang/String;JLjava/lang/String;ZLorg/opensearch/alerting/core/model/Schedule;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/alerting/model/Monitor$MonitorType;Lorg/opensearch/commons/authuser/User;ILjava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getEnabled", "()Z", "getEnabledTime", "()Ljava/time/Instant;", "getId", "()Ljava/lang/String;", "getInputs", "()Ljava/util/List;", "getLastUpdateTime", "getMonitorType", "()Lorg/opensearch/alerting/model/Monitor$MonitorType;", "getName", "getSchedule", "()Lorg/opensearch/alerting/core/model/Schedule;", "getSchemaVersion", "()I", "getTriggers", "type", "getType", "getUiMetadata", "()Ljava/util/Map;", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getVersion", "()J", "asTemplateArg", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "createXContentBuilder", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "secure", "equals", "other", "fromDocument", "hashCode", "toString", "toXContent", "toXContentWithUser", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "MonitorType", "opensearch-alerting"})
public final class Monitor
implements ScheduledJob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long version;
    @NotNull
    private final String name;
    private final boolean enabled;
    @NotNull
    private final Schedule schedule;
    @NotNull
    private final Instant lastUpdateTime;
    @Nullable
    private final Instant enabledTime;
    @NotNull
    private final MonitorType monitorType;
    @Nullable
    private final User user;
    private final int schemaVersion;
    @NotNull
    private final List<Input> inputs;
    @NotNull
    private final List<Trigger> triggers;
    @NotNull
    private final Map<String, Object> uiMetadata;
    @NotNull
    private final String type;
    @NotNull
    public static final String MONITOR_TYPE = "monitor";
    @NotNull
    public static final String TYPE_FIELD = "type";
    @NotNull
    public static final String MONITOR_TYPE_FIELD = "monitor_type";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String USER_FIELD = "user";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String TRIGGERS_FIELD = "triggers";
    @NotNull
    public static final String NO_ID = "";
    public static final long NO_VERSION = 1L;
    @NotNull
    public static final String INPUTS_FIELD = "inputs";
    @NotNull
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    @NotNull
    public static final String UI_METADATA_FIELD = "ui_metadata";
    @NotNull
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    @NotNull
    private static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(ScheduledJob.class, new ParseField("monitor", new String[0]), Monitor::XCONTENT_REGISTRY$lambda-13);

    public Monitor(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @NotNull MonitorType monitorType, @Nullable User user, int schemaVersion, @NotNull List<? extends Input> inputs, @NotNull List<? extends Trigger> triggers, @NotNull Map<String, ? extends Object> uiMetadata) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)schedule, (String)SCHEDULE_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)monitorType), (String)"monitorType");
        Intrinsics.checkNotNullParameter(inputs, (String)INPUTS_FIELD);
        Intrinsics.checkNotNullParameter(triggers, (String)TRIGGERS_FIELD);
        Intrinsics.checkNotNullParameter(uiMetadata, (String)"uiMetadata");
        this.id = id;
        this.version = version;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.monitorType = monitorType;
        this.user = user;
        this.schemaVersion = schemaVersion;
        this.inputs = inputs;
        this.triggers = triggers;
        this.uiMetadata = uiMetadata;
        this.type = MONITOR_TYPE;
        Set triggerIds = new LinkedHashSet();
        Iterable $this$forEach$iv = this.triggers;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Trigger trigger = (Trigger)element$iv;
            boolean bl = false;
            if (!triggerIds.add(trigger.getId())) {
                boolean $i$a$-require-Monitor$1$62 = false;
                String $i$a$-require-Monitor$1$62 = "Duplicate trigger id: " + trigger.getId() + ". Trigger ids must be unique.";
                throw new IllegalArgumentException($i$a$-require-Monitor$1$62.toString());
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.getMonitorType().ordinal()]) {
                case 1: {
                    if (trigger instanceof QueryLevelTrigger) break;
                    boolean $i$a$-require-Monitor$1$72 = false;
                    String $i$a$-require-Monitor$1$72 = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.getMonitorType() + "]";
                    throw new IllegalArgumentException($i$a$-require-Monitor$1$72.toString());
                }
                case 2: {
                    if (trigger instanceof BucketLevelTrigger) break;
                    boolean $i$a$-require-Monitor$1$82 = false;
                    String $i$a$-require-Monitor$1$82 = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.getMonitorType() + "]";
                    throw new IllegalArgumentException($i$a$-require-Monitor$1$82.toString());
                }
                case 3: {
                    if (trigger instanceof QueryLevelTrigger) break;
                    boolean $i$a$-require-Monitor$1$92 = false;
                    String $i$a$-require-Monitor$1$92 = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.getMonitorType() + "]";
                    throw new IllegalArgumentException($i$a$-require-Monitor$1$92.toString());
                }
                case 4: {
                    if (trigger instanceof DocumentLevelTrigger) break;
                    boolean bl2 = false;
                    String string = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.getMonitorType() + "]";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }
        if (this.getEnabled()) {
            if (this.getEnabledTime() == null) {
                String $i$f$forEach2 = "Required value was null.";
                throw new IllegalArgumentException($i$f$forEach2.toString());
            }
        } else if (!(this.getEnabledTime() == null)) {
            String $i$f$forEach2 = "Failed requirement.";
            throw new IllegalArgumentException($i$f$forEach2.toString());
        }
        if (!(this.inputs.size() <= 1)) {
            boolean $i$a$-require-Monitor$42 = false;
            String $i$a$-require-Monitor$42 = "Monitors can only have 1 search input.";
            throw new IllegalArgumentException($i$a$-require-Monitor$42.toString());
        }
        if (!(this.triggers.size() <= 10)) {
            boolean $i$a$-require-Monitor$52 = false;
            String $i$a$-require-Monitor$52 = "Monitors can only support up to 10 triggers.";
            throw new IllegalArgumentException($i$a$-require-Monitor$52.toString());
        }
        if (AlertingUtilsKt.isBucketLevelMonitor(this)) {
            $this$forEach$iv = this.inputs;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Input input = (Input)element$iv;
                boolean bl = false;
                if (!(input instanceof SearchInput)) {
                    boolean $i$a$-require-Monitor$4$32 = false;
                    String $i$a$-require-Monitor$4$32 = "Unsupported input [" + input + "] for Monitor";
                    throw new IllegalArgumentException($i$a$-require-Monitor$4$32.toString());
                }
                if (((SearchInput)input).getQuery().aggregations() != null && !((SearchInput)input).getQuery().aggregations().getAggregatorFactories().isEmpty()) continue;
                boolean bl3 = false;
                String string = "At least one aggregation is required for the input [" + input + "]";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ Monitor(String string, long l, String string2, boolean bl, Schedule schedule, Instant instant, Instant instant2, MonitorType monitorType, User user, int n, List list, List list2, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = NO_ID;
        }
        if ((n2 & 2) != 0) {
            l = 1L;
        }
        if ((n2 & 0x200) != 0) {
            n = 0;
        }
        this(string, l, string2, bl, schedule, instant, instant2, monitorType, user, n, list, list2, map);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public Schedule getSchedule() {
        return this.schedule;
    }

    @NotNull
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Nullable
    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    @NotNull
    public final MonitorType getMonitorType() {
        return this.monitorType;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    public final int getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final List<Input> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final List<Trigger> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public final Map<String, Object> getUiMetadata() {
        return this.uiMetadata;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public Monitor(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Object object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string = object;
        long l = sin.readLong();
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string2 = object;
        boolean bl = sin.readBoolean();
        Schedule schedule = Schedule.Companion.readFrom(sin);
        object = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readInstant()");
        Object object2 = object;
        Instant instant = sin.readOptionalInstant();
        object = sin.readEnum(MonitorType.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readEnum(MonitorType::class.java)");
        MonitorType monitorType = (MonitorType)((Object)object);
        User user = sin.readBoolean() ? new User(sin) : null;
        int n = sin.readInt();
        object = sin.readList(arg_0 -> ((Input.Companion)Input.Companion).readFrom(arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readList((Input)::readFrom)");
        Object object3 = object;
        object = sin.readList(Trigger.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readList((Trigger)::readFrom)");
        this(string, l, string2, bl, schedule, (Instant)object2, instant, monitorType, user, n, (List<? extends Input>)object3, (List<? extends Trigger>)object, Companion.suppressWarning(sin.readMap()));
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_id", (Object)this.getId()), TuplesKt.to((Object)"_version", (Object)this.getVersion()), TuplesKt.to((Object)NAME_FIELD, (Object)this.getName()), TuplesKt.to((Object)ENABLED_FIELD, (Object)this.getEnabled())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, false);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, true);
    }

    private final XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params, boolean secure) {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(this.getType());
        }
        builder.field(TYPE_FIELD, this.getType()).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(NAME_FIELD, this.getName()).field(MONITOR_TYPE_FIELD, (Object)this.monitorType);
        if (!secure) {
            OpenSearchExtensionsKt.optionalUserField((XContentBuilder)builder, (String)USER_FIELD, (User)this.user);
        }
        XContentBuilder xContentBuilder = builder.field(ENABLED_FIELD, this.getEnabled());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(ENABLED_FIELD, enabled)");
        Collection $this$toTypedArray$iv = this.inputs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Input[] inputArray = thisCollection$iv.toArray(new Input[0]);
        if (inputArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        $this$toTypedArray$iv = this.triggers;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Trigger[] triggerArray = thisCollection$iv.toArray(new Trigger[0]);
        if (triggerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)xContentBuilder, (String)ENABLED_TIME_FIELD, (Instant)this.getEnabledTime()).field(SCHEDULE_FIELD, (ToXContent)this.getSchedule()).field(INPUTS_FIELD, (Object)inputArray).field(TRIGGERS_FIELD, (Object)triggerArray);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.field(ENABLED_FI\u2026 triggers.toTypedArray())");
        OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)xContentBuilder2, (String)LAST_UPDATE_TIME_FIELD, (Instant)this.getLastUpdateTime());
        if (!this.uiMetadata.isEmpty()) {
            builder.field(UI_METADATA_FIELD, this.uiMetadata);
        }
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        xContentBuilder2 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.endObject()");
        return xContentBuilder2;
    }

    @NotNull
    public Monitor fromDocument(@NotNull String id, long version) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Monitor.copy$default(this, id, version, null, false, null, null, null, null, null, 0, null, null, null, 8188, null);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Object it;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getId());
        out.writeLong(this.getVersion());
        out.writeString(this.getName());
        out.writeBoolean(this.getEnabled());
        if (this.getSchedule() instanceof CronSchedule) {
            out.writeEnum((Enum)Schedule.TYPE.CRON);
        } else {
            out.writeEnum((Enum)Schedule.TYPE.INTERVAL);
        }
        this.getSchedule().writeTo(out);
        out.writeInstant(this.getLastUpdateTime());
        out.writeOptionalInstant(this.getEnabledTime());
        out.writeEnum((Enum)this.monitorType);
        out.writeBoolean(this.user != null);
        User user = this.user;
        if (user != null) {
            user.writeTo(out);
        }
        out.writeInt(this.schemaVersion);
        out.writeVInt(this.inputs.size());
        Iterable $this$forEach$iv = this.inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Input)element$iv;
            boolean bl = false;
            if (it instanceof SearchInput) {
                out.writeEnum((Enum)Input.Type.SEARCH_INPUT);
            } else {
                out.writeEnum((Enum)Input.Type.DOCUMENT_LEVEL_INPUT);
            }
            it.writeTo(out);
        }
        out.writeVInt(this.triggers.size());
        $this$forEach$iv = this.triggers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Trigger)element$iv;
            boolean bl = false;
            Object object = it;
            if (object instanceof BucketLevelTrigger) {
                out.writeEnum((Enum)Trigger.Type.BUCKET_LEVEL_TRIGGER);
            } else if (object instanceof DocumentLevelTrigger) {
                out.writeEnum((Enum)Trigger.Type.DOCUMENT_LEVEL_TRIGGER);
            } else {
                out.writeEnum((Enum)Trigger.Type.QUERY_LEVEL_TRIGGER);
            }
            it.writeTo(out);
        }
        out.writeMap(this.uiMetadata);
    }

    @NotNull
    public XContentBuilder toXContentWithType(@NotNull XContentBuilder builder) {
        return ScheduledJob.DefaultImpls.toXContentWithType((ScheduledJob)this, (XContentBuilder)builder);
    }

    @NotNull
    public final String component1() {
        return this.getId();
    }

    public final long component2() {
        return this.getVersion();
    }

    @NotNull
    public final String component3() {
        return this.getName();
    }

    public final boolean component4() {
        return this.getEnabled();
    }

    @NotNull
    public final Schedule component5() {
        return this.getSchedule();
    }

    @NotNull
    public final Instant component6() {
        return this.getLastUpdateTime();
    }

    @Nullable
    public final Instant component7() {
        return this.getEnabledTime();
    }

    @NotNull
    public final MonitorType component8() {
        return this.monitorType;
    }

    @Nullable
    public final User component9() {
        return this.user;
    }

    public final int component10() {
        return this.schemaVersion;
    }

    @NotNull
    public final List<Input> component11() {
        return this.inputs;
    }

    @NotNull
    public final List<Trigger> component12() {
        return this.triggers;
    }

    @NotNull
    public final Map<String, Object> component13() {
        return this.uiMetadata;
    }

    @NotNull
    public final Monitor copy(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @NotNull MonitorType monitorType, @Nullable User user, int schemaVersion, @NotNull List<? extends Input> inputs, @NotNull List<? extends Trigger> triggers, @NotNull Map<String, ? extends Object> uiMetadata) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)schedule, (String)SCHEDULE_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)monitorType), (String)"monitorType");
        Intrinsics.checkNotNullParameter(inputs, (String)INPUTS_FIELD);
        Intrinsics.checkNotNullParameter(triggers, (String)TRIGGERS_FIELD);
        Intrinsics.checkNotNullParameter(uiMetadata, (String)"uiMetadata");
        return new Monitor(id, version, name, enabled, schedule, lastUpdateTime, enabledTime, monitorType, user, schemaVersion, inputs, triggers, uiMetadata);
    }

    public static /* synthetic */ Monitor copy$default(Monitor monitor, String string, long l, String string2, boolean bl, Schedule schedule, Instant instant, Instant instant2, MonitorType monitorType, User user, int n, List list, List list2, Map map, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = monitor.getId();
        }
        if ((n2 & 2) != 0) {
            l = monitor.getVersion();
        }
        if ((n2 & 4) != 0) {
            string2 = monitor.getName();
        }
        if ((n2 & 8) != 0) {
            bl = monitor.getEnabled();
        }
        if ((n2 & 0x10) != 0) {
            schedule = monitor.getSchedule();
        }
        if ((n2 & 0x20) != 0) {
            instant = monitor.getLastUpdateTime();
        }
        if ((n2 & 0x40) != 0) {
            instant2 = monitor.getEnabledTime();
        }
        if ((n2 & 0x80) != 0) {
            monitorType = monitor.monitorType;
        }
        if ((n2 & 0x100) != 0) {
            user = monitor.user;
        }
        if ((n2 & 0x200) != 0) {
            n = monitor.schemaVersion;
        }
        if ((n2 & 0x400) != 0) {
            list = monitor.inputs;
        }
        if ((n2 & 0x800) != 0) {
            list2 = monitor.triggers;
        }
        if ((n2 & 0x1000) != 0) {
            map = monitor.uiMetadata;
        }
        return monitor.copy(string, l, string2, bl, schedule, instant, instant2, monitorType, user, n, list, list2, map);
    }

    @NotNull
    public String toString() {
        return "Monitor(id=" + this.getId() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", enabled=" + this.getEnabled() + ", schedule=" + this.getSchedule() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", enabledTime=" + this.getEnabledTime() + ", monitorType=" + this.monitorType + ", user=" + this.user + ", schemaVersion=" + this.schemaVersion + ", inputs=" + this.inputs + ", triggers=" + this.triggers + ", uiMetadata=" + this.uiMetadata + ")";
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = result * 31 + Long.hashCode(this.getVersion());
        result = result * 31 + this.getName().hashCode();
        int n = this.getEnabled() ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.getSchedule().hashCode();
        result = result * 31 + this.getLastUpdateTime().hashCode();
        result = result * 31 + (this.getEnabledTime() == null ? 0 : this.getEnabledTime().hashCode());
        result = result * 31 + this.monitorType.hashCode();
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + Integer.hashCode(this.schemaVersion);
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + ((Object)this.triggers).hashCode();
        result = result * 31 + ((Object)this.uiMetadata).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Monitor)) {
            return false;
        }
        Monitor monitor = (Monitor)other;
        if (!Intrinsics.areEqual((Object)this.getId(), (Object)monitor.getId())) {
            return false;
        }
        if (this.getVersion() != monitor.getVersion()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)monitor.getName())) {
            return false;
        }
        if (this.getEnabled() != monitor.getEnabled()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getSchedule(), (Object)monitor.getSchedule())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getLastUpdateTime(), (Object)monitor.getLastUpdateTime())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getEnabledTime(), (Object)monitor.getEnabledTime())) {
            return false;
        }
        if (this.monitorType != monitor.monitorType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)monitor.user)) {
            return false;
        }
        if (this.schemaVersion != monitor.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, monitor.inputs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.triggers, monitor.triggers)) {
            return false;
        }
        return Intrinsics.areEqual(this.uiMetadata, monitor.uiMetadata);
    }

    private static final Monitor XCONTENT_REGISTRY$lambda-13(XContentParser it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return org.opensearch.alerting.model.Monitor$Companion.parse$default(Companion, it, null, 0L, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Monitor parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
        return Companion.parse(xcp, id, version);
    }

    @JvmStatic
    @Nullable
    public static final Monitor readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Monitor parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Monitor parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/opensearch/alerting/model/Monitor$MonitorType;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "toString", "QUERY_LEVEL_MONITOR", "BUCKET_LEVEL_MONITOR", "CLUSTER_METRICS_MONITOR", "DOC_LEVEL_MONITOR", "opensearch-alerting"})
    public static final class MonitorType
    extends Enum<MonitorType> {
        @NotNull
        private final String value;
        public static final /* enum */ MonitorType QUERY_LEVEL_MONITOR = new MonitorType("query_level_monitor");
        public static final /* enum */ MonitorType BUCKET_LEVEL_MONITOR = new MonitorType("bucket_level_monitor");
        public static final /* enum */ MonitorType CLUSTER_METRICS_MONITOR = new MonitorType("cluster_metrics_monitor");
        public static final /* enum */ MonitorType DOC_LEVEL_MONITOR = new MonitorType("doc_level_monitor");
        private static final /* synthetic */ MonitorType[] $VALUES;

        private MonitorType(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.value;
        }

        public static MonitorType[] values() {
            return (MonitorType[])$VALUES.clone();
        }

        public static MonitorType valueOf(String value) {
            return Enum.valueOf(MonitorType.class, value);
        }

        static {
            $VALUES = monitorTypeArray = new MonitorType[]{MonitorType.QUERY_LEVEL_MONITOR, MonitorType.BUCKET_LEVEL_MONITOR, MonitorType.CLUSTER_METRICS_MONITOR, MonitorType.DOC_LEVEL_MONITOR};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\rH\u0007J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020 H\u0007J,\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\"2\u0018\u0010#\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lorg/opensearch/alerting/model/Monitor$Companion;", "", "()V", "ENABLED_FIELD", "", "ENABLED_TIME_FIELD", "INPUTS_FIELD", "LAST_UPDATE_TIME_FIELD", "MONITOR_TYPE", "MONITOR_TYPE_FIELD", "NAME_FIELD", "NO_ID", "NO_VERSION", "", "SCHEDULE_FIELD", "SCHEMA_VERSION_FIELD", "TRIGGERS_FIELD", "TYPE_FIELD", "UI_METADATA_FIELD", "USER_FIELD", "XCONTENT_REGISTRY", "Lorg/opensearch/common/xcontent/NamedXContentRegistry$Entry;", "getXCONTENT_REGISTRY", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry$Entry;", "parse", "Lorg/opensearch/alerting/model/Monitor;", "xcp", "Lorg/opensearch/common/xcontent/XContentParser;", "id", "version", "readFrom", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "suppressWarning", "", "map", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NamedXContentRegistry.Entry getXCONTENT_REGISTRY() {
            return XCONTENT_REGISTRY;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Monitor parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String name = null;
            Object monitorType = MonitorType.QUERY_LEVEL_MONITOR.toString();
            User user = null;
            Schedule schedule = null;
            Instant lastUpdateTime = null;
            Instant enabledTime = null;
            Object uiMetadata = MapsKt.emptyMap();
            boolean enabled = true;
            int schemaVersion = 0;
            List triggers = new ArrayList();
            List inputs = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block26: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                block48: {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    object2 = fieldName;
                    if (object2 == null) break block48;
                    int n = -1;
                    switch (((String)object2).hashCode()) {
                        case 1684719674: {
                            if (((String)object2).equals(Monitor.SCHEMA_VERSION_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case -1219796725: {
                            if (((String)object2).equals(Monitor.ENABLED_TIME_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case -697920873: {
                            if (((String)object2).equals(Monitor.SCHEDULE_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case 2020321370: {
                            if (((String)object2).equals(Monitor.LAST_UPDATE_TIME_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case -1183866391: {
                            if (((String)object2).equals(Monitor.INPUTS_FIELD)) {
                                n = 5;
                            }
                            break;
                        }
                        case 3373707: {
                            if (((String)object2).equals(Monitor.NAME_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 1503093179: {
                            if (((String)object2).equals(Monitor.TRIGGERS_FIELD)) {
                                n = 7;
                            }
                            break;
                        }
                        case 1732432639: {
                            if (((String)object2).equals(Monitor.MONITOR_TYPE_FIELD)) {
                                n = 8;
                            }
                            break;
                        }
                        case 3599307: {
                            if (((String)object2).equals(Monitor.USER_FIELD)) {
                                n = 9;
                            }
                            break;
                        }
                        case 691520634: {
                            if (((String)object2).equals(Monitor.UI_METADATA_FIELD)) {
                                n = 10;
                            }
                            break;
                        }
                        case -1609594047: {
                            if (((String)object2).equals(Monitor.ENABLED_FIELD)) {
                                n = 11;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            schemaVersion = xcp.intValue();
                            continue block26;
                        }
                        case 6: {
                            name = xcp.text();
                            continue block26;
                        }
                        case 8: {
                            void $this$mapTo$iv$iv;
                            object = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xcp.text()");
                            monitorType = object;
                            MonitorType[] $this$map$iv = MonitorType.values();
                            boolean $i$f$map = false;
                            MonitorType[] monitorTypeArray = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            for (void item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                void var28_31 = item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getValue());
                            }
                            List allowedTypes = (List)destination$iv$iv;
                            if (allowedTypes.contains(monitorType)) continue block26;
                            throw new IllegalStateException("Monitor type should be one of " + allowedTypes);
                        }
                        case 9: {
                            user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                            continue block26;
                        }
                        case 11: {
                            enabled = xcp.booleanValue();
                            continue block26;
                        }
                        case 3: {
                            schedule = Schedule.Companion.parse(xcp);
                            continue block26;
                        }
                        case 5: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                Input input = Input.Companion.parse(xcp);
                                if (input instanceof ClusterMetricsInput) {
                                    SupportedClusterMetricsSettings.Companion.validateApiType((ClusterMetricsInput)input);
                                }
                                inputs.add(input);
                            }
                            continue block26;
                        }
                        case 7: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                triggers.add(Trigger.Companion.parse(xcp));
                            }
                            continue block26;
                        }
                        case 2: {
                            enabledTime = OpenSearchExtensionsKt.instant((XContentParser)xcp);
                            continue block26;
                        }
                        case 4: {
                            lastUpdateTime = OpenSearchExtensionsKt.instant((XContentParser)xcp);
                            continue block26;
                        }
                        case 10: {
                            object = xcp.map();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xcp.map()");
                            uiMetadata = object;
                            continue block26;
                        }
                    }
                }
                xcp.skipChildren();
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            String string = id;
            long l = version;
            String string2 = name;
            if (string2 == null) {
                long l2 = l;
                String string3 = string;
                boolean $i$a$-requireNotNull-Monitor$Companion$parse$32 = false;
                String string4 = "Monitor name is null";
                String string5 = string3;
                long l3 = l2;
                String $i$a$-requireNotNull-Monitor$Companion$parse$32 = string4;
                throw new IllegalArgumentException($i$a$-requireNotNull-Monitor$Companion$parse$32.toString());
            }
            boolean bl = enabled;
            Schedule schedule2 = schedule;
            if (schedule2 == null) {
                boolean bl2 = bl;
                String string6 = string2;
                long l4 = l;
                String string7 = string;
                boolean bl3 = false;
                String string8 = "Monitor schedule is null";
                String string9 = string7;
                long l5 = l4;
                String string10 = string6;
                boolean bl4 = bl2;
                String string11 = string8;
                throw new IllegalArgumentException(string11.toString());
            }
            Instant instant = lastUpdateTime;
            if (instant == null) {
                instant = Instant.now();
            }
            Instant instant2 = instant;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"lastUpdateTime ?: Instant.now()");
            object2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ROOT");
            object = ((String)monitorType).toUpperCase((Locale)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toUpperCase(locale)");
            Object object3 = uiMetadata;
            List list = CollectionsKt.toList((Iterable)triggers);
            List list2 = CollectionsKt.toList((Iterable)inputs);
            int n = schemaVersion;
            User user2 = user;
            MonitorType monitorType2 = MonitorType.valueOf((String)object);
            Instant instant3 = enabledTime;
            Instant instant4 = instant2;
            Schedule schedule3 = schedule2;
            boolean bl5 = bl;
            String string12 = string2;
            long l6 = l;
            String string13 = string;
            return new Monitor(string13, l6, string12, bl5, schedule3, instant4, instant3, monitorType2, user2, n, list2, list, (Map<String, ? extends Object>)object3);
        }

        public static /* synthetic */ Monitor parse$default(Companion companion, XContentParser xContentParser, String string, long l, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Monitor.NO_ID;
            }
            if ((n & 4) != 0) {
                l = 1L;
            }
            return companion.parse(xContentParser, string, l);
        }

        @JvmStatic
        @Nullable
        public final Monitor readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Monitor(sin);
        }

        @NotNull
        public final Map<String, Object> suppressWarning(@Nullable Map<String, Object> map) {
            Map<String, Object> map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            }
            return TypeIntrinsics.asMutableMap(map2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Monitor parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.alerting.model.Monitor$Companion.parse$default(this, xcp, id, 0L, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Monitor parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.alerting.model.Monitor$Companion.parse$default(this, xcp, null, 0L, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MonitorType.values().length];
            nArray[MonitorType.QUERY_LEVEL_MONITOR.ordinal()] = 1;
            nArray[MonitorType.BUCKET_LEVEL_MONITOR.ordinal()] = 2;
            nArray[MonitorType.CLUSTER_METRICS_MONITOR.ordinal()] = 3;
            nArray[MonitorType.DOC_LEVEL_MONITOR.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

