/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.resthandler.RestIndexAlertingCommentActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.IndexCommentRequest;
import org.opensearch.commons.alerting.action.IndexCommentResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/alerting/resthandler/RestIndexAlertingCommentAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "indexCommentResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/commons/alerting/action/IndexCommentResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "restMethod", "Lorg/opensearch/rest/RestRequest$Method;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestIndexAlertingCommentAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "index_alerting_comment_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.COMMENTS_BASE_URI + "/{id}"), new RestHandler.Route(RestRequest.Method.PUT, AlertingPlugin.COMMENTS_BASE_URI + "/{id}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestIndexAlertingCommentActionKt.access$getLog$p().info(request.method() + " " + AlertingPlugin.COMMENTS_BASE_URI);
        String id = request.param("id", request.method() == RestRequest.Method.POST ? "" : "");
        if (request.method() == RestRequest.Method.POST && Intrinsics.areEqual((Object)"", (Object)id)) {
            throw AlertingException.Companion.wrap(new IllegalArgumentException("Missing alert ID"));
        }
        if (request.method() == RestRequest.Method.PUT && Intrinsics.areEqual((Object)"", (Object)id)) {
            throw AlertingException.Companion.wrap(new IllegalArgumentException("Missing comment ID"));
        }
        String alertId = request.method() == RestRequest.Method.POST ? id : "";
        String commentId = request.method() == RestRequest.Method.PUT ? id : "";
        String content = (String)request.contentParser().map().get("content");
        CharSequence charSequence = content;
        if (charSequence == null || charSequence.length() == 0) {
            throw AlertingException.Companion.wrap(new IllegalArgumentException("Missing comment content"));
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        Intrinsics.checkNotNullExpressionValue((Object)alertId, (String)"alertId");
        Intrinsics.checkNotNullExpressionValue((Object)commentId, (String)"commentId");
        RestRequest.Method method = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"request.method()");
        IndexCommentRequest indexCommentRequest = new IndexCommentRequest(alertId, "alert", commentId, seqNo, primaryTerm, method, content);
        return arg_0 -> RestIndexAlertingCommentAction.prepareRequest$lambda$0(client, indexCommentRequest, this, request, arg_0);
    }

    private final RestResponseListener<IndexCommentResponse> indexCommentResponse(RestChannel channel, RestRequest.Method restMethod) {
        return (RestResponseListener)new RestResponseListener<IndexCommentResponse>(channel, restMethod){
            final /* synthetic */ RestChannel $channel;
            final /* synthetic */ RestRequest.Method $restMethod;
            {
                this.$channel = $channel;
                this.$restMethod = $restMethod;
                super($channel);
            }

            @NotNull
            public RestResponse buildResponse(@NotNull IndexCommentResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                RestStatus returnStatus = RestStatus.CREATED;
                if (this.$restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"channel.newBuilder()");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response2.toXContent(xContentBuilder, params));
                if (returnStatus == RestStatus.CREATED) {
                    String location = AlertingPlugin.COMMENTS_BASE_URI + "/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, IndexCommentRequest $indexCommentRequest, RestIndexAlertingCommentAction this$0, RestRequest $request, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$indexCommentRequest, (String)"$indexCommentRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ActionRequest actionRequest = (ActionRequest)$indexCommentRequest;
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        RestRequest.Method method = $request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"request.method()");
        $client.execute(AlertingActions.INDEX_COMMENT_ACTION_TYPE, actionRequest, (ActionListener)this$0.indexCommentResponse(channel, method));
    }
}

