/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/alerting/util/IndexUtils;", "", "()V", "Companion", "opensearch-alerting"})
public final class IndexUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex VALID_INDEX_NAME_REGEX = new Regex("^(?![_\\-\\+])(?!.*\\.\\.)[^\\s,\\\\\\/\\*\\?\"<>|#:\\.]{1,255}$");
    @NotNull
    public static final String _META = "_meta";
    @NotNull
    public static final String SCHEMA_VERSION = "schema_version";
    private static int scheduledJobIndexSchemaVersion = Companion.getSchemaVersion(ScheduledJobIndices.Companion.scheduledJobMappings());
    private static int alertIndexSchemaVersion = Companion.getSchemaVersion(AlertIndices.Companion.alertMapping());
    private static int findingIndexSchemaVersion = Companion.getSchemaVersion(AlertIndices.Companion.findingMapping());
    private static boolean scheduledJobIndexUpdated;
    private static boolean alertIndexUpdated;
    private static boolean findingIndexUpdated;
    @Nullable
    private static String lastUpdatedAlertHistoryIndex;
    @Nullable
    private static String lastUpdatedFindingHistoryIndex;

    @JvmStatic
    public static final void scheduledJobIndexUpdated() {
        Companion.scheduledJobIndexUpdated();
    }

    @JvmStatic
    public static final void alertIndexUpdated() {
        Companion.alertIndexUpdated();
    }

    @JvmStatic
    public static final void findingIndexUpdated() {
        Companion.findingIndexUpdated();
    }

    @JvmStatic
    public static final int getSchemaVersion(@NotNull String mapping) {
        return Companion.getSchemaVersion(mapping);
    }

    @JvmStatic
    @NotNull
    public static final String getIndexNameWithAlias(@NotNull ClusterState clusterState, @NotNull String alias) {
        return Companion.getIndexNameWithAlias(clusterState, alias);
    }

    @JvmStatic
    public static final boolean shouldUpdateIndex(@NotNull IndexMetadata index, @NotNull String mapping) {
        return Companion.shouldUpdateIndex(index, mapping);
    }

    @JvmStatic
    public static final void updateIndexMapping(@NotNull String index, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Companion.updateIndexMapping(index, mapping, clusterState, client, actionListener);
    }

    @JvmStatic
    @NotNull
    public static final List<String> resolveAllIndices(@NotNull List<String> indices, @NotNull ClusterService clusterService, @NotNull IndexNameExpressionResolver resolver) {
        return Companion.resolveAllIndices(indices, clusterService, resolver);
    }

    @JvmStatic
    public static final boolean isDataStream(@NotNull String name, @NotNull ClusterState clusterState) {
        return Companion.isDataStream(name, clusterState);
    }

    @JvmStatic
    public static final boolean isAlias(@NotNull String name, @NotNull ClusterState clusterState) {
        return Companion.isAlias(name, clusterState);
    }

    @JvmStatic
    @Nullable
    public static final String getWriteIndex(@NotNull String index, @NotNull ClusterState clusterState) {
        return Companion.getWriteIndex(index, clusterState);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getNewestIndicesByCreationDate(@NotNull List<String> concreteIndices, @NotNull ClusterState clusterState, long thresholdDate) {
        return Companion.getNewestIndicesByCreationDate(concreteIndices, clusterState, thresholdDate);
    }

    @JvmStatic
    public static final long getCreationDateForIndex(@NotNull String index, @NotNull ClusterState clusterState) {
        return Companion.getCreationDateForIndex(index, clusterState);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020#H\u0007J\b\u0010\u0015\u001a\u00020#H\u0007J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0004H\u0007J,\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010'\u001a\u00020(2\u0006\u0010.\u001a\u00020%H\u0007J\u0010\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0004H\u0007J\u001a\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u00104\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0007J,\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040,2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0007J\b\u0010!\u001a\u00020#H\u0007J\u0018\u0010;\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020<2\u0006\u00100\u001a\u00020\u0004H\u0007J6\u0010=\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000eR\u001e\u0010!\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012\u00a8\u0006C"}, d2={"Lorg/opensearch/alerting/util/IndexUtils$Companion;", "", "()V", "SCHEMA_VERSION", "", "VALID_INDEX_NAME_REGEX", "Lkotlin/text/Regex;", "getVALID_INDEX_NAME_REGEX", "()Lkotlin/text/Regex;", "_META", "<set-?>", "", "alertIndexSchemaVersion", "getAlertIndexSchemaVersion", "()I", "", "alertIndexUpdated", "getAlertIndexUpdated", "()Z", "findingIndexSchemaVersion", "getFindingIndexSchemaVersion", "findingIndexUpdated", "getFindingIndexUpdated", "lastUpdatedAlertHistoryIndex", "getLastUpdatedAlertHistoryIndex", "()Ljava/lang/String;", "setLastUpdatedAlertHistoryIndex", "(Ljava/lang/String;)V", "lastUpdatedFindingHistoryIndex", "getLastUpdatedFindingHistoryIndex", "setLastUpdatedFindingHistoryIndex", "scheduledJobIndexSchemaVersion", "getScheduledJobIndexSchemaVersion", "scheduledJobIndexUpdated", "getScheduledJobIndexUpdated", "", "getCreationDateForIndex", "", "index", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "getIndexNameWithAlias", "alias", "getNewestIndicesByCreationDate", "", "concreteIndices", "thresholdDate", "getSchemaVersion", "mapping", "getWriteIndex", "isAlias", "name", "isDataStream", "resolveAllIndices", "indices", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "resolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "shouldUpdateIndex", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "updateIndexMapping", "client", "Lorg/opensearch/client/IndicesAdminClient;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexUtils.kt\norg/opensearch/alerting/util/IndexUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n223#2,2:202\n1855#2,2:204\n1855#2,2:206\n*S KotlinDebug\n*F\n+ 1 IndexUtils.kt\norg/opensearch/alerting/util/IndexUtils$Companion\n*L\n105#1:202,2\n145#1:204,2\n183#1:206,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getVALID_INDEX_NAME_REGEX() {
            return VALID_INDEX_NAME_REGEX;
        }

        public final int getScheduledJobIndexSchemaVersion() {
            return scheduledJobIndexSchemaVersion;
        }

        public final int getAlertIndexSchemaVersion() {
            return alertIndexSchemaVersion;
        }

        public final int getFindingIndexSchemaVersion() {
            return findingIndexSchemaVersion;
        }

        public final boolean getScheduledJobIndexUpdated() {
            return scheduledJobIndexUpdated;
        }

        public final boolean getAlertIndexUpdated() {
            return alertIndexUpdated;
        }

        public final boolean getFindingIndexUpdated() {
            return findingIndexUpdated;
        }

        @Nullable
        public final String getLastUpdatedAlertHistoryIndex() {
            return lastUpdatedAlertHistoryIndex;
        }

        public final void setLastUpdatedAlertHistoryIndex(@Nullable String string) {
            lastUpdatedAlertHistoryIndex = string;
        }

        @Nullable
        public final String getLastUpdatedFindingHistoryIndex() {
            return lastUpdatedFindingHistoryIndex;
        }

        public final void setLastUpdatedFindingHistoryIndex(@Nullable String string) {
            lastUpdatedFindingHistoryIndex = string;
        }

        @JvmStatic
        public final void scheduledJobIndexUpdated() {
            scheduledJobIndexUpdated = true;
        }

        @JvmStatic
        public final void alertIndexUpdated() {
            alertIndexUpdated = true;
        }

        @JvmStatic
        public final void findingIndexUpdated() {
            findingIndexUpdated = true;
        }

        @JvmStatic
        public final int getSchemaVersion(@NotNull String mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
            while (!xcp.isClosed()) {
                XContentParser.Token token = xcp.currentToken();
                if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                    if (!Intrinsics.areEqual((Object)xcp.currentName(), (Object)IndexUtils._META)) {
                        xcp.nextToken();
                        xcp.skipChildren();
                    } else {
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (Intrinsics.areEqual((Object)xcp.currentName(), (Object)IndexUtils.SCHEMA_VERSION)) {
                                int version = xcp.intValue();
                                if (!(version > -1)) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                return version;
                            }
                            xcp.nextToken();
                        }
                    }
                }
                xcp.nextToken();
            }
            return 0;
        }

        @JvmStatic
        @NotNull
        public final String getIndexNameWithAlias(@NotNull ClusterState clusterState, @NotNull String alias) {
            Object element$iv2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                Iterable $this$first$iv = clusterState.getMetadata().getIndices().entrySet();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Map.Entry it = (Map.Entry)element$iv2;
                    boolean bl = false;
                    if (!((IndexMetadata)it.getValue()).getAliases().containsKey(alias)) continue;
                    break block1;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object k = ((Map.Entry)element$iv2).getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"clusterState.metadata.in\u2026.containsKey(alias) }.key");
            return (String)k;
        }

        @JvmStatic
        public final boolean shouldUpdateIndex(@NotNull IndexMetadata index, @NotNull String mapping) {
            Map indexMapping;
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            int oldVersion = 0;
            int newVersion = this.getSchemaVersion(mapping);
            MappingMetadata mappingMetadata = index.mapping();
            Map map = indexMapping = mappingMetadata != null ? mappingMetadata.sourceAsMap() : null;
            if (indexMapping != null && indexMapping.containsKey(IndexUtils._META) && indexMapping.get(IndexUtils._META) instanceof HashMap) {
                Object v = indexMapping.get(IndexUtils._META);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
                HashMap metaData = (HashMap)v;
                if (((Map)metaData).containsKey(IndexUtils.SCHEMA_VERSION)) {
                    Object v2 = ((Map)metaData).get(IndexUtils.SCHEMA_VERSION);
                    Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Int");
                    oldVersion = (Integer)v2;
                }
            }
            return newVersion > oldVersion;
        }

        @JvmStatic
        public final void updateIndexMapping(@NotNull String index, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            if (clusterState.getMetadata().getIndices().containsKey(index)) {
                Object v = clusterState.getMetadata().getIndices().get(index);
                Intrinsics.checkNotNull(v);
                if (this.shouldUpdateIndex((IndexMetadata)v, mapping)) {
                    String[] stringArray = new String[]{index};
                    PutMappingRequest putMappingRequest = new PutMappingRequest(stringArray).source(mapping, (MediaType)XContentType.JSON);
                    Intrinsics.checkNotNullExpressionValue((Object)putMappingRequest, (String)"PutMappingRequest(index)\u2026pping, XContentType.JSON)");
                    PutMappingRequest putMappingRequest2 = putMappingRequest;
                    client.putMapping(putMappingRequest2, actionListener);
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }
        }

        @JvmStatic
        @NotNull
        public final List<String> resolveAllIndices(@NotNull List<String> indices, @NotNull ClusterService clusterService, @NotNull IndexNameExpressionResolver resolver) {
            Intrinsics.checkNotNullParameter(indices, (String)"indices");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            List result = new ArrayList();
            Iterable $this$forEach$iv = indices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String index = (String)element$iv;
                boolean bl = false;
                String[] stringArray = new String[]{index};
                Object[] concreteIndices = resolver.concreteIndexNames(clusterService.state(), IndicesOptions.lenientExpand(), true, stringArray);
                Collection collection = result;
                Intrinsics.checkNotNullExpressionValue((Object)concreteIndices, (String)"concreteIndices");
                CollectionsKt.addAll((Collection)collection, (Object[])concreteIndices);
            }
            return result;
        }

        @JvmStatic
        public final boolean isDataStream(@NotNull String name, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            return clusterState.metadata().dataStreams().containsKey(name);
        }

        @JvmStatic
        public final boolean isAlias(@NotNull String name, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            return clusterState.metadata().hasAlias(name);
        }

        @JvmStatic
        @Nullable
        public final String getWriteIndex(@NotNull String index, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            if (this.isAlias(index, clusterState) || this.isDataStream(index, clusterState)) {
                IndexMetadata metadata;
                IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(index);
                Object object = metadata = indexAbstraction != null ? indexAbstraction.getWriteIndex() : null;
                if (metadata != null) {
                    return metadata.getIndex().getName();
                }
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final List<String> getNewestIndicesByCreationDate(@NotNull List<String> concreteIndices, @NotNull ClusterState clusterState, long thresholdDate) {
            Intrinsics.checkNotNullParameter(concreteIndices, (String)"concreteIndices");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            List filteredIndices = new ArrayList();
            SortedMap lookup = clusterState.metadata().getIndicesLookup();
            Iterable $this$forEach$iv = concreteIndices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String indexName = (String)element$iv;
                boolean bl = false;
                IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
                IndexMetadata indexMetadata = clusterState.getMetadata().index(indexName);
                if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX || indexMetadata.getCreationDate() < thresholdDate) continue;
                filteredIndices.add(indexName);
            }
            return filteredIndices;
        }

        @JvmStatic
        public final long getCreationDateForIndex(@NotNull String index, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            return clusterState.getMetadata().index(index).getCreationDate();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

