/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.OpType;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.bulk.CreateOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.remote.metadata.client.AbstractSdkClient;
import org.opensearch.remote.metadata.client.BulkDataObjectRequest;
import org.opensearch.remote.metadata.client.BulkDataObjectResponse;
import org.opensearch.remote.metadata.client.DataObjectRequest;
import org.opensearch.remote.metadata.client.DataObjectResponse;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;
import org.opensearch.remote.metadata.client.impl.JsonTransformer;
import org.opensearch.remote.metadata.common.SdkClientUtils;

public class RemoteClusterIndicesClient
extends AbstractSdkClient {
    private static final Logger log = LogManager.getLogger(RemoteClusterIndicesClient.class);
    protected static final Class<Map<String, Object>> MAP_DOCTYPE = Map.class;
    protected OpenSearchAsyncClient openSearchAsyncClient;
    protected JsonpMapper mapper;

    public boolean supportsMetadataType(String metadataType) {
        return "RemoteOpenSearch".equals(metadataType);
    }

    public void initialize(Map<String, String> metadataSettings) {
        super.initialize(metadataSettings);
        this.openSearchAsyncClient = this.createOpenSearchAsyncClient();
        this.mapper = ((OpenSearchTransport)this.openSearchAsyncClient._transport()).jsonpMapper();
    }

    public RemoteClusterIndicesClient() {
    }

    RemoteClusterIndicesClient(OpenSearchAsyncClient openSearchAsyncClient, String tenantIdField) {
        super.initialize(Collections.singletonMap("tenant_id", tenantIdField));
        this.openSearchAsyncClient = openSearchAsyncClient;
        this.mapper = ((OpenSearchTransport)openSearchAsyncClient._transport()).jsonpMapper();
    }

    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)ThreadContextAccess.doPrivileged(() -> {
            try {
                IndexRequest.Builder builder = new IndexRequest.Builder().index(request.index()).opType(request.overwriteIfExists() ? OpType.Index : OpType.Create).document((Object)request.dataObject()).tDocumentSerializer((JsonpSerializer)new JsonTransformer.XContentObjectJsonpSerializer());
                if (!Strings.isNullOrEmpty((String)request.id())) {
                    builder.id(request.id());
                }
                IndexRequest indexRequest = builder.build();
                log.info("Indexing data object in {}", (Object)request.index());
                return ((CompletableFuture)this.openSearchAsyncClient.index(indexRequest).thenApply(indexResponse -> {
                    log.info("Creation status for id {}: {}", (Object)indexResponse.id(), (Object)indexResponse.result());
                    try {
                        return ((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)PutDataObjectResponse.builder().id(indexResponse.id())).parser(this.createParser((JsonpSerializable)indexResponse))).build();
                    }
                    catch (IOException e) {
                        throw new OpenSearchStatusException("Failed to create response for index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                    }
                })).exceptionally(e -> {
                    throw new OpenSearchStatusException("Failed to put data object in index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
                });
            }
            catch (IOException e2) {
                log.error("Error putting data object in {}: {}", (Object)request.index(), (Object)e2.getMessage(), (Object)e2);
                throw new OpenSearchStatusException("Failed to parse data object to put in index " + request.index(), RestStatus.BAD_REQUEST, new Object[0]);
            }
        });
    }

    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)ThreadContextAccess.doPrivileged(() -> {
            try {
                GetRequest getRequest = new GetRequest.Builder().index(request.index()).id(request.id()).build();
                log.info("Getting {} from {}", (Object)request.id(), (Object)request.index());
                return ((CompletableFuture)this.openSearchAsyncClient.get(getRequest, MAP_DOCTYPE).thenApply(getResponse -> {
                    log.info("Get found status for id {}: {}", (Object)getResponse.id(), (Object)getResponse.found());
                    Map source = (Map)getResponse.source();
                    try {
                        return ((GetDataObjectResponse.Builder)((GetDataObjectResponse.Builder)GetDataObjectResponse.builder().id(getResponse.id())).parser(this.createParser((JsonpSerializable)getResponse))).source(source).build();
                    }
                    catch (IOException e) {
                        throw new OpenSearchStatusException("Failed to create parser for data object retrieved from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                    }
                })).exceptionally(e -> {
                    log.error("Error getting data object {} from {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage(), e);
                    throw new OpenSearchStatusException("Failed to get data object from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
                });
            }
            catch (IOException e2) {
                log.error("Error getting data object {} from {}: {}", (Object)request.id(), (Object)request.index(), (Object)e2.getMessage(), (Object)e2);
                throw new OpenSearchStatusException("Failed to get data object from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e2, new Object[0]);
            }
        });
    }

    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)ThreadContextAccess.doPrivileged(() -> {
            CompletionStage completionStage;
            block11: {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                try {
                    request.dataObject().toXContent(builder, ToXContent.EMPTY_PARAMS);
                    Map docMap = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, builder.toString()).map();
                    UpdateRequest.Builder updateRequestBuilder = new UpdateRequest.Builder().index(request.index()).id(request.id()).doc((Object)docMap);
                    if (request.ifSeqNo() != null) {
                        updateRequestBuilder.ifSeqNo(request.ifSeqNo());
                    }
                    if (request.ifPrimaryTerm() != null) {
                        updateRequestBuilder.ifPrimaryTerm(request.ifPrimaryTerm());
                    }
                    if (request.retryOnConflict() > 0) {
                        updateRequestBuilder.retryOnConflict(Integer.valueOf(request.retryOnConflict()));
                    }
                    UpdateRequest updateRequest = updateRequestBuilder.build();
                    log.info("Updating {} in {}", (Object)request.id(), (Object)request.index());
                    completionStage = ((CompletableFuture)this.openSearchAsyncClient.update(updateRequest, MAP_DOCTYPE).thenApply(updateResponse -> {
                        log.info("Update status for id {}: {}", (Object)updateResponse.id(), (Object)updateResponse.result());
                        try {
                            return ((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)UpdateDataObjectResponse.builder().id(updateResponse.id())).parser(this.createParser((JsonpSerializable)updateResponse))).build();
                        }
                        catch (IOException e) {
                            throw new OpenSearchStatusException("Failed to create parser for update response for " + request.id() + " in index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                        }
                    })).exceptionally(e -> {
                        Throwable cause = e.getCause();
                        if (cause instanceof org.opensearch.client.opensearch._types.OpenSearchException) {
                            org.opensearch.client.opensearch._types.OpenSearchException ose = (org.opensearch.client.opensearch._types.OpenSearchException)cause;
                            String errorType = ose.status() == RestStatus.CONFLICT.getStatus() ? "Document Version Conflict" : "Failed";
                            log.error("{} updating {} in {}: {}", (Object)errorType, (Object)request.id(), (Object)request.index(), (Object)ose.getMessage(), (Object)ose);
                            throw new OpenSearchStatusException(errorType + " updating " + request.id() + " in index " + request.index(), RestStatus.fromCode((int)ose.status()), (Throwable)ose, new Object[0]);
                        }
                        log.error("Error updating {} in {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage(), e);
                        throw new OpenSearchStatusException("Error updating data object " + request.id() + " in index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
                    });
                    if (builder == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        log.error("Error preparing update for {} in {}: {}", (Object)request.id(), (Object)request.index(), (Object)e2.getMessage(), (Object)e2);
                        throw new OpenSearchStatusException("Parsing error preparing update for data object " + request.id() + " in index " + request.index(), RestStatus.BAD_REQUEST, (Throwable)e2, new Object[0]);
                    }
                }
                builder.close();
            }
            return completionStage;
        });
    }

    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)ThreadContextAccess.doPrivileged(() -> {
            try {
                DeleteRequest deleteRequest = new DeleteRequest.Builder().index(request.index()).id(request.id()).build();
                log.info("Deleting {} from {}", (Object)request.id(), (Object)request.index());
                return ((CompletableFuture)this.openSearchAsyncClient.delete(deleteRequest).thenApply(deleteResponse -> {
                    log.info("Deletion status for id {}: {}", (Object)deleteResponse.id(), (Object)deleteResponse.result());
                    try {
                        return ((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)DeleteDataObjectResponse.builder().id(deleteResponse.id())).parser(this.createParser((JsonpSerializable)deleteResponse))).build();
                    }
                    catch (IOException e) {
                        throw new OpenSearchStatusException("Failed to create parser for delete response for " + request.id() + " from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                    }
                })).exceptionally(e -> {
                    log.error("Error deleting {} from {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage(), e);
                    throw new OpenSearchStatusException("Failed to delete data object " + request.id() + " from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
                });
            }
            catch (IOException e2) {
                log.error("Error initiating delete for {} from {}: {}", (Object)request.id(), (Object)request.index(), (Object)e2.getMessage(), (Object)e2);
                throw new OpenSearchStatusException("Failed to delete data object " + request.id() + " from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e2, new Object[0]);
            }
        });
    }

    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)ThreadContextAccess.doPrivileged(() -> {
            try {
                log.info("Performing {} bulk actions on indices {}", (Object)request.requests().size(), (Object)request.getIndices());
                ArrayList<BulkOperation> operations = new ArrayList<BulkOperation>();
                for (DataObjectRequest dataObjectRequest : request.requests()) {
                    this.addBulkOperation(dataObjectRequest, operations);
                }
                BulkRequest bulkRequest = new BulkRequest.Builder().operations(operations).refresh(Refresh.True).build();
                return ((CompletableFuture)this.openSearchAsyncClient.bulk(bulkRequest).thenApply(bulkResponse -> {
                    log.info("Bulk action complete for {} items: {}", (Object)bulkResponse.items().size(), (Object)(bulkResponse.errors() ? "has failures" : "success"));
                    try {
                        DataObjectResponse[] responses = this.bulkResponseItemsToArray(bulkResponse.items());
                        return bulkResponse.ingestTook() == null ? new BulkDataObjectResponse(responses, bulkResponse.took(), bulkResponse.errors(), this.createParser((JsonpSerializable)bulkResponse)) : new BulkDataObjectResponse(responses, bulkResponse.took(), bulkResponse.ingestTook().longValue(), bulkResponse.errors(), this.createParser((JsonpSerializable)bulkResponse));
                    }
                    catch (IOException e) {
                        throw new OpenSearchStatusException("Failed to parse data object in a bulk response", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                    }
                })).exceptionally(e -> {
                    throw new OpenSearchStatusException("Failed to execute bulk request", RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
                });
            }
            catch (Exception e2) {
                throw new OpenSearchStatusException("Failed to execute bulk request", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e2, new Object[0]);
            }
        });
    }

    private void addBulkOperation(DataObjectRequest dataObjectRequest, List<BulkOperation> operations) {
        if (dataObjectRequest instanceof PutDataObjectRequest) {
            this.addBulkPutOperation((PutDataObjectRequest)dataObjectRequest, operations);
        } else if (dataObjectRequest instanceof UpdateDataObjectRequest) {
            this.addBulkUpdateOperation((UpdateDataObjectRequest)dataObjectRequest, operations);
        } else if (dataObjectRequest instanceof DeleteDataObjectRequest) {
            this.addBulkDeleteOperation((DeleteDataObjectRequest)dataObjectRequest, operations);
        } else {
            throw new IllegalArgumentException("Invalid type for bulk request");
        }
    }

    private void addBulkPutOperation(PutDataObjectRequest putRequest, List<BulkOperation> operations) {
        if (putRequest.overwriteIfExists()) {
            operations.add(BulkOperation.of(op -> op.index(i -> {
                ((IndexOperation.Builder)i.index(putRequest.index())).document((Object)putRequest.dataObject()).tDocumentSerializer((JsonpSerializer)new JsonTransformer.XContentObjectJsonpSerializer());
                if (!Strings.isNullOrEmpty((String)putRequest.id())) {
                    i.id(putRequest.id());
                }
                return i;
            })));
        } else {
            operations.add(BulkOperation.of(op -> op.create(c -> {
                ((CreateOperation.Builder)c.index(putRequest.index())).document((Object)putRequest.dataObject()).tDocumentSerializer((JsonpSerializer)new JsonTransformer.XContentObjectJsonpSerializer());
                if (!Strings.isNullOrEmpty((String)putRequest.id())) {
                    c.id(putRequest.id());
                }
                return c;
            })));
        }
    }

    private void addBulkUpdateOperation(UpdateDataObjectRequest updateRequest, List<BulkOperation> operations) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            updateRequest.dataObject().toXContent(builder, ToXContent.EMPTY_PARAMS);
            Map docMap = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, builder.toString()).map();
            operations.add(BulkOperation.of(op -> op.update(u -> {
                ((UpdateOperation.Builder)((UpdateOperation.Builder)u.index(updateRequest.index())).id(updateRequest.id())).document((Object)docMap);
                if (updateRequest.ifSeqNo() != null) {
                    u.ifSeqNo(updateRequest.ifSeqNo());
                }
                if (updateRequest.ifPrimaryTerm() != null) {
                    u.ifPrimaryTerm(updateRequest.ifPrimaryTerm());
                }
                if (updateRequest.retryOnConflict() > 0) {
                    u.retryOnConflict(Integer.valueOf(updateRequest.retryOnConflict()));
                }
                return u;
            })));
        }
        catch (IOException e) {
            throw new OpenSearchStatusException("Failed to parse data object in a bulk update request", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
    }

    private void addBulkDeleteOperation(DeleteDataObjectRequest deleteRequest, List<BulkOperation> operations) {
        operations.add(BulkOperation.of(op -> op.delete(d -> (ObjectBuilder)((DeleteOperation.Builder)d.index(deleteRequest.index())).id(deleteRequest.id()))));
    }

    private DataObjectResponse[] bulkResponseItemsToArray(List<BulkResponseItem> items) throws IOException {
        DataObjectResponse[] responses = new DataObjectResponse[items.size()];
        int i = 0;
        block5: for (BulkResponseItem itemResponse : items) {
            switch (itemResponse.operationType()) {
                case Index: 
                case Create: {
                    responses[i++] = ((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)PutDataObjectResponse.builder().id(itemResponse.id())).parser(this.createParser((JsonpSerializable)itemResponse))).failed(itemResponse.error() != null)).build();
                    continue block5;
                }
                case Update: {
                    responses[i++] = ((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)UpdateDataObjectResponse.builder().id(itemResponse.id())).parser(this.createParser((JsonpSerializable)itemResponse))).failed(itemResponse.error() != null)).build();
                    continue block5;
                }
                case Delete: {
                    responses[i++] = ((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)DeleteDataObjectResponse.builder().id(itemResponse.id())).parser(this.createParser((JsonpSerializable)itemResponse))).failed(itemResponse.error() != null)).build();
                    continue block5;
                }
            }
            throw new OpenSearchStatusException("Invalid operation type for bulk response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return responses;
    }

    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)ThreadContextAccess.doPrivileged(() -> {
            try {
                log.info("Searching {}", (Object)Arrays.toString(request.indices()));
                String json = SdkClientUtils.lowerCaseEnumValues((String)MatchPhraseQueryBuilder.ZERO_TERMS_QUERY_FIELD.getPreferredName(), (String)request.searchSourceBuilder().toString());
                JsonParser parser = this.mapper.jsonProvider().createParser((Reader)new StringReader(json));
                SearchRequest searchRequest = (SearchRequest)SearchRequest._DESERIALIZER.deserialize(parser, this.mapper);
                if (Boolean.TRUE.equals(isMultiTenancyEnabled)) {
                    if (request.tenantId() == null) {
                        throw new OpenSearchStatusException("Tenant ID is required when multitenancy is enabled.", RestStatus.BAD_REQUEST, new Object[0]);
                    }
                    TermQuery tenantIdFilterQuery = new TermQuery.Builder().field(this.tenantIdField).value(FieldValue.of((String)request.tenantId())).build();
                    Query existingQuery = searchRequest.query();
                    BoolQuery boolQuery = new BoolQuery.Builder().must(existingQuery == null ? new MatchAllQuery.Builder().build().toQuery() : existingQuery, new Query[0]).filter(tenantIdFilterQuery.toQuery(), new Query[0]).build();
                    searchRequest = searchRequest.toBuilder().index(Arrays.asList(request.indices())).query(boolQuery.toQuery()).build();
                } else {
                    searchRequest = searchRequest.toBuilder().index(Arrays.asList(request.indices())).build();
                }
                return ((CompletableFuture)this.openSearchAsyncClient.search(searchRequest, MAP_DOCTYPE).thenApply(searchResponse -> {
                    log.info("Search returned {} hits", (Object)searchResponse.hits().total().value());
                    try {
                        return SearchDataObjectResponse.builder().parser(this.createParser((JsonpSerializable)searchResponse)).build();
                    }
                    catch (IOException e) {
                        throw new OpenSearchStatusException("Failed to create parser for search response", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                    }
                })).exceptionally(e -> {
                    log.error("Error searching {}: {}", (Object)Arrays.toString(request.indices()), (Object)e.getMessage(), e);
                    if (e instanceof org.opensearch.client.opensearch._types.OpenSearchException) {
                        throw (org.opensearch.client.opensearch._types.OpenSearchException)e;
                    }
                    throw new OpenSearchStatusException("Failed to search indices " + Arrays.toString(request.indices()), RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
                });
            }
            catch (IOException e2) {
                log.error("Error preparing search for {}: {}", (Object)Arrays.toString(request.indices()), (Object)e2.getMessage(), (Object)e2);
                throw new OpenSearchStatusException("Failed to prepare search for indices " + Arrays.toString(request.indices()), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e2, new Object[0]);
            }
        });
    }

    private XContentParser createParser(JsonpSerializable obj) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (JsonGenerator generator = this.mapper.jsonProvider().createGenerator((Writer)stringWriter);){
            this.mapper.serialize((Object)obj, generator);
        }
        return JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, stringWriter.toString());
    }

    protected OpenSearchAsyncClient createOpenSearchAsyncClient() {
        try {
            Map<String, String> env = System.getenv();
            String user = env.getOrDefault("user", "admin");
            String pass = env.getOrDefault("password", "admin");
            HttpHost host = HttpHost.create((String)this.remoteMetadataEndpoint);
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (chain, authType) -> true).build();
            ApacheHttpClient5Transport transport = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{host}).setMapper((JsonpMapper)new JacksonJsonpMapper(new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false))).setHttpClientConfigCallback(httpClientBuilder -> {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(host), (Credentials)new UsernamePasswordCredentials(user, pass.toCharArray()));
                if (URIScheme.HTTP.getId().equalsIgnoreCase(host.getSchemeName())) {
                    return httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
                PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
                return httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setConnectionManager((AsyncClientConnectionManager)connectionManager);
            }).build();
            return new OpenSearchAsyncClient((OpenSearchTransport)transport);
        }
        catch (Exception e) {
            throw new OpenSearchException((Throwable)e);
        }
    }

    public void close() throws Exception {
        if (this.openSearchAsyncClient != null && this.openSearchAsyncClient._transport() != null) {
            ((OpenSearchTransport)this.openSearchAsyncClient._transport()).close();
        }
    }
}

