/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class ConnectorClientConfig
implements ToXContentObject,
Writeable {
    public static final String MAX_CONNECTION_FIELD = "max_connection";
    public static final String CONNECTION_TIMEOUT_FIELD = "connection_timeout";
    public static final String READ_TIMEOUT_FIELD = "read_timeout";
    public static final Integer MAX_CONNECTION_DEFAULT_VALUE = 30;
    public static final Integer CONNECTION_TIMEOUT_DEFAULT_VALUE = 30000;
    public static final Integer READ_TIMEOUT_DEFAULT_VALUE = 30000;
    private Integer maxConnections;
    private Integer connectionTimeout;
    private Integer readTimeout;

    public ConnectorClientConfig(Integer maxConnections, Integer connectionTimeout, Integer readTimeout) {
        this.maxConnections = maxConnections;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public ConnectorClientConfig(StreamInput input) throws IOException {
        this.maxConnections = input.readOptionalInt();
        this.connectionTimeout = input.readOptionalInt();
        this.readTimeout = input.readOptionalInt();
    }

    public ConnectorClientConfig() {
        this.maxConnections = MAX_CONNECTION_DEFAULT_VALUE;
        this.connectionTimeout = CONNECTION_TIMEOUT_DEFAULT_VALUE;
        this.readTimeout = READ_TIMEOUT_DEFAULT_VALUE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.maxConnections);
        out.writeOptionalInt(this.connectionTimeout);
        out.writeOptionalInt(this.readTimeout);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.maxConnections != null) {
            builder.field(MAX_CONNECTION_FIELD, this.maxConnections);
        }
        if (this.connectionTimeout != null) {
            builder.field(CONNECTION_TIMEOUT_FIELD, this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            builder.field(READ_TIMEOUT_FIELD, this.readTimeout);
        }
        return builder.endObject();
    }

    public static ConnectorClientConfig fromStream(StreamInput in) throws IOException {
        ConnectorClientConfig connectorClientConfig = new ConnectorClientConfig(in);
        return connectorClientConfig;
    }

    public static ConnectorClientConfig parse(XContentParser parser) throws IOException {
        Integer maxConnections = null;
        Integer connectionTimeout = null;
        Integer readTimeout = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "max_connection": {
                    maxConnections = parser.intValue();
                    continue block10;
                }
                case "connection_timeout": {
                    connectionTimeout = parser.intValue();
                    continue block10;
                }
                case "read_timeout": {
                    readTimeout = parser.intValue();
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return ConnectorClientConfig.builder().maxConnections(maxConnections).connectionTimeout(connectionTimeout).readTimeout(readTimeout).build();
    }

    @Generated
    public static ConnectorClientConfigBuilder builder() {
        return new ConnectorClientConfigBuilder();
    }

    @Generated
    public ConnectorClientConfigBuilder toBuilder() {
        return new ConnectorClientConfigBuilder().maxConnections(this.maxConnections).connectionTimeout(this.connectionTimeout).readTimeout(this.readTimeout);
    }

    @Generated
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Generated
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorClientConfig)) {
            return false;
        }
        ConnectorClientConfig other = (ConnectorClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxConnections = this.getMaxConnections();
        Integer other$maxConnections = other.getMaxConnections();
        if (this$maxConnections == null ? other$maxConnections != null : !((Object)this$maxConnections).equals(other$maxConnections)) {
            return false;
        }
        Integer this$connectionTimeout = this.getConnectionTimeout();
        Integer other$connectionTimeout = other.getConnectionTimeout();
        if (this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        return !(this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectorClientConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxConnections = this.getMaxConnections();
        result = result * 59 + ($maxConnections == null ? 43 : ((Object)$maxConnections).hashCode());
        Integer $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        return result;
    }

    @Generated
    public static class ConnectorClientConfigBuilder {
        @Generated
        private Integer maxConnections;
        @Generated
        private Integer connectionTimeout;
        @Generated
        private Integer readTimeout;

        @Generated
        ConnectorClientConfigBuilder() {
        }

        @Generated
        public ConnectorClientConfigBuilder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Generated
        public ConnectorClientConfig build() {
            return new ConnectorClientConfig(this.maxConnections, this.connectionTimeout, this.readTimeout);
        }

        @Generated
        public String toString() {
            return "ConnectorClientConfig.ConnectorClientConfigBuilder(maxConnections=" + this.maxConnections + ", connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ")";
        }
    }
}

