/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.opensearch.ml.common.dataframe;

import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;
import lombok.ToString;
import lombok.experimental.FieldDefaults;
import org.opensearch.core.common.io.stream.StreamOutput;

import java.io.IOException;

@FieldDefaults(makeFinal = true, level = AccessLevel.PRIVATE)
@RequiredArgsConstructor
@ToString
public class ShortValue implements ColumnValue {
    short value;

    @Override
    public ColumnType columnType() {
        return ColumnType.SHORT;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public short shortValue() {
        return value;
    }

    @Override
    public double doubleValue() {
        return Short.valueOf(value).doubleValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(columnType());
        out.writeShort(value);
    }
}
