/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.upload_chunk;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.MLModelFormat;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;

public class MLRegisterModelMetaInput
implements ToXContentObject,
Writeable {
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String MODEL_NAME_FIELD = "name";
    public static final String MODEL_VERSION_FIELD = "version";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_STATE_FIELD = "model_state";
    public static final String MODEL_CONTENT_SIZE_IN_BYTES_FIELD = "model_content_size_in_bytes";
    public static final String MODEL_CONTENT_HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String TOTAL_CHUNKS_FIELD = "total_chunks";
    private FunctionName functionName;
    private String name;
    private String version;
    private String description;
    private MLModelFormat modelFormat;
    private MLModelState modelState;
    private Long modelContentSizeInBytes;
    private String modelContentHashValue;
    private MLModelConfig modelConfig;
    private Integer totalChunks;

    public MLRegisterModelMetaInput(String name, FunctionName functionName, String version, String description, MLModelFormat modelFormat, MLModelState modelState, Long modelContentSizeInBytes, String modelContentHashValue, MLModelConfig modelConfig, Integer totalChunks) {
        if (name == null) {
            throw new IllegalArgumentException("model name is null");
        }
        this.functionName = functionName == null ? FunctionName.TEXT_EMBEDDING : functionName;
        if (version == null) {
            throw new IllegalArgumentException("model version is null");
        }
        if (modelFormat == null) {
            throw new IllegalArgumentException("model format is null");
        }
        if (modelContentHashValue == null) {
            throw new IllegalArgumentException("model content hash value is null");
        }
        if (modelConfig == null) {
            throw new IllegalArgumentException("model config is null");
        }
        if (totalChunks == null) {
            throw new IllegalArgumentException("total chunks field is null");
        }
        this.name = name;
        this.version = version;
        this.description = description;
        this.modelFormat = modelFormat;
        this.modelState = modelState;
        this.modelContentSizeInBytes = modelContentSizeInBytes;
        this.modelContentHashValue = modelContentHashValue;
        this.modelConfig = modelConfig;
        this.totalChunks = totalChunks;
    }

    public MLRegisterModelMetaInput(StreamInput in) throws IOException {
        this.name = in.readString();
        this.functionName = (FunctionName)in.readEnum(FunctionName.class);
        this.version = in.readString();
        this.description = in.readOptionalString();
        if (in.readBoolean()) {
            this.modelFormat = (MLModelFormat)in.readEnum(MLModelFormat.class);
        }
        if (in.readBoolean()) {
            this.modelState = (MLModelState)in.readEnum(MLModelState.class);
        }
        this.modelContentSizeInBytes = in.readOptionalLong();
        this.modelContentHashValue = in.readString();
        if (in.readBoolean()) {
            this.modelConfig = new TextEmbeddingModelConfig(in);
        }
        this.totalChunks = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeEnum((Enum)this.functionName);
        out.writeString(this.version);
        out.writeOptionalString(this.description);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.modelContentSizeInBytes);
        out.writeString(this.modelContentHashValue);
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.totalChunks.intValue());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_NAME_FIELD, this.name);
        builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        builder.field(MODEL_VERSION_FIELD, this.version);
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        builder.field(MODEL_FORMAT_FIELD, (Object)this.modelFormat);
        if (this.modelState != null) {
            builder.field(MODEL_STATE_FIELD, (Object)this.modelState);
        }
        if (this.modelContentSizeInBytes != null) {
            builder.field(MODEL_CONTENT_SIZE_IN_BYTES_FIELD, this.modelContentSizeInBytes);
        }
        builder.field(MODEL_CONTENT_HASH_VALUE_FIELD, this.modelContentHashValue);
        builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        builder.field(TOTAL_CHUNKS_FIELD, this.totalChunks);
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelMetaInput parse(XContentParser parser) throws IOException {
        String name = null;
        FunctionName functionName = null;
        String version = null;
        String description = null;
        MLModelFormat modelFormat = null;
        MLModelState modelState = null;
        Long modelContentSizeInBytes = null;
        String modelContentHashValue = null;
        TextEmbeddingModelConfig modelConfig = null;
        Integer totalChunks = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block24;
                }
                case "function_name": {
                    functionName = FunctionName.from(parser.text());
                    continue block24;
                }
                case "version": {
                    version = parser.text();
                    continue block24;
                }
                case "description": {
                    description = parser.text();
                    continue block24;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text());
                    continue block24;
                }
                case "model_state": {
                    modelState = MLModelState.from(parser.text());
                    continue block24;
                }
                case "model_content_size_in_bytes": {
                    modelContentSizeInBytes = parser.longValue();
                    continue block24;
                }
                case "model_content_hash_value": {
                    modelContentHashValue = parser.text();
                    continue block24;
                }
                case "model_config": {
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block24;
                }
                case "total_chunks": {
                    totalChunks = parser.intValue(false);
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelMetaInput(name, functionName, version, description, modelFormat, modelState, modelContentSizeInBytes, modelContentHashValue, modelConfig, totalChunks);
    }

    @Generated
    public static MLRegisterModelMetaInputBuilder builder() {
        return new MLRegisterModelMetaInputBuilder();
    }

    @Generated
    public MLRegisterModelMetaInputBuilder toBuilder() {
        return new MLRegisterModelMetaInputBuilder().name(this.name).functionName(this.functionName).version(this.version).description(this.description).modelFormat(this.modelFormat).modelState(this.modelState).modelContentSizeInBytes(this.modelContentSizeInBytes).modelContentHashValue(this.modelContentHashValue).modelConfig(this.modelConfig).totalChunks(this.totalChunks);
    }

    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    @Generated
    public MLModelState getModelState() {
        return this.modelState;
    }

    @Generated
    public Long getModelContentSizeInBytes() {
        return this.modelContentSizeInBytes;
    }

    @Generated
    public String getModelContentHashValue() {
        return this.modelContentHashValue;
    }

    @Generated
    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    @Generated
    public Integer getTotalChunks() {
        return this.totalChunks;
    }

    @Generated
    public void setFunctionName(FunctionName functionName) {
        this.functionName = functionName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setModelFormat(MLModelFormat modelFormat) {
        this.modelFormat = modelFormat;
    }

    @Generated
    public void setModelState(MLModelState modelState) {
        this.modelState = modelState;
    }

    @Generated
    public void setModelContentSizeInBytes(Long modelContentSizeInBytes) {
        this.modelContentSizeInBytes = modelContentSizeInBytes;
    }

    @Generated
    public void setModelContentHashValue(String modelContentHashValue) {
        this.modelContentHashValue = modelContentHashValue;
    }

    @Generated
    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    @Generated
    public void setTotalChunks(Integer totalChunks) {
        this.totalChunks = totalChunks;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLRegisterModelMetaInput)) {
            return false;
        }
        MLRegisterModelMetaInput other = (MLRegisterModelMetaInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$modelContentSizeInBytes = this.getModelContentSizeInBytes();
        Long other$modelContentSizeInBytes = other.getModelContentSizeInBytes();
        if (this$modelContentSizeInBytes == null ? other$modelContentSizeInBytes != null : !((Object)this$modelContentSizeInBytes).equals(other$modelContentSizeInBytes)) {
            return false;
        }
        Integer this$totalChunks = this.getTotalChunks();
        Integer other$totalChunks = other.getTotalChunks();
        if (this$totalChunks == null ? other$totalChunks != null : !((Object)this$totalChunks).equals(other$totalChunks)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)((Object)this$functionName)).equals((Object)other$functionName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MLModelFormat this$modelFormat = this.getModelFormat();
        MLModelFormat other$modelFormat = other.getModelFormat();
        if (this$modelFormat == null ? other$modelFormat != null : !((Object)((Object)this$modelFormat)).equals((Object)other$modelFormat)) {
            return false;
        }
        MLModelState this$modelState = this.getModelState();
        MLModelState other$modelState = other.getModelState();
        if (this$modelState == null ? other$modelState != null : !((Object)((Object)this$modelState)).equals((Object)other$modelState)) {
            return false;
        }
        String this$modelContentHashValue = this.getModelContentHashValue();
        String other$modelContentHashValue = other.getModelContentHashValue();
        if (this$modelContentHashValue == null ? other$modelContentHashValue != null : !this$modelContentHashValue.equals(other$modelContentHashValue)) {
            return false;
        }
        MLModelConfig this$modelConfig = this.getModelConfig();
        MLModelConfig other$modelConfig = other.getModelConfig();
        return !(this$modelConfig == null ? other$modelConfig != null : !this$modelConfig.equals(other$modelConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLRegisterModelMetaInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $modelContentSizeInBytes = this.getModelContentSizeInBytes();
        result = result * 59 + ($modelContentSizeInBytes == null ? 43 : ((Object)$modelContentSizeInBytes).hashCode());
        Integer $totalChunks = this.getTotalChunks();
        result = result * 59 + ($totalChunks == null ? 43 : ((Object)$totalChunks).hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)((Object)$functionName)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        MLModelFormat $modelFormat = this.getModelFormat();
        result = result * 59 + ($modelFormat == null ? 43 : ((Object)((Object)$modelFormat)).hashCode());
        MLModelState $modelState = this.getModelState();
        result = result * 59 + ($modelState == null ? 43 : ((Object)((Object)$modelState)).hashCode());
        String $modelContentHashValue = this.getModelContentHashValue();
        result = result * 59 + ($modelContentHashValue == null ? 43 : $modelContentHashValue.hashCode());
        MLModelConfig $modelConfig = this.getModelConfig();
        result = result * 59 + ($modelConfig == null ? 43 : $modelConfig.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLRegisterModelMetaInput(functionName=" + this.getFunctionName() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", modelFormat=" + this.getModelFormat() + ", modelState=" + this.getModelState() + ", modelContentSizeInBytes=" + this.getModelContentSizeInBytes() + ", modelContentHashValue=" + this.getModelContentHashValue() + ", modelConfig=" + this.getModelConfig() + ", totalChunks=" + this.getTotalChunks() + ")";
    }

    @Generated
    public static class MLRegisterModelMetaInputBuilder {
        @Generated
        private String name;
        @Generated
        private FunctionName functionName;
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private MLModelFormat modelFormat;
        @Generated
        private MLModelState modelState;
        @Generated
        private Long modelContentSizeInBytes;
        @Generated
        private String modelContentHashValue;
        @Generated
        private MLModelConfig modelConfig;
        @Generated
        private Integer totalChunks;

        @Generated
        MLRegisterModelMetaInputBuilder() {
        }

        @Generated
        public MLRegisterModelMetaInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelContentSizeInBytes(Long modelContentSizeInBytes) {
            this.modelContentSizeInBytes = modelContentSizeInBytes;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelContentHashValue(String modelContentHashValue) {
            this.modelContentHashValue = modelContentHashValue;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInputBuilder totalChunks(Integer totalChunks) {
            this.totalChunks = totalChunks;
            return this;
        }

        @Generated
        public MLRegisterModelMetaInput build() {
            return new MLRegisterModelMetaInput(this.name, this.functionName, this.version, this.description, this.modelFormat, this.modelState, this.modelContentSizeInBytes, this.modelContentHashValue, this.modelConfig, this.totalChunks);
        }

        @Generated
        public String toString() {
            return "MLRegisterModelMetaInput.MLRegisterModelMetaInputBuilder(name=" + this.name + ", functionName=" + this.functionName + ", version=" + this.version + ", description=" + this.description + ", modelFormat=" + this.modelFormat + ", modelState=" + this.modelState + ", modelContentSizeInBytes=" + this.modelContentSizeInBytes + ", modelContentHashValue=" + this.modelContentHashValue + ", modelConfig=" + this.modelConfig + ", totalChunks=" + this.totalChunks + ")";
        }
    }
}

