/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.register;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.MLModelFormat;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;

public class MLRegisterModelInput
implements ToXContentObject,
Writeable {
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String VERSION_FIELD = "version";
    public static final String URL_FIELD = "url";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_MODEL_FIELD = "deploy_model";
    public static final String MODEL_NODE_IDS_FIELD = "model_node_ids";
    private FunctionName functionName;
    private String modelName;
    private String version;
    private String description;
    private String url;
    private MLModelFormat modelFormat;
    private MLModelConfig modelConfig;
    private boolean deployModel;
    private String[] modelNodeIds;

    public MLRegisterModelInput(FunctionName functionName, String modelName, String version, String description, String url, MLModelFormat modelFormat, MLModelConfig modelConfig, boolean deployModel, String[] modelNodeIds) {
        this.functionName = functionName == null ? FunctionName.TEXT_EMBEDDING : functionName;
        if (modelName == null) {
            throw new IllegalArgumentException("model name is null");
        }
        if (version == null) {
            throw new IllegalArgumentException("model version is null");
        }
        if (modelFormat == null) {
            throw new IllegalArgumentException("model format is null");
        }
        if (url != null && modelConfig == null) {
            throw new IllegalArgumentException("model config is null");
        }
        this.modelName = modelName;
        this.version = version;
        this.description = description;
        this.url = url;
        this.modelFormat = modelFormat;
        this.modelConfig = modelConfig;
        this.deployModel = deployModel;
        this.modelNodeIds = modelNodeIds;
    }

    public MLRegisterModelInput(StreamInput in) throws IOException {
        this.functionName = (FunctionName)in.readEnum(FunctionName.class);
        this.modelName = in.readString();
        this.version = in.readString();
        this.description = in.readOptionalString();
        this.url = in.readOptionalString();
        if (in.readBoolean()) {
            this.modelFormat = (MLModelFormat)in.readEnum(MLModelFormat.class);
        }
        if (in.readBoolean()) {
            this.modelConfig = new TextEmbeddingModelConfig(in);
        }
        this.deployModel = in.readBoolean();
        this.modelNodeIds = in.readOptionalStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.functionName);
        out.writeString(this.modelName);
        out.writeString(this.version);
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.url);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.deployModel);
        out.writeOptionalStringArray(this.modelNodeIds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        builder.field(NAME_FIELD, this.modelName);
        builder.field(VERSION_FIELD, this.version);
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.url != null) {
            builder.field(URL_FIELD, this.url);
        }
        if (this.modelFormat != null) {
            builder.field(MODEL_FORMAT_FIELD, (Object)this.modelFormat);
        }
        if (this.modelConfig != null) {
            builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        }
        builder.field(DEPLOY_MODEL_FIELD, this.deployModel);
        if (this.modelNodeIds != null) {
            builder.field(MODEL_NODE_IDS_FIELD, (Object)this.modelNodeIds);
        }
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelInput parse(XContentParser parser, String modelName, String version, boolean deployModel) throws IOException {
        FunctionName functionName = null;
        String url = null;
        String description = null;
        MLModelFormat modelFormat = null;
        TextEmbeddingModelConfig modelConfig = null;
        ArrayList<String> modelNodeIds = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "function_name": {
                    functionName = FunctionName.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block16;
                }
                case "url": {
                    url = parser.text();
                    continue block16;
                }
                case "description": {
                    description = parser.text();
                    continue block16;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block16;
                }
                case "model_config": {
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block16;
                }
                case "model_node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelNodeIds.add(parser.text());
                    }
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelInput(functionName, modelName, version, description, url, modelFormat, modelConfig, deployModel, modelNodeIds.toArray(new String[0]));
    }

    public static MLRegisterModelInput parse(XContentParser parser, boolean deployModel) throws IOException {
        FunctionName functionName = null;
        String name = null;
        String version = null;
        String url = null;
        String description = null;
        MLModelFormat modelFormat = null;
        TextEmbeddingModelConfig modelConfig = null;
        ArrayList<String> modelNodeIds = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "function_name": {
                    functionName = FunctionName.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block20;
                }
                case "name": {
                    name = parser.text();
                    continue block20;
                }
                case "version": {
                    version = parser.text();
                    continue block20;
                }
                case "description": {
                    description = parser.text();
                    continue block20;
                }
                case "url": {
                    url = parser.text();
                    continue block20;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block20;
                }
                case "model_config": {
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block20;
                }
                case "model_node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelNodeIds.add(parser.text());
                    }
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelInput(functionName, name, version, description, url, modelFormat, modelConfig, deployModel, modelNodeIds.toArray(new String[0]));
    }

    @Generated
    public static MLRegisterModelInputBuilder builder() {
        return new MLRegisterModelInputBuilder();
    }

    @Generated
    public MLRegisterModelInputBuilder toBuilder() {
        return new MLRegisterModelInputBuilder().functionName(this.functionName).modelName(this.modelName).version(this.version).description(this.description).url(this.url).modelFormat(this.modelFormat).modelConfig(this.modelConfig).deployModel(this.deployModel).modelNodeIds(this.modelNodeIds);
    }

    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    @Generated
    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    @Generated
    public boolean isDeployModel() {
        return this.deployModel;
    }

    @Generated
    public String[] getModelNodeIds() {
        return this.modelNodeIds;
    }

    @Generated
    public void setFunctionName(FunctionName functionName) {
        this.functionName = functionName;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setModelFormat(MLModelFormat modelFormat) {
        this.modelFormat = modelFormat;
    }

    @Generated
    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    @Generated
    public void setDeployModel(boolean deployModel) {
        this.deployModel = deployModel;
    }

    @Generated
    public void setModelNodeIds(String[] modelNodeIds) {
        this.modelNodeIds = modelNodeIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLRegisterModelInput)) {
            return false;
        }
        MLRegisterModelInput other = (MLRegisterModelInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeployModel() != other.isDeployModel()) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)((Object)this$functionName)).equals((Object)other$functionName)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        MLModelFormat this$modelFormat = this.getModelFormat();
        MLModelFormat other$modelFormat = other.getModelFormat();
        if (this$modelFormat == null ? other$modelFormat != null : !((Object)((Object)this$modelFormat)).equals((Object)other$modelFormat)) {
            return false;
        }
        MLModelConfig this$modelConfig = this.getModelConfig();
        MLModelConfig other$modelConfig = other.getModelConfig();
        if (this$modelConfig == null ? other$modelConfig != null : !this$modelConfig.equals(other$modelConfig)) {
            return false;
        }
        return Arrays.deepEquals(this.getModelNodeIds(), other.getModelNodeIds());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLRegisterModelInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeployModel() ? 79 : 97);
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)((Object)$functionName)).hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        MLModelFormat $modelFormat = this.getModelFormat();
        result = result * 59 + ($modelFormat == null ? 43 : ((Object)((Object)$modelFormat)).hashCode());
        MLModelConfig $modelConfig = this.getModelConfig();
        result = result * 59 + ($modelConfig == null ? 43 : $modelConfig.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getModelNodeIds());
        return result;
    }

    @Generated
    public String toString() {
        return "MLRegisterModelInput(functionName=" + this.getFunctionName() + ", modelName=" + this.getModelName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", url=" + this.getUrl() + ", modelFormat=" + this.getModelFormat() + ", modelConfig=" + this.getModelConfig() + ", deployModel=" + this.isDeployModel() + ", modelNodeIds=" + Arrays.deepToString(this.getModelNodeIds()) + ")";
    }

    @Generated
    public static class MLRegisterModelInputBuilder {
        @Generated
        private FunctionName functionName;
        @Generated
        private String modelName;
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private String url;
        @Generated
        private MLModelFormat modelFormat;
        @Generated
        private MLModelConfig modelConfig;
        @Generated
        private boolean deployModel;
        @Generated
        private String[] modelNodeIds;

        @Generated
        MLRegisterModelInputBuilder() {
        }

        @Generated
        public MLRegisterModelInputBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder deployModel(boolean deployModel) {
            this.deployModel = deployModel;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelNodeIds(String[] modelNodeIds) {
            this.modelNodeIds = modelNodeIds;
            return this;
        }

        @Generated
        public MLRegisterModelInput build() {
            return new MLRegisterModelInput(this.functionName, this.modelName, this.version, this.description, this.url, this.modelFormat, this.modelConfig, this.deployModel, this.modelNodeIds);
        }

        @Generated
        public String toString() {
            return "MLRegisterModelInput.MLRegisterModelInputBuilder(functionName=" + this.functionName + ", modelName=" + this.modelName + ", version=" + this.version + ", description=" + this.description + ", url=" + this.url + ", modelFormat=" + this.modelFormat + ", modelConfig=" + this.modelConfig + ", deployModel=" + this.deployModel + ", modelNodeIds=" + Arrays.deepToString(this.modelNodeIds) + ")";
        }
    }
}

