/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output.model;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.output.model.MLResultDataType;

public class ModelTensor
implements Writeable,
ToXContentObject {
    private String name;
    private Number[] data;
    private long[] shape;
    private MLResultDataType dataType;
    private ByteBuffer byteBuffer;

    public ModelTensor(String name, Number[] data, long[] shape, MLResultDataType dataType, ByteBuffer byteBuffer) {
        if (data != null && (dataType == null || dataType == MLResultDataType.UNKNOWN)) {
            throw new IllegalArgumentException("data type is null");
        }
        this.name = name;
        this.data = data;
        this.shape = shape;
        this.dataType = dataType;
        this.byteBuffer = byteBuffer;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.dataType != null) {
            builder.field("data_type", (Object)this.dataType);
        }
        if (this.shape != null) {
            builder.field("shape", (Object)this.shape);
        }
        if (this.data != null) {
            builder.field("data", (Object)this.data);
        }
        if (this.byteBuffer != null) {
            builder.startObject("byte_buffer");
            builder.field("array", this.byteBuffer.array());
            builder.field("order", this.byteBuffer.order().toString());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public ModelTensor(StreamInput in) throws IOException {
        this.name = in.readOptionalString();
        if (in.readBoolean()) {
            this.dataType = (MLResultDataType)in.readEnum(MLResultDataType.class);
        }
        if (in.readBoolean()) {
            this.shape = in.readLongArray();
        }
        if (in.readBoolean()) {
            int i;
            int size = in.readInt();
            this.data = new Number[size];
            if (this.dataType.isFloating()) {
                for (i = 0; i < size; ++i) {
                    this.data[i] = Float.valueOf(in.readFloat());
                }
            } else if (this.dataType.isInteger() || this.dataType.isBoolean()) {
                for (i = 0; i < size; ++i) {
                    this.data[i] = in.readInt();
                }
            } else {
                this.data = null;
            }
        }
        if (in.readBoolean()) {
            String orderName = in.readString();
            ByteOrder byteOrder = null;
            if (ByteOrder.BIG_ENDIAN.toString().equals(orderName)) {
                byteOrder = ByteOrder.BIG_ENDIAN;
            } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(orderName)) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else {
                throw new IllegalArgumentException("wrong byte order");
            }
            byte[] bytes = in.readByteArray();
            this.byteBuffer = ByteBuffer.wrap(bytes);
            this.byteBuffer.order(byteOrder);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        if (this.dataType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.dataType);
        } else {
            out.writeBoolean(false);
        }
        if (this.shape != null) {
            out.writeBoolean(true);
            out.writeLongArray(this.shape);
        } else {
            out.writeBoolean(false);
        }
        if (this.data != null && this.dataType != null && this.dataType != MLResultDataType.UNKNOWN) {
            out.writeBoolean(true);
            out.writeInt(this.data.length);
            if (this.dataType.isFloating()) {
                for (Number n : this.data) {
                    out.writeFloat(n.floatValue());
                }
            } else if (this.dataType.isInteger() || this.dataType.isBoolean()) {
                for (Number n : this.data) {
                    out.writeInt(n.intValue());
                }
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.byteBuffer != null && this.byteBuffer.hasArray()) {
            out.writeBoolean(true);
            out.writeString(this.byteBuffer.order().toString());
            out.writeByteArray(this.byteBuffer.array());
        } else {
            out.writeBoolean(false);
        }
    }

    @Generated
    public static ModelTensorBuilder builder() {
        return new ModelTensorBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Number[] getData() {
        return this.data;
    }

    @Generated
    public long[] getShape() {
        return this.shape;
    }

    @Generated
    public MLResultDataType getDataType() {
        return this.dataType;
    }

    @Generated
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setData(Number[] data) {
        this.data = data;
    }

    @Generated
    public void setShape(long[] shape) {
        this.shape = shape;
    }

    @Generated
    public void setDataType(MLResultDataType dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelTensor)) {
            return false;
        }
        ModelTensor other = (ModelTensor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getData(), other.getData())) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        MLResultDataType this$dataType = this.getDataType();
        MLResultDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        ByteBuffer this$byteBuffer = this.getByteBuffer();
        ByteBuffer other$byteBuffer = other.getByteBuffer();
        return !(this$byteBuffer == null ? other$byteBuffer != null : !((Object)this$byteBuffer).equals(other$byteBuffer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelTensor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getData());
        result = result * 59 + Arrays.hashCode(this.getShape());
        MLResultDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        ByteBuffer $byteBuffer = this.getByteBuffer();
        result = result * 59 + ($byteBuffer == null ? 43 : ((Object)$byteBuffer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModelTensor(name=" + this.getName() + ", data=" + Arrays.deepToString(this.getData()) + ", shape=" + Arrays.toString(this.getShape()) + ", dataType=" + this.getDataType() + ", byteBuffer=" + this.getByteBuffer() + ")";
    }

    @Generated
    public static class ModelTensorBuilder {
        @Generated
        private String name;
        @Generated
        private Number[] data;
        @Generated
        private long[] shape;
        @Generated
        private MLResultDataType dataType;
        @Generated
        private ByteBuffer byteBuffer;

        @Generated
        ModelTensorBuilder() {
        }

        @Generated
        public ModelTensorBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ModelTensorBuilder data(Number[] data) {
            this.data = data;
            return this;
        }

        @Generated
        public ModelTensorBuilder shape(long[] shape) {
            this.shape = shape;
            return this;
        }

        @Generated
        public ModelTensorBuilder dataType(MLResultDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        @Generated
        public ModelTensorBuilder byteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            return this;
        }

        @Generated
        public ModelTensor build() {
            return new ModelTensor(this.name, this.data, this.shape, this.dataType, this.byteBuffer);
        }

        @Generated
        public String toString() {
            return "ModelTensor.ModelTensorBuilder(name=" + this.name + ", data=" + Arrays.deepToString(this.data) + ", shape=" + Arrays.toString(this.shape) + ", dataType=" + this.dataType + ", byteBuffer=" + this.byteBuffer + ")";
        }
    }
}

