/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model.config;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.Chime;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.EmailGroup;
import org.opensearch.commons.notifications.model.Slack;
import org.opensearch.commons.notifications.model.SmtpAccount;
import org.opensearch.commons.notifications.model.Webhook;
import org.opensearch.commons.notifications.model.XParser;
import org.opensearch.commons.notifications.model.config.ConfigDataProperties$WhenMappings;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\r2\u0006\u0010\t\u001a\u00020\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/config/ConfigDataProperties;", "", "()V", "CONFIG_PROPERTIES_MAP", "", "Lorg/opensearch/commons/notifications/model/ConfigType;", "Lorg/opensearch/commons/notifications/model/config/ConfigDataProperties$ConfigProperty;", "createConfigData", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "configType", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "getReaderForConfigType", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "validateConfigData", "", "configData", "ConfigProperty", "common-utils"})
public final class ConfigDataProperties {
    private static final Map<ConfigType, ConfigProperty> CONFIG_PROPERTIES_MAP;
    @NotNull
    public static final ConfigDataProperties INSTANCE;

    @NotNull
    public final Writeable.Reader<? extends BaseConfigData> getReaderForConfigType(@NotNull ConfigType configType) {
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Writeable.Reader<? extends BaseConfigData> reader2 = CONFIG_PROPERTIES_MAP.get((Object)configType);
        if (reader2 == null || (reader2 = reader2.getConfigDataReader()) == null) {
            throw (Throwable)new IllegalArgumentException("Transport action used with unknown ConfigType:" + (Object)((Object)configType));
        }
        return reader2;
    }

    public final boolean validateConfigData(@NotNull ConfigType configType, @Nullable BaseConfigData configData) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        switch (ConfigDataProperties$WhenMappings.$EnumSwitchMapping$0[configType.ordinal()]) {
            case 1: {
                bl = configData instanceof Slack;
                break;
            }
            case 2: {
                bl = configData instanceof Webhook;
                break;
            }
            case 3: {
                bl = configData instanceof Email;
                break;
            }
            case 4: {
                bl = configData instanceof EmailGroup;
                break;
            }
            case 5: {
                bl = configData instanceof SmtpAccount;
                break;
            }
            case 6: {
                bl = configData instanceof Chime;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Nullable
    public final BaseConfigData createConfigData(@NotNull ConfigType configType, @NotNull XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Object object = CONFIG_PROPERTIES_MAP.get((Object)configType);
        return object != null && (object = ((ConfigProperty)object).getConfigDataParser()) != null ? (BaseConfigData)object.parse(parser) : null;
    }

    private ConfigDataProperties() {
    }

    static {
        ConfigDataProperties configDataProperties;
        INSTANCE = configDataProperties = new ConfigDataProperties();
        CONFIG_PROPERTIES_MAP = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)ConfigType.SLACK, (Object)new ConfigProperty(Slack.Companion.getReader(), Slack.Companion.getXParser())), new Pair((Object)ConfigType.CHIME, (Object)new ConfigProperty(Chime.Companion.getReader(), Chime.Companion.getXParser())), new Pair((Object)ConfigType.WEBHOOK, (Object)new ConfigProperty(Webhook.Companion.getReader(), Webhook.Companion.getXParser())), new Pair((Object)ConfigType.EMAIL, (Object)new ConfigProperty(Email.Companion.getReader(), Email.Companion.getXParser())), new Pair((Object)ConfigType.EMAIL_GROUP, (Object)new ConfigProperty(EmailGroup.Companion.getReader(), EmailGroup.Companion.getXParser())), new Pair((Object)ConfigType.SMTP_ACCOUNT, (Object)new ConfigProperty(SmtpAccount.Companion.getReader(), SmtpAccount.Companion.getXParser()))});
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0011\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0003J-\u0010\u000e\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/commons/notifications/model/config/ConfigDataProperties$ConfigProperty;", "", "configDataReader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "configDataParser", "Lorg/opensearch/commons/notifications/model/XParser;", "(Lorg/opensearch/common/io/stream/Writeable$Reader;Lorg/opensearch/commons/notifications/model/XParser;)V", "getConfigDataParser", "()Lorg/opensearch/commons/notifications/model/XParser;", "getConfigDataReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "common-utils"})
    private static final class ConfigProperty {
        @NotNull
        private final Writeable.Reader<? extends BaseConfigData> configDataReader;
        @NotNull
        private final XParser<? extends BaseConfigData> configDataParser;

        @NotNull
        public final Writeable.Reader<? extends BaseConfigData> getConfigDataReader() {
            return this.configDataReader;
        }

        @NotNull
        public final XParser<? extends BaseConfigData> getConfigDataParser() {
            return this.configDataParser;
        }

        public ConfigProperty(@NotNull Writeable.Reader<? extends BaseConfigData> configDataReader, @NotNull XParser<? extends BaseConfigData> configDataParser) {
            Intrinsics.checkNotNullParameter(configDataReader, (String)"configDataReader");
            Intrinsics.checkNotNullParameter(configDataParser, (String)"configDataParser");
            this.configDataReader = configDataReader;
            this.configDataParser = configDataParser;
        }

        @NotNull
        public final Writeable.Reader<? extends BaseConfigData> component1() {
            return this.configDataReader;
        }

        @NotNull
        public final XParser<? extends BaseConfigData> component2() {
            return this.configDataParser;
        }

        @NotNull
        public final ConfigProperty copy(@NotNull Writeable.Reader<? extends BaseConfigData> configDataReader, @NotNull XParser<? extends BaseConfigData> configDataParser) {
            Intrinsics.checkNotNullParameter(configDataReader, (String)"configDataReader");
            Intrinsics.checkNotNullParameter(configDataParser, (String)"configDataParser");
            return new ConfigProperty(configDataReader, configDataParser);
        }

        public static /* synthetic */ ConfigProperty copy$default(ConfigProperty configProperty, Writeable.Reader reader2, XParser xParser2, int n, Object object) {
            if ((n & 1) != 0) {
                reader2 = configProperty.configDataReader;
            }
            if ((n & 2) != 0) {
                xParser2 = configProperty.configDataParser;
            }
            return configProperty.copy(reader2, xParser2);
        }

        @NotNull
        public String toString() {
            return "ConfigProperty(configDataReader=" + this.configDataReader + ", configDataParser=" + this.configDataParser + ")";
        }

        public int hashCode() {
            Writeable.Reader<? extends BaseConfigData> reader2 = this.configDataReader;
            XParser<? extends BaseConfigData> xParser2 = this.configDataParser;
            return (reader2 != null ? reader2.hashCode() : 0) * 31 + (xParser2 != null ? xParser2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConfigProperty)) break block3;
                    ConfigProperty configProperty = (ConfigProperty)object;
                    if (!Intrinsics.areEqual(this.configDataReader, configProperty.configDataReader) || !Intrinsics.areEqual(this.configDataParser, configProperty.configDataParser)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

