/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.EnumSet;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Feature;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.notifications.model.config.ConfigDataProperties;
import org.opensearch.commons.utils.EnumParser;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010!\u001a\u00020\u0010H\u00c6\u0003JM\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010*2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u00063"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfig;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "name", "", "description", "configType", "Lorg/opensearch/commons/notifications/model/ConfigType;", "features", "Ljava/util/EnumSet;", "Lorg/opensearch/commons/notifications/model/Feature;", "configData", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "isEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/commons/notifications/model/ConfigType;Ljava/util/EnumSet;Lorg/opensearch/commons/notifications/model/BaseConfigData;Z)V", "getConfigData", "()Lorg/opensearch/commons/notifications/model/BaseConfigData;", "getConfigType", "()Lorg/opensearch/commons/notifications/model/ConfigType;", "getDescription", "()Ljava/lang/String;", "getFeatures", "()Ljava/util/EnumSet;", "()Z", "getName", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class NotificationConfig
implements BaseModel {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final ConfigType configType;
    @NotNull
    private final EnumSet<Feature> features;
    @Nullable
    private final BaseConfigData configData;
    private final boolean isEnabled;
    private static final Lazy log$delegate;
    @NotNull
    private static final Writeable.Reader<NotificationConfig> reader;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("name", this.name).field("description", this.description).field("config_type", this.configType.getTag()).field("feature_list", (Iterable)this.features).field("is_enabled", this.isEnabled);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026S_ENABLED_TAG, isEnabled)");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull(xContentBuilder, this.configType.getTag(), this.configData).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder2;
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.name);
        output.writeString(this.description);
        output.writeEnum((Enum)this.configType);
        output.writeEnumSet(this.features);
        output.writeBoolean(this.isEnabled);
        output.writeEnum((Enum)this.configType);
        output.writeOptionalWriteable((Writeable)this.configData);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final ConfigType getConfigType() {
        return this.configType;
    }

    @NotNull
    public final EnumSet<Feature> getFeatures() {
        return this.features;
    }

    @Nullable
    public final BaseConfigData getConfigData() {
        return this.configData;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public NotificationConfig(@NotNull String name, @NotNull String description, @NotNull ConfigType configType, @NotNull EnumSet<Feature> features, @Nullable BaseConfigData configData, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.name = name;
        this.description = description;
        this.configType = configType;
        this.features = features;
        this.configData = configData;
        this.isEnabled = isEnabled;
        boolean bl = !Strings.isNullOrEmpty((String)this.name);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "name is null or empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (!ConfigDataProperties.INSTANCE.validateConfigData(this.configType, this.configData)) {
            throw (Throwable)new IllegalArgumentException("ConfigType: " + (Object)((Object)this.configType) + " and data doesn't match");
        }
        if (this.configType == ConfigType.NONE) {
            NotificationConfig.Companion.getLog().info("Some config field not recognized");
        }
    }

    public /* synthetic */ NotificationConfig(String string, String string2, ConfigType configType, EnumSet enumSet, BaseConfigData baseConfigData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(string, string2, configType, enumSet, baseConfigData, bl);
    }

    public NotificationConfig(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readString()");
        String string2 = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"input.readString()");
        Enum enum_ = input.readEnum(ConfigType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"input.readEnum(ConfigType::class.java)");
        ConfigType configType = (ConfigType)enum_;
        EnumSet enumSet = input.readEnumSet(Feature.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumSet, (String)"input.readEnumSet(Feature::class.java)");
        boolean bl = input.readBoolean();
        Enum enum_2 = input.readEnum(ConfigType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_2, (String)"input.readEnum(ConfigType::class.java)");
        BaseConfigData baseConfigData = (BaseConfigData)input.readOptionalWriteable(ConfigDataProperties.INSTANCE.getReaderForConfigType((ConfigType)enum_2));
        boolean bl2 = bl;
        this(string, string2, configType, enumSet, baseConfigData, bl2);
    }

    static {
        Companion = new Companion(null);
        log$delegate = HelpersKt.logger(NotificationConfig.class);
        reader = Companion.reader.1.INSTANCE;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.description;
    }

    @NotNull
    public final ConfigType component3() {
        return this.configType;
    }

    @NotNull
    public final EnumSet<Feature> component4() {
        return this.features;
    }

    @Nullable
    public final BaseConfigData component5() {
        return this.configData;
    }

    public final boolean component6() {
        return this.isEnabled;
    }

    @NotNull
    public final NotificationConfig copy(@NotNull String name, @NotNull String description, @NotNull ConfigType configType, @NotNull EnumSet<Feature> features, @Nullable BaseConfigData configData, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        return new NotificationConfig(name, description, configType, features, configData, isEnabled);
    }

    public static /* synthetic */ NotificationConfig copy$default(NotificationConfig notificationConfig, String string, String string2, ConfigType configType, EnumSet enumSet, BaseConfigData baseConfigData, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = notificationConfig.name;
        }
        if ((n & 2) != 0) {
            string2 = notificationConfig.description;
        }
        if ((n & 4) != 0) {
            configType = notificationConfig.configType;
        }
        if ((n & 8) != 0) {
            enumSet = notificationConfig.features;
        }
        if ((n & 0x10) != 0) {
            baseConfigData = notificationConfig.configData;
        }
        if ((n & 0x20) != 0) {
            bl = notificationConfig.isEnabled;
        }
        return notificationConfig.copy(string, string2, configType, enumSet, baseConfigData, bl);
    }

    @NotNull
    public String toString() {
        return "NotificationConfig(name=" + this.name + ", description=" + this.description + ", configType=" + (Object)((Object)this.configType) + ", features=" + this.features + ", configData=" + this.configData + ", isEnabled=" + this.isEnabled + ")";
    }

    public int hashCode() {
        String string = this.name;
        String string2 = this.description;
        ConfigType configType = this.configType;
        EnumSet<Feature> enumSet = this.features;
        BaseConfigData baseConfigData = this.configData;
        int n = (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (configType != null ? ((Object)((Object)configType)).hashCode() : 0)) * 31 + (enumSet != null ? ((Object)enumSet).hashCode() : 0)) * 31 + (baseConfigData != null ? baseConfigData.hashCode() : 0)) * 31;
        int n2 = this.isEnabled ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof NotificationConfig)) break block3;
                NotificationConfig notificationConfig = (NotificationConfig)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)notificationConfig.name) || !Intrinsics.areEqual((Object)this.description, (Object)notificationConfig.description) || !Intrinsics.areEqual((Object)((Object)this.configType), (Object)((Object)notificationConfig.configType)) || !Intrinsics.areEqual(this.features, notificationConfig.features) || !Intrinsics.areEqual((Object)this.configData, (Object)notificationConfig.configData) || this.isEnabled != notificationConfig.isEnabled) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final NotificationConfig parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfig$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private final Logger getLog() {
            Lazy lazy = log$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<NotificationConfig> getReader() {
            return reader;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final NotificationConfig parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String name = null;
            String description = "";
            ConfigType configType = null;
            EnumSet<Feature> features = null;
            boolean isEnabled = true;
            BaseConfigData configData = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                if (fieldName != null) {
                    String string;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -109284052: {
                            if (!string.equals("is_enabled")) break;
                            n = 1;
                            break;
                        }
                        case 3373707: {
                            if (!string.equals("name")) break;
                            n = 2;
                            break;
                        }
                        case 1208965191: {
                            if (!string.equals("feature_list")) break;
                            n = 3;
                            break;
                        }
                        case -1724546052: {
                            if (!string.equals("description")) break;
                            n = 4;
                            break;
                        }
                        case 17530391: {
                            if (!string.equals("config_type")) break;
                            n = 5;
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            name = parser.text();
                            continue block14;
                        }
                        case 4: {
                            Intrinsics.checkNotNullExpressionValue((Object)parser.text(), (String)"parser.text()");
                            continue block14;
                        }
                        case 5: {
                            String string2 = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                            configType = ConfigType.Companion.fromTagOrDefault(string2);
                            continue block14;
                        }
                        case 3: {
                            EnumSet<Feature> retSet$iv;
                            void $this$enumSet$iv;
                            XContentParser xContentParser = parser;
                            EnumParser<Feature> enumParser$iv = Feature.Companion.getEnumParser();
                            boolean $i$f$enumSet = false;
                            Intrinsics.checkNotNullExpressionValue(EnumSet.noneOf(Feature.class), (String)"EnumSet.noneOf(E::class.java)");
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)$this$enumSet$iv.currentToken(), (XContentParser)$this$enumSet$iv);
                            while ($this$enumSet$iv.nextToken() != XContentParser.Token.END_ARRAY) {
                                String string3 = $this$enumSet$iv.text();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text()");
                                retSet$iv.add(enumParser$iv.fromTagOrDefault(string3));
                            }
                            features = retSet$iv;
                            continue block14;
                        }
                        case 1: {
                            isEnabled = parser.booleanValue();
                            continue block14;
                        }
                    }
                }
                String string = fieldName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fieldName");
                ConfigType configTypeForTag = ConfigType.Companion.fromTagOrDefault(string);
                if (configTypeForTag != ConfigType.NONE && configData == null) {
                    configData = ConfigDataProperties.INSTANCE.createConfigData(configTypeForTag, parser);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing configuration");
            }
            if (name == null) {
                throw (Throwable)new IllegalArgumentException("name field absent");
            }
            if (configType == null) {
                throw (Throwable)new IllegalArgumentException("config_type field absent");
            }
            if (features == null) {
                throw (Throwable)new IllegalArgumentException("feature_list field absent");
            }
            return new NotificationConfig(name, description, configType, features, configData, isEnabled);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

