/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 2*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u000223B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006B5\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eB-\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0017B\u001d\b\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010&\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010*2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"\u00a8\u00064"}, d2={"Lorg/opensearch/commons/notifications/model/SearchResults;", "ItemClass", "Lorg/opensearch/commons/notifications/model/BaseModel;", "objectListFieldName", "", "objectItem", "(Ljava/lang/String;Lorg/opensearch/commons/notifications/model/BaseModel;)V", "startIndex", "", "totalHits", "totalHitRelation", "Lorg/apache/lucene/search/TotalHits$Relation;", "objectList", "", "(JJLorg/apache/lucene/search/TotalHits$Relation;Ljava/lang/String;Ljava/util/List;)V", "from", "response", "Lorg/opensearch/action/search/SearchResponse;", "searchHitParser", "Lorg/opensearch/commons/notifications/model/SearchResults$SearchHitParser;", "(JLorg/opensearch/action/search/SearchResponse;Lorg/opensearch/commons/notifications/model/SearchResults$SearchHitParser;Ljava/lang/String;)V", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "(Lorg/opensearch/common/xcontent/XContentParser;Ljava/lang/String;)V", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "(Lorg/opensearch/common/io/stream/StreamInput;Lorg/opensearch/common/io/stream/Writeable$Reader;)V", "getObjectList", "()Ljava/util/List;", "getObjectListFieldName", "()Ljava/lang/String;", "getStartIndex", "()J", "getTotalHitRelation", "()Lorg/apache/lucene/search/TotalHits$Relation;", "getTotalHits", "parseItem", "(Lorg/opensearch/common/xcontent/XContentParser;)Lorg/opensearch/commons/notifications/model/BaseModel;", "parseItemList", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "SearchHitParser", "common-utils"})
public abstract class SearchResults<ItemClass extends BaseModel>
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long startIndex;
    private final long totalHits;
    @NotNull
    private final TotalHits.Relation totalHitRelation;
    @NotNull
    private final String objectListFieldName;
    @NotNull
    private final List<ItemClass> objectList;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(SearchResults.class);

    public final long getStartIndex() {
        return this.startIndex;
    }

    public final long getTotalHits() {
        return this.totalHits;
    }

    @NotNull
    public final TotalHits.Relation getTotalHitRelation() {
        return this.totalHitRelation;
    }

    @NotNull
    public final String getObjectListFieldName() {
        return this.objectListFieldName;
    }

    @NotNull
    public final List<ItemClass> getObjectList() {
        return this.objectList;
    }

    public SearchResults(@NotNull String objectListFieldName, @NotNull ItemClass objectItem) {
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        Intrinsics.checkNotNullParameter(objectItem, (String)"objectItem");
        this.startIndex = 0L;
        this.totalHits = 1L;
        this.totalHitRelation = TotalHits.Relation.EQUAL_TO;
        this.objectListFieldName = objectListFieldName;
        this.objectList = CollectionsKt.listOf(objectItem);
    }

    public SearchResults(long startIndex, long totalHits, @NotNull TotalHits.Relation totalHitRelation, @NotNull String objectListFieldName, @NotNull List<? extends ItemClass> objectList) {
        Intrinsics.checkNotNullParameter((Object)totalHitRelation, (String)"totalHitRelation");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        Intrinsics.checkNotNullParameter(objectList, (String)"objectList");
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = totalHitRelation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = objectList;
    }

    public SearchResults(long from, @NotNull SearchResponse response, @NotNull SearchHitParser<ItemClass> searchHitParser, @NotNull String objectListFieldName) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(searchHitParser, (String)"searchHitParser");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        List mutableList = new ArrayList();
        SearchHits searchHits = response.getHits();
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"response.hits");
        Iterable $this$forEach$iv = (Iterable)searchHits;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchHit it = (SearchHit)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            mutableList.add(searchHitParser.parse(it));
        }
        TotalHits totalHits = response.getHits().getTotalHits();
        long totalHitsVal = 0L;
        TotalHits.Relation totalHitsRelation = null;
        if (totalHits == null) {
            totalHitsVal = mutableList.size();
            totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        } else {
            totalHitsVal = totalHits.value;
            TotalHits.Relation relation = totalHits.relation;
            Intrinsics.checkNotNullExpressionValue((Object)relation, (String)"totalHits.relation");
            totalHitsRelation = relation;
        }
        this.startIndex = from;
        this.totalHits = totalHitsVal;
        this.totalHitRelation = totalHitsRelation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = mutableList;
    }

    public SearchResults(@NotNull XContentParser parser, @NotNull String objectListFieldName) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        long startIndex = 0L;
        long totalHits = 0L;
        TotalHits.Relation totalHitRelation = TotalHits.Relation.EQUAL_TO;
        List<ItemClass> objectList = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
            String fieldName = parser.currentName();
            parser.nextToken();
            String string = fieldName;
            if (Intrinsics.areEqual((Object)string, (Object)"start_index")) {
                startIndex = parser.longValue();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"total_hits")) {
                totalHits = parser.longValue();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"total_hit_relation")) {
                String string2 = parser.text();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                totalHitRelation = SearchResults.Companion.convertRelation(string2);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)objectListFieldName)) {
                objectList = this.parseItemList(parser);
                continue;
            }
            parser.skipChildren();
            SearchResults.Companion.getLog().info(Intrinsics.stringPlus((String)"Skipping Unknown field ", (Object)fieldName));
        }
        if (objectList == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)objectListFieldName, (Object)" field absent"));
        }
        if (totalHits == 0L) {
            totalHits = objectList.size();
        }
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = totalHitRelation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = objectList;
    }

    private final List<ItemClass> parseItemList(XContentParser parser) {
        List retList = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            retList.add(this.parseItem(parser));
        }
        return retList;
    }

    @NotNull
    public abstract ItemClass parseItem(@NotNull XContentParser var1);

    public SearchResults(@NotNull StreamInput input, @NotNull Writeable.Reader<ItemClass> reader) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        long l = input.readLong();
        long l2 = input.readLong();
        Object object = input.readEnum(TotalHits.Relation.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readEnum(Relation::class.java)");
        TotalHits.Relation relation = (TotalHits.Relation)object;
        object = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readString()");
        Object object2 = object;
        object = input.readList(reader);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readList(reader)");
        this(l, l2, relation, (String)object2, (List<ItemClass>)object);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeLong(this.startIndex);
        output.writeLong(this.totalHits);
        output.writeEnum((Enum)this.totalHitRelation);
        output.writeString(this.objectListFieldName);
        output.writeList(this.objectList);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        xContentBuilder.startObject().field("start_index", this.startIndex).field("total_hits", this.totalHits).field("total_hit_relation", SearchResults.Companion.convertRelation(this.totalHitRelation)).startArray(this.objectListFieldName);
        Iterable $this$forEach$iv = this.objectList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseModel it = (BaseModel)element$iv;
            boolean bl = false;
            it.toXContent(builder, params);
        }
        XContentBuilder xContentBuilder2 = builder.endArray().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.endArray().endObject()");
        return xContentBuilder2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/commons/notifications/model/SearchResults$SearchHitParser;", "ItemClass", "", "parse", "searchHit", "Lorg/opensearch/search/SearchHit;", "(Lorg/opensearch/search/SearchHit;)Ljava/lang/Object;", "common-utils"})
    public static interface SearchHitParser<ItemClass> {
        public ItemClass parse(@NotNull SearchHit var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/opensearch/commons/notifications/model/SearchResults$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "convertRelation", "Lorg/apache/lucene/search/TotalHits$Relation;", "totalHitRelation", "", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        private final String convertRelation(TotalHits.Relation totalHitRelation) {
            return totalHitRelation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte";
        }

        private final TotalHits.Relation convertRelation(String totalHitRelation) {
            return Intrinsics.areEqual((Object)totalHitRelation, (Object)"eq") ? TotalHits.Relation.EQUAL_TO : TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

