/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.DeliveryStatus;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.ValidationHelpersKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lorg/opensearch/commons/notifications/model/EmailRecipientStatus;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "recipient", "", "deliveryStatus", "Lorg/opensearch/commons/notifications/model/DeliveryStatus;", "(Ljava/lang/String;Lorg/opensearch/commons/notifications/model/DeliveryStatus;)V", "getDeliveryStatus", "()Lorg/opensearch/commons/notifications/model/DeliveryStatus;", "getRecipient", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class EmailRecipientStatus
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recipient;
    @NotNull
    private final DeliveryStatus deliveryStatus;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(EmailRecipientStatus.class);
    @NotNull
    private static final Writeable.Reader<EmailRecipientStatus> reader = EmailRecipientStatus::reader$lambda-0;

    public EmailRecipientStatus(@NotNull String recipient, @NotNull DeliveryStatus deliveryStatus) {
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Intrinsics.checkNotNullParameter((Object)deliveryStatus, (String)"deliveryStatus");
        this.recipient = recipient;
        this.deliveryStatus = deliveryStatus;
        ValidationHelpersKt.validateEmail(this.recipient);
    }

    @NotNull
    public final String getRecipient() {
        return this.recipient;
    }

    @NotNull
    public final DeliveryStatus getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public EmailRecipientStatus(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object object = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readString()");
        String string = object;
        object = DeliveryStatus.Companion.getReader().read(input);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DeliveryStatus.reader.read(input)");
        this(string, (DeliveryStatus)object);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.recipient);
        this.deliveryStatus.writeTo(output);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("recipient", this.recipient).field("delivery_status", (ToXContent)this.deliveryStatus).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    @NotNull
    public final String component1() {
        return this.recipient;
    }

    @NotNull
    public final DeliveryStatus component2() {
        return this.deliveryStatus;
    }

    @NotNull
    public final EmailRecipientStatus copy(@NotNull String recipient, @NotNull DeliveryStatus deliveryStatus) {
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Intrinsics.checkNotNullParameter((Object)deliveryStatus, (String)"deliveryStatus");
        return new EmailRecipientStatus(recipient, deliveryStatus);
    }

    public static /* synthetic */ EmailRecipientStatus copy$default(EmailRecipientStatus emailRecipientStatus, String string, DeliveryStatus deliveryStatus, int n, Object object) {
        if ((n & 1) != 0) {
            string = emailRecipientStatus.recipient;
        }
        if ((n & 2) != 0) {
            deliveryStatus = emailRecipientStatus.deliveryStatus;
        }
        return emailRecipientStatus.copy(string, deliveryStatus);
    }

    @NotNull
    public String toString() {
        return "EmailRecipientStatus(recipient=" + this.recipient + ", deliveryStatus=" + this.deliveryStatus + ')';
    }

    public int hashCode() {
        int result = this.recipient.hashCode();
        result = result * 31 + this.deliveryStatus.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EmailRecipientStatus)) {
            return false;
        }
        EmailRecipientStatus emailRecipientStatus = (EmailRecipientStatus)other;
        if (!Intrinsics.areEqual((Object)this.recipient, (Object)emailRecipientStatus.recipient)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.deliveryStatus, (Object)emailRecipientStatus.deliveryStatus);
    }

    private static final EmailRecipientStatus reader$lambda-0(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new EmailRecipientStatus(it);
    }

    @JvmStatic
    @NotNull
    public static final EmailRecipientStatus parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/EmailRecipientStatus$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/EmailRecipientStatus;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<EmailRecipientStatus> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final EmailRecipientStatus parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String recipient = null;
            DeliveryStatus deliveryStatus = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)"recipient")) {
                    recipient = parser.text();
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"delivery_status")) {
                    deliveryStatus = DeliveryStatus.Companion.parse(parser);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing Email Recipient Status");
            }
            if (recipient == null) {
                throw new IllegalArgumentException("recipient field absent");
            }
            if (deliveryStatus == null) {
                throw new IllegalArgumentException("delivery_status field absent");
            }
            return new EmailRecipientStatus(recipient, deliveryStatus);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

