/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.parameter;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.annotation.MLAlgoParameter;
import org.opensearch.ml.common.parameter.FunctionName;
import org.opensearch.ml.common.parameter.MLAlgoParams;

@MLAlgoParameter(algorithms={FunctionName.KMEANS})
public class KMeansParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.KMEANS.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> KMeansParams.parse(it));
    public static final String CENTROIDS_FIELD = "centroids";
    public static final String ITERATIONS_FIELD = "iterations";
    public static final String DISTANCE_TYPE_FIELD = "distance_type";
    private Integer centroids;
    private Integer iterations;
    private DistanceType distanceType;

    public KMeansParams(Integer centroids, Integer iterations, DistanceType distanceType) {
        this.centroids = centroids;
        this.iterations = iterations;
        this.distanceType = distanceType;
    }

    public KMeansParams(StreamInput in) throws IOException {
        this.centroids = in.readOptionalInt();
        this.iterations = in.readOptionalInt();
        if (in.readBoolean()) {
            this.distanceType = (DistanceType)in.readEnum(DistanceType.class);
        }
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        Integer k = null;
        Integer iterations = null;
        DistanceType distanceType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "centroids": {
                    k = parser.intValue(false);
                    continue block10;
                }
                case "iterations": {
                    iterations = parser.intValue(false);
                    continue block10;
                }
                case "distance_type": {
                    distanceType = DistanceType.from(parser.text());
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new KMeansParams(k, iterations, distanceType);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.centroids);
        out.writeOptionalInt(this.iterations);
        if (this.distanceType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.distanceType);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.centroids != null) {
            builder.field(CENTROIDS_FIELD, this.centroids);
        }
        if (this.iterations != null) {
            builder.field(ITERATIONS_FIELD, this.iterations);
        }
        if (this.distanceType != null) {
            builder.field(DISTANCE_TYPE_FIELD, this.distanceType.name());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Generated
    public static KMeansParamsBuilder builder() {
        return new KMeansParamsBuilder();
    }

    @Generated
    public KMeansParamsBuilder toBuilder() {
        return new KMeansParamsBuilder().centroids(this.centroids).iterations(this.iterations).distanceType(this.distanceType);
    }

    @Generated
    public Integer getCentroids() {
        return this.centroids;
    }

    @Generated
    public Integer getIterations() {
        return this.iterations;
    }

    @Generated
    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    @Generated
    public void setCentroids(Integer centroids) {
        this.centroids = centroids;
    }

    @Generated
    public void setIterations(Integer iterations) {
        this.iterations = iterations;
    }

    @Generated
    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KMeansParams)) {
            return false;
        }
        KMeansParams other = (KMeansParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$centroids = this.getCentroids();
        Integer other$centroids = other.getCentroids();
        if (this$centroids == null ? other$centroids != null : !((Object)this$centroids).equals(other$centroids)) {
            return false;
        }
        Integer this$iterations = this.getIterations();
        Integer other$iterations = other.getIterations();
        if (this$iterations == null ? other$iterations != null : !((Object)this$iterations).equals(other$iterations)) {
            return false;
        }
        DistanceType this$distanceType = this.getDistanceType();
        DistanceType other$distanceType = other.getDistanceType();
        return !(this$distanceType == null ? other$distanceType != null : !((Object)((Object)this$distanceType)).equals((Object)other$distanceType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KMeansParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $centroids = this.getCentroids();
        result = result * 59 + ($centroids == null ? 43 : ((Object)$centroids).hashCode());
        Integer $iterations = this.getIterations();
        result = result * 59 + ($iterations == null ? 43 : ((Object)$iterations).hashCode());
        DistanceType $distanceType = this.getDistanceType();
        result = result * 59 + ($distanceType == null ? 43 : ((Object)((Object)$distanceType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KMeansParams(centroids=" + this.getCentroids() + ", iterations=" + this.getIterations() + ", distanceType=" + (Object)((Object)this.getDistanceType()) + ")";
    }

    @Generated
    public static class KMeansParamsBuilder {
        @Generated
        private Integer centroids;
        @Generated
        private Integer iterations;
        @Generated
        private DistanceType distanceType;

        @Generated
        KMeansParamsBuilder() {
        }

        @Generated
        public KMeansParamsBuilder centroids(Integer centroids) {
            this.centroids = centroids;
            return this;
        }

        @Generated
        public KMeansParamsBuilder iterations(Integer iterations) {
            this.iterations = iterations;
            return this;
        }

        @Generated
        public KMeansParamsBuilder distanceType(DistanceType distanceType) {
            this.distanceType = distanceType;
            return this;
        }

        @Generated
        public KMeansParams build() {
            return new KMeansParams(this.centroids, this.iterations, this.distanceType);
        }

        @Generated
        public String toString() {
            return "KMeansParams.KMeansParamsBuilder(centroids=" + this.centroids + ", iterations=" + this.iterations + ", distanceType=" + (Object)((Object)this.distanceType) + ")";
        }
    }

    public static enum DistanceType {
        EUCLIDEAN,
        COSINE,
        L1;


        public static DistanceType from(String value) {
            try {
                return DistanceType.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong distance type");
            }
        }
    }
}

