/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.client;

import org.opensearch.action.ActionFuture;
import org.opensearch.action.ActionListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.ml.common.parameter.MLInput;
import org.opensearch.ml.common.parameter.MLModel;
import org.opensearch.ml.common.parameter.MLOutput;
import org.opensearch.ml.common.parameter.MLTask;

public interface MachineLearningClient {
    default public ActionFuture<MLOutput> predict(String modelId, MLInput mlInput) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.predict(modelId, mlInput, (ActionListener<MLOutput>)actionFuture);
        return actionFuture;
    }

    public void predict(String var1, MLInput var2, ActionListener<MLOutput> var3);

    default public ActionFuture<MLOutput> trainAndPredict(MLInput mlInput) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.trainAndPredict(mlInput, (ActionListener<MLOutput>)actionFuture);
        return actionFuture;
    }

    public void trainAndPredict(MLInput var1, ActionListener<MLOutput> var2);

    default public ActionFuture<MLOutput> train(MLInput mlInput, boolean asyncTask) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.train(mlInput, asyncTask, (ActionListener<MLOutput>)actionFuture);
        return actionFuture;
    }

    public void train(MLInput var1, boolean var2, ActionListener<MLOutput> var3);

    default public ActionFuture<MLModel> getModel(String modelId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.getModel(modelId, (ActionListener<MLModel>)actionFuture);
        return actionFuture;
    }

    public void getModel(String var1, ActionListener<MLModel> var2);

    default public ActionFuture<MLTask> getTask(String taskId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.getTask(taskId, (ActionListener<MLTask>)actionFuture);
        return actionFuture;
    }

    public void getTask(String var1, ActionListener<MLTask> var2);

    default public ActionFuture<DeleteResponse> deleteModel(String modelId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.deleteModel(modelId, (ActionListener<DeleteResponse>)actionFuture);
        return actionFuture;
    }

    public void deleteModel(String var1, ActionListener<DeleteResponse> var2);

    default public ActionFuture<DeleteResponse> deleteTask(String taskId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.deleteModel(taskId, (ActionListener<DeleteResponse>)actionFuture);
        return actionFuture;
    }

    public void deleteTask(String var1, ActionListener<DeleteResponse> var2);

    default public ActionFuture<SearchResponse> searchModel(SearchRequest searchRequest) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.searchModel(searchRequest, (ActionListener<SearchResponse>)actionFuture);
        return actionFuture;
    }

    public void searchModel(SearchRequest var1, ActionListener<SearchResponse> var2);

    default public ActionFuture<SearchResponse> searchTask(SearchRequest searchRequest) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.searchTask(searchRequest, (ActionListener<SearchResponse>)actionFuture);
        return actionFuture;
    }

    public void searchTask(SearchRequest var1, ActionListener<SearchResponse> var2);
}

