/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.Feature;
import org.opensearch.commons.notifications.model.SeverityType;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00c6\u0003JA\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010&2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006/"}, d2={"Lorg/opensearch/commons/notifications/model/EventSource;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "title", "", "referenceId", "feature", "Lorg/opensearch/commons/notifications/model/Feature;", "severity", "Lorg/opensearch/commons/notifications/model/SeverityType;", "tags", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/commons/notifications/model/Feature;Lorg/opensearch/commons/notifications/model/SeverityType;Ljava/util/List;)V", "getFeature", "()Lorg/opensearch/commons/notifications/model/Feature;", "getReferenceId", "()Ljava/lang/String;", "getSeverity", "()Lorg/opensearch/commons/notifications/model/SeverityType;", "getTags", "()Ljava/util/List;", "getTitle", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class EventSource
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String referenceId;
    @NotNull
    private final Feature feature;
    @NotNull
    private final SeverityType severity;
    @NotNull
    private final List<String> tags;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(EventSource.class);
    @NotNull
    private static final Writeable.Reader<EventSource> reader = EventSource::reader$lambda-1;

    public EventSource(@NotNull String title, @NotNull String referenceId, @NotNull Feature feature, @NotNull SeverityType severity, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.title = title;
        this.referenceId = referenceId;
        this.feature = feature;
        this.severity = severity;
        this.tags = tags;
        if (!(!Strings.isNullOrEmpty((String)this.title))) {
            boolean bl = false;
            String string = "name is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ EventSource(String string, String string2, Feature feature, SeverityType severityType, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            severityType = SeverityType.INFO;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, feature, severityType, list);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getReferenceId() {
        return this.referenceId;
    }

    @NotNull
    public final Feature getFeature() {
        return this.feature;
    }

    @NotNull
    public final SeverityType getSeverity() {
        return this.severity;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("title", this.title).field("reference_id", this.referenceId).field("feature", this.feature.getTag()).field("severity", this.severity.getTag()).field("tags", (Iterable)this.tags).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    public EventSource(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object object = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readString()");
        String string = object;
        object = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readString()");
        String string2 = object;
        object = input.readEnum(Feature.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readEnum(Feature::class.java)");
        Feature feature = (Feature)((Object)object);
        object = input.readEnum(SeverityType.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readEnum(SeverityType::class.java)");
        SeverityType severityType = (SeverityType)((Object)object);
        object = input.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readStringList()");
        this(string, string2, feature, severityType, (List<String>)object);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.title);
        output.writeString(this.referenceId);
        output.writeEnum((Enum)this.feature);
        output.writeEnum((Enum)this.severity);
        output.writeStringCollection((Collection)this.tags);
    }

    @NotNull
    public final String component1() {
        return this.title;
    }

    @NotNull
    public final String component2() {
        return this.referenceId;
    }

    @NotNull
    public final Feature component3() {
        return this.feature;
    }

    @NotNull
    public final SeverityType component4() {
        return this.severity;
    }

    @NotNull
    public final List<String> component5() {
        return this.tags;
    }

    @NotNull
    public final EventSource copy(@NotNull String title, @NotNull String referenceId, @NotNull Feature feature, @NotNull SeverityType severity, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new EventSource(title, referenceId, feature, severity, tags);
    }

    public static /* synthetic */ EventSource copy$default(EventSource eventSource, String string, String string2, Feature feature, SeverityType severityType, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = eventSource.title;
        }
        if ((n & 2) != 0) {
            string2 = eventSource.referenceId;
        }
        if ((n & 4) != 0) {
            feature = eventSource.feature;
        }
        if ((n & 8) != 0) {
            severityType = eventSource.severity;
        }
        if ((n & 0x10) != 0) {
            list = eventSource.tags;
        }
        return eventSource.copy(string, string2, feature, severityType, list);
    }

    @NotNull
    public String toString() {
        return "EventSource(title=" + this.title + ", referenceId=" + this.referenceId + ", feature=" + (Object)((Object)this.feature) + ", severity=" + (Object)((Object)this.severity) + ", tags=" + this.tags + ')';
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = result * 31 + this.referenceId.hashCode();
        result = result * 31 + this.feature.hashCode();
        result = result * 31 + this.severity.hashCode();
        result = result * 31 + ((Object)this.tags).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EventSource)) {
            return false;
        }
        EventSource eventSource = (EventSource)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)eventSource.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.referenceId, (Object)eventSource.referenceId)) {
            return false;
        }
        if (this.feature != eventSource.feature) {
            return false;
        }
        if (this.severity != eventSource.severity) {
            return false;
        }
        return Intrinsics.areEqual(this.tags, eventSource.tags);
    }

    private static final EventSource reader$lambda-1(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new EventSource(it);
    }

    @JvmStatic
    @NotNull
    public static final EventSource parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/EventSource$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/EventSource;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<EventSource> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final EventSource parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String title = null;
            String referenceId = null;
            Feature feature = null;
            SeverityType severity = SeverityType.INFO;
            List<String> tags = CollectionsKt.emptyList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block23: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block23;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1478300413: {
                            if (string.equals("severity")) {
                                n = 1;
                            }
                            break;
                        }
                        case -502535537: {
                            if (string.equals("reference_id")) {
                                n = 2;
                            }
                            break;
                        }
                        case -979207434: {
                            if (string.equals("feature")) {
                                n = 3;
                            }
                            break;
                        }
                        case 110371416: {
                            if (string.equals("title")) {
                                n = 4;
                            }
                            break;
                        }
                        case 3552281: {
                            if (string.equals("tags")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 4: {
                            title = parser.text();
                            continue block14;
                        }
                        case 2: {
                            referenceId = parser.text();
                            continue block14;
                        }
                        case 3: {
                            String string2 = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                            feature = Feature.Companion.fromTagOrDefault(string2);
                            continue block14;
                        }
                        case 1: {
                            String string2 = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                            severity = SeverityType.Companion.fromTagOrDefault(string2);
                            continue block14;
                        }
                        case 5: {
                            tags = XContentHelpersKt.stringList(parser);
                            continue block14;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing EventSource");
            }
            if (title == null) {
                throw new IllegalArgumentException("title field absent");
            }
            if (referenceId == null) {
                throw new IllegalArgumentException("reference_id field absent");
            }
            if (feature == null) {
                throw new IllegalArgumentException("feature field absent");
            }
            return new EventSource(title, referenceId, feature, severity, tags);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

