/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.parameter;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.ml.common.annotation.MLAlgoOutput;
import org.opensearch.ml.common.parameter.MLOutput;
import org.opensearch.ml.common.parameter.MLOutputType;

@MLAlgoOutput(value=MLOutputType.TRAINING)
public class MLTrainingOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.TRAINING;
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String TASK_ID_FIELD = "task_id";
    public static final String STATUS_FIELD = "status";
    private String modelId;
    private String taskId;
    private String status;

    public MLTrainingOutput(String modelId, String taskId, String status) {
        super(OUTPUT_TYPE);
        this.modelId = modelId;
        this.taskId = taskId;
        this.status = status;
    }

    public MLTrainingOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        this.modelId = in.readOptionalString();
        this.taskId = in.readOptionalString();
        this.status = in.readOptionalString();
    }

    @Override
    public MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.modelId);
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.status);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        builder.field(STATUS_FIELD, this.status);
        builder.endObject();
        return builder;
    }

    @Generated
    public static MLTrainingOutputBuilder builder() {
        return new MLTrainingOutputBuilder();
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public static class MLTrainingOutputBuilder {
        @Generated
        private String modelId;
        @Generated
        private String taskId;
        @Generated
        private String status;

        @Generated
        MLTrainingOutputBuilder() {
        }

        @Generated
        public MLTrainingOutputBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLTrainingOutputBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MLTrainingOutputBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public MLTrainingOutput build() {
            return new MLTrainingOutput(this.modelId, this.taskId, this.status);
        }

        @Generated
        public String toString() {
            return "MLTrainingOutput.MLTrainingOutputBuilder(modelId=" + this.modelId + ", taskId=" + this.taskId + ", status=" + this.status + ")";
        }
    }
}

