/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.MethodType;
import org.opensearch.commons.notifications.model.XParser;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.ValidationHelpersKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/opensearch/commons/notifications/model/SmtpAccount;", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "host", "", "port", "", "method", "Lorg/opensearch/commons/notifications/model/MethodType;", "fromAddress", "(Ljava/lang/String;ILorg/opensearch/commons/notifications/model/MethodType;Ljava/lang/String;)V", "getFromAddress", "()Ljava/lang/String;", "getHost", "getMethod", "()Lorg/opensearch/commons/notifications/model/MethodType;", "getPort", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class SmtpAccount
implements BaseConfigData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final MethodType method;
    @NotNull
    private final String fromAddress;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(SmtpAccount.class);
    @NotNull
    private static final Writeable.Reader<SmtpAccount> reader = SmtpAccount::reader$lambda-2;
    @NotNull
    private static final XParser<SmtpAccount> xParser = SmtpAccount::xParser$lambda-3;

    public SmtpAccount(@NotNull String host, int port, @NotNull MethodType method, @NotNull String fromAddress) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)fromAddress, (String)"fromAddress");
        this.host = host;
        this.port = port;
        this.method = method;
        this.fromAddress = fromAddress;
        if (!(!Strings.isNullOrEmpty((String)this.host))) {
            boolean $i$a$-require-SmtpAccount$32 = false;
            String $i$a$-require-SmtpAccount$32 = "host is null or empty";
            throw new IllegalArgumentException($i$a$-require-SmtpAccount$32.toString());
        }
        if (!(this.port > 0)) {
            boolean bl = false;
            String string = "port should be positive value";
            throw new IllegalArgumentException(string.toString());
        }
        ValidationHelpersKt.validateEmail(this.fromAddress);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final MethodType getMethod() {
        return this.method;
    }

    @NotNull
    public final String getFromAddress() {
        return this.fromAddress;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        XContentBuilder xContentBuilder2 = xContentBuilder.startObject().field("host", this.host).field("port", this.port).field("method", this.method.getTag()).field("from_address", this.fromAddress).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder!!.startObject()\n\u2026\n            .endObject()");
        return xContentBuilder2;
    }

    public SmtpAccount(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object object = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readString()");
        String string = object;
        int n = input.readInt();
        object = input.readEnum(MethodType.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readEnum(MethodType::class.java)");
        MethodType methodType = (MethodType)((Object)object);
        object = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readString()");
        this(string, n, methodType, (String)object);
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.host);
        out.writeInt(this.port);
        out.writeEnum((Enum)this.method);
        out.writeString(this.fromAddress);
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    public final int component2() {
        return this.port;
    }

    @NotNull
    public final MethodType component3() {
        return this.method;
    }

    @NotNull
    public final String component4() {
        return this.fromAddress;
    }

    @NotNull
    public final SmtpAccount copy(@NotNull String host, int port, @NotNull MethodType method, @NotNull String fromAddress) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)fromAddress, (String)"fromAddress");
        return new SmtpAccount(host, port, method, fromAddress);
    }

    public static /* synthetic */ SmtpAccount copy$default(SmtpAccount smtpAccount, String string, int n, MethodType methodType, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = smtpAccount.host;
        }
        if ((n2 & 2) != 0) {
            n = smtpAccount.port;
        }
        if ((n2 & 4) != 0) {
            methodType = smtpAccount.method;
        }
        if ((n2 & 8) != 0) {
            string2 = smtpAccount.fromAddress;
        }
        return smtpAccount.copy(string, n, methodType, string2);
    }

    @NotNull
    public String toString() {
        return "SmtpAccount(host=" + this.host + ", port=" + this.port + ", method=" + (Object)((Object)this.method) + ", fromAddress=" + this.fromAddress + ')';
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = result * 31 + Integer.hashCode(this.port);
        result = result * 31 + this.method.hashCode();
        result = result * 31 + this.fromAddress.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SmtpAccount)) {
            return false;
        }
        SmtpAccount smtpAccount = (SmtpAccount)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)smtpAccount.host)) {
            return false;
        }
        if (this.port != smtpAccount.port) {
            return false;
        }
        if (this.method != smtpAccount.method) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fromAddress, (Object)smtpAccount.fromAddress);
    }

    private static final SmtpAccount reader$lambda-2(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new SmtpAccount(it);
    }

    private static final SmtpAccount xParser$lambda-3(XContentParser it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.parse(it);
    }

    @JvmStatic
    @NotNull
    public static final SmtpAccount parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/commons/notifications/model/SmtpAccount$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/SmtpAccount;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "xParser", "Lorg/opensearch/commons/notifications/model/XParser;", "getXParser", "()Lorg/opensearch/commons/notifications/model/XParser;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<SmtpAccount> getReader() {
            return reader;
        }

        @NotNull
        public final XParser<SmtpAccount> getXParser() {
            return xParser;
        }

        @JvmStatic
        @NotNull
        public final SmtpAccount parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String host = null;
            Integer port = null;
            MethodType method = null;
            String fromAddress = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block21: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block21;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1077554975: {
                            if (string.equals("method")) {
                                n = 1;
                            }
                            break;
                        }
                        case 3446913: {
                            if (string.equals("port")) {
                                n = 2;
                            }
                            break;
                        }
                        case 3208616: {
                            if (string.equals("host")) {
                                n = 3;
                            }
                            break;
                        }
                        case -1279127457: {
                            if (string.equals("from_address")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            host = parser.text();
                            continue block12;
                        }
                        case 2: {
                            port = parser.intValue();
                            continue block12;
                        }
                        case 1: {
                            String string2 = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                            method = MethodType.Companion.fromTagOrDefault(string2);
                            continue block12;
                        }
                        case 4: {
                            fromAddress = parser.text();
                            continue block12;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing SmtpAccount");
            }
            if (host == null) {
                throw new IllegalArgumentException("host field absent");
            }
            Integer n = port;
            if (n == null) {
                throw new IllegalArgumentException("port field absent");
            }
            n.intValue();
            if (method == null) {
                throw new IllegalArgumentException("method field absent");
            }
            if (fromAddress == null) {
                throw new IllegalArgumentException("from_address field absent");
            }
            return new SmtpAccount(host, port, method, fromAddress);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

