/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.parameter;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.annotation.MLAlgoParameter;
import org.opensearch.ml.common.parameter.FunctionName;
import org.opensearch.ml.common.parameter.MLAlgoParams;

@MLAlgoParameter(algorithms={FunctionName.FIT_RCF})
public class FitRCFParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.FIT_RCF.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> FitRCFParams.parse(it));
    public static final String NUMBER_OF_TREES = "number_of_trees";
    public static final String SHINGLE_SIZE = "shingle_size";
    public static final String SAMPLE_SIZE = "sample_size";
    public static final String OUTPUT_AFTER = "output_after";
    public static final String TIME_DECAY = "time_decay";
    public static final String ANOMALY_RATE = "anomaly_rate";
    public static final String TIME_FIELD = "time_field";
    public static final String DATE_FORMAT = "date_format";
    public static final String TIME_ZONE = "time_zone";
    private Integer numberOfTrees;
    private Integer shingleSize;
    private Integer sampleSize;
    private Integer outputAfter;
    private Double timeDecay;
    private Double anomalyRate;
    private String timeField;
    private String dateFormat;
    private String timeZone;

    public FitRCFParams(Integer numberOfTrees, Integer shingleSize, Integer sampleSize, Integer outputAfter, Double timeDecay, Double anomalyRate, String timeField, String dateFormat, String timeZone) {
        this.numberOfTrees = numberOfTrees;
        this.shingleSize = shingleSize;
        this.sampleSize = sampleSize;
        this.outputAfter = outputAfter;
        this.timeDecay = timeDecay;
        this.anomalyRate = anomalyRate;
        this.timeField = timeField;
        this.dateFormat = dateFormat;
        this.timeZone = timeZone;
    }

    public FitRCFParams(StreamInput in) throws IOException {
        this.numberOfTrees = in.readOptionalInt();
        this.shingleSize = in.readOptionalInt();
        this.sampleSize = in.readOptionalInt();
        this.outputAfter = in.readOptionalInt();
        this.timeDecay = in.readOptionalDouble();
        this.anomalyRate = in.readOptionalDouble();
        this.timeField = in.readOptionalString();
        this.dateFormat = in.readOptionalString();
        this.timeZone = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.numberOfTrees);
        out.writeOptionalInt(this.shingleSize);
        out.writeOptionalInt(this.sampleSize);
        out.writeOptionalInt(this.outputAfter);
        out.writeOptionalDouble(this.timeDecay);
        out.writeOptionalDouble(this.anomalyRate);
        out.writeOptionalString(this.timeField);
        out.writeOptionalString(this.dateFormat);
        out.writeOptionalString(this.timeZone);
    }

    public static FitRCFParams parse(XContentParser parser) throws IOException {
        Integer numberOfTrees = null;
        Integer shingleSize = null;
        Integer sampleSize = null;
        Integer outputAfter = null;
        Double timeDecay = null;
        Double anomalyRate = null;
        String timeField = null;
        String dateFormat = null;
        String timeZone = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block22: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "number_of_trees": {
                    numberOfTrees = parser.intValue(false);
                    continue block22;
                }
                case "shingle_size": {
                    shingleSize = parser.intValue(false);
                    continue block22;
                }
                case "sample_size": {
                    sampleSize = parser.intValue(false);
                    continue block22;
                }
                case "output_after": {
                    outputAfter = parser.intValue(false);
                    continue block22;
                }
                case "time_decay": {
                    timeDecay = parser.doubleValue(false);
                    continue block22;
                }
                case "anomaly_rate": {
                    anomalyRate = parser.doubleValue(false);
                    continue block22;
                }
                case "time_field": {
                    timeField = parser.text();
                    continue block22;
                }
                case "date_format": {
                    dateFormat = parser.text();
                    continue block22;
                }
                case "time_zone": {
                    timeZone = parser.text();
                    continue block22;
                }
            }
            parser.skipChildren();
        }
        return new FitRCFParams(numberOfTrees, shingleSize, sampleSize, outputAfter, timeDecay, anomalyRate, timeField, dateFormat, timeZone);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfTrees != null) {
            builder.field(NUMBER_OF_TREES, this.numberOfTrees);
        }
        if (this.shingleSize != null) {
            builder.field(SHINGLE_SIZE, this.shingleSize);
        }
        if (this.sampleSize != null) {
            builder.field(SAMPLE_SIZE, this.sampleSize);
        }
        if (this.outputAfter != null) {
            builder.field(OUTPUT_AFTER, this.outputAfter);
        }
        if (this.timeDecay != null) {
            builder.field(TIME_DECAY, this.timeDecay);
        }
        if (this.anomalyRate != null) {
            builder.field(ANOMALY_RATE, this.anomalyRate);
        }
        if (this.timeField != null) {
            builder.field(TIME_FIELD, this.timeField);
        }
        if (this.dateFormat != null) {
            builder.field(DATE_FORMAT, this.dateFormat);
        }
        if (this.timeZone != null) {
            builder.field(TIME_ZONE, this.timeZone);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static FitRCFParamsBuilder builder() {
        return new FitRCFParamsBuilder();
    }

    @Generated
    public Integer getNumberOfTrees() {
        return this.numberOfTrees;
    }

    @Generated
    public Integer getShingleSize() {
        return this.shingleSize;
    }

    @Generated
    public Integer getSampleSize() {
        return this.sampleSize;
    }

    @Generated
    public Integer getOutputAfter() {
        return this.outputAfter;
    }

    @Generated
    public Double getTimeDecay() {
        return this.timeDecay;
    }

    @Generated
    public Double getAnomalyRate() {
        return this.anomalyRate;
    }

    @Generated
    public String getTimeField() {
        return this.timeField;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public void setNumberOfTrees(Integer numberOfTrees) {
        this.numberOfTrees = numberOfTrees;
    }

    @Generated
    public void setShingleSize(Integer shingleSize) {
        this.shingleSize = shingleSize;
    }

    @Generated
    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Generated
    public void setOutputAfter(Integer outputAfter) {
        this.outputAfter = outputAfter;
    }

    @Generated
    public void setTimeDecay(Double timeDecay) {
        this.timeDecay = timeDecay;
    }

    @Generated
    public void setAnomalyRate(Double anomalyRate) {
        this.anomalyRate = anomalyRate;
    }

    @Generated
    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    @Generated
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FitRCFParams)) {
            return false;
        }
        FitRCFParams other = (FitRCFParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$numberOfTrees = this.getNumberOfTrees();
        Integer other$numberOfTrees = other.getNumberOfTrees();
        if (this$numberOfTrees == null ? other$numberOfTrees != null : !((Object)this$numberOfTrees).equals(other$numberOfTrees)) {
            return false;
        }
        Integer this$shingleSize = this.getShingleSize();
        Integer other$shingleSize = other.getShingleSize();
        if (this$shingleSize == null ? other$shingleSize != null : !((Object)this$shingleSize).equals(other$shingleSize)) {
            return false;
        }
        Integer this$sampleSize = this.getSampleSize();
        Integer other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !((Object)this$sampleSize).equals(other$sampleSize)) {
            return false;
        }
        Integer this$outputAfter = this.getOutputAfter();
        Integer other$outputAfter = other.getOutputAfter();
        if (this$outputAfter == null ? other$outputAfter != null : !((Object)this$outputAfter).equals(other$outputAfter)) {
            return false;
        }
        Double this$timeDecay = this.getTimeDecay();
        Double other$timeDecay = other.getTimeDecay();
        if (this$timeDecay == null ? other$timeDecay != null : !((Object)this$timeDecay).equals(other$timeDecay)) {
            return false;
        }
        Double this$anomalyRate = this.getAnomalyRate();
        Double other$anomalyRate = other.getAnomalyRate();
        if (this$anomalyRate == null ? other$anomalyRate != null : !((Object)this$anomalyRate).equals(other$anomalyRate)) {
            return false;
        }
        String this$timeField = this.getTimeField();
        String other$timeField = other.getTimeField();
        if (this$timeField == null ? other$timeField != null : !this$timeField.equals(other$timeField)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FitRCFParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $numberOfTrees = this.getNumberOfTrees();
        result = result * 59 + ($numberOfTrees == null ? 43 : ((Object)$numberOfTrees).hashCode());
        Integer $shingleSize = this.getShingleSize();
        result = result * 59 + ($shingleSize == null ? 43 : ((Object)$shingleSize).hashCode());
        Integer $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : ((Object)$sampleSize).hashCode());
        Integer $outputAfter = this.getOutputAfter();
        result = result * 59 + ($outputAfter == null ? 43 : ((Object)$outputAfter).hashCode());
        Double $timeDecay = this.getTimeDecay();
        result = result * 59 + ($timeDecay == null ? 43 : ((Object)$timeDecay).hashCode());
        Double $anomalyRate = this.getAnomalyRate();
        result = result * 59 + ($anomalyRate == null ? 43 : ((Object)$anomalyRate).hashCode());
        String $timeField = this.getTimeField();
        result = result * 59 + ($timeField == null ? 43 : $timeField.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FitRCFParams(numberOfTrees=" + this.getNumberOfTrees() + ", shingleSize=" + this.getShingleSize() + ", sampleSize=" + this.getSampleSize() + ", outputAfter=" + this.getOutputAfter() + ", timeDecay=" + this.getTimeDecay() + ", anomalyRate=" + this.getAnomalyRate() + ", timeField=" + this.getTimeField() + ", dateFormat=" + this.getDateFormat() + ", timeZone=" + this.getTimeZone() + ")";
    }

    @Generated
    public static class FitRCFParamsBuilder {
        @Generated
        private Integer numberOfTrees;
        @Generated
        private Integer shingleSize;
        @Generated
        private Integer sampleSize;
        @Generated
        private Integer outputAfter;
        @Generated
        private Double timeDecay;
        @Generated
        private Double anomalyRate;
        @Generated
        private String timeField;
        @Generated
        private String dateFormat;
        @Generated
        private String timeZone;

        @Generated
        FitRCFParamsBuilder() {
        }

        @Generated
        public FitRCFParamsBuilder numberOfTrees(Integer numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder shingleSize(Integer shingleSize) {
            this.shingleSize = shingleSize;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder outputAfter(Integer outputAfter) {
            this.outputAfter = outputAfter;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder timeDecay(Double timeDecay) {
            this.timeDecay = timeDecay;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder anomalyRate(Double anomalyRate) {
            this.anomalyRate = anomalyRate;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder timeField(String timeField) {
            this.timeField = timeField;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        @Generated
        public FitRCFParamsBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Generated
        public FitRCFParams build() {
            return new FitRCFParams(this.numberOfTrees, this.shingleSize, this.sampleSize, this.outputAfter, this.timeDecay, this.anomalyRate, this.timeField, this.dateFormat, this.timeZone);
        }

        @Generated
        public String toString() {
            return "FitRCFParams.FitRCFParamsBuilder(numberOfTrees=" + this.numberOfTrees + ", shingleSize=" + this.shingleSize + ", sampleSize=" + this.sampleSize + ", outputAfter=" + this.outputAfter + ", timeDecay=" + this.timeDecay + ", anomalyRate=" + this.anomalyRate + ", timeField=" + this.timeField + ", dateFormat=" + this.dateFormat + ", timeZone=" + this.timeZone + ")";
        }
    }
}

