/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.EnumSet;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Feature;
import org.opensearch.commons.notifications.model.config.ConfigDataProperties;
import org.opensearch.commons.utils.EnumParser;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010!\u001a\u00020\u0010H\u00c6\u0003JM\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010*2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u00063"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfig;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "name", "", "description", "configType", "Lorg/opensearch/commons/notifications/model/ConfigType;", "features", "Ljava/util/EnumSet;", "Lorg/opensearch/commons/notifications/model/Feature;", "configData", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "isEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/commons/notifications/model/ConfigType;Ljava/util/EnumSet;Lorg/opensearch/commons/notifications/model/BaseConfigData;Z)V", "getConfigData", "()Lorg/opensearch/commons/notifications/model/BaseConfigData;", "getConfigType", "()Lorg/opensearch/commons/notifications/model/ConfigType;", "getDescription", "()Ljava/lang/String;", "getFeatures", "()Ljava/util/EnumSet;", "()Z", "getName", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class NotificationConfig
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final ConfigType configType;
    @NotNull
    private final EnumSet<Feature> features;
    @Nullable
    private final BaseConfigData configData;
    private final boolean isEnabled;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(NotificationConfig.class);
    @NotNull
    private static final Writeable.Reader<NotificationConfig> reader = NotificationConfig::reader$lambda-1;

    public NotificationConfig(@NotNull String name, @NotNull String description, @NotNull ConfigType configType, @NotNull EnumSet<Feature> features, @Nullable BaseConfigData configData, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.name = name;
        this.description = description;
        this.configType = configType;
        this.features = features;
        this.configData = configData;
        this.isEnabled = isEnabled;
        if (!(!Strings.isNullOrEmpty((String)this.name))) {
            boolean bl = false;
            String string = "name is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
        if (!ConfigDataProperties.INSTANCE.validateConfigData(this.configType, this.configData)) {
            throw new IllegalArgumentException("ConfigType: " + (Object)((Object)this.configType) + " and data doesn't match");
        }
        if (this.configType == ConfigType.NONE) {
            NotificationConfig.Companion.getLog().info("Some config field not recognized");
        }
    }

    public /* synthetic */ NotificationConfig(String string, String string2, ConfigType configType, EnumSet enumSet, BaseConfigData baseConfigData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(string, string2, configType, enumSet, baseConfigData, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final ConfigType getConfigType() {
        return this.configType;
    }

    @NotNull
    public final EnumSet<Feature> getFeatures() {
        return this.features;
    }

    @Nullable
    public final BaseConfigData getConfigData() {
        return this.configData;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("name", this.name).field("description", this.description).field("config_type", this.configType.getTag()).field("feature_list", (Iterable)this.features).field("is_enabled", this.isEnabled);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026S_ENABLED_TAG, isEnabled)");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull(xContentBuilder, this.configType.getTag(), this.configData).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder2;
    }

    public NotificationConfig(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        String string2 = input.readString();
        ConfigType configType = (ConfigType)input.readEnum(ConfigType.class);
        EnumSet enumSet = input.readEnumSet(Feature.class);
        boolean bl = input.readBoolean();
        Enum enum_ = input.readEnum(ConfigType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"input.readEnum(ConfigType::class.java)");
        BaseConfigData baseConfigData = (BaseConfigData)input.readOptionalWriteable(ConfigDataProperties.INSTANCE.getReaderForConfigType((ConfigType)enum_));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString()");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString()");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)configType), (String)"readEnum(ConfigType::class.java)");
        Intrinsics.checkNotNullExpressionValue((Object)enumSet, (String)"readEnumSet(Feature::class.java)");
        this(string, string2, configType, enumSet, baseConfigData, bl);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.name);
        output.writeString(this.description);
        output.writeEnum((Enum)this.configType);
        output.writeEnumSet(this.features);
        output.writeBoolean(this.isEnabled);
        output.writeEnum((Enum)this.configType);
        output.writeOptionalWriteable((Writeable)this.configData);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.description;
    }

    @NotNull
    public final ConfigType component3() {
        return this.configType;
    }

    @NotNull
    public final EnumSet<Feature> component4() {
        return this.features;
    }

    @Nullable
    public final BaseConfigData component5() {
        return this.configData;
    }

    public final boolean component6() {
        return this.isEnabled;
    }

    @NotNull
    public final NotificationConfig copy(@NotNull String name, @NotNull String description, @NotNull ConfigType configType, @NotNull EnumSet<Feature> features, @Nullable BaseConfigData configData, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        return new NotificationConfig(name, description, configType, features, configData, isEnabled);
    }

    public static /* synthetic */ NotificationConfig copy$default(NotificationConfig notificationConfig, String string, String string2, ConfigType configType, EnumSet enumSet, BaseConfigData baseConfigData, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = notificationConfig.name;
        }
        if ((n & 2) != 0) {
            string2 = notificationConfig.description;
        }
        if ((n & 4) != 0) {
            configType = notificationConfig.configType;
        }
        if ((n & 8) != 0) {
            enumSet = notificationConfig.features;
        }
        if ((n & 0x10) != 0) {
            baseConfigData = notificationConfig.configData;
        }
        if ((n & 0x20) != 0) {
            bl = notificationConfig.isEnabled;
        }
        return notificationConfig.copy(string, string2, configType, enumSet, baseConfigData, bl);
    }

    @NotNull
    public String toString() {
        return "NotificationConfig(name=" + this.name + ", description=" + this.description + ", configType=" + (Object)((Object)this.configType) + ", features=" + this.features + ", configData=" + this.configData + ", isEnabled=" + this.isEnabled + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + this.configType.hashCode();
        result = result * 31 + this.features.hashCode();
        result = result * 31 + (this.configData == null ? 0 : this.configData.hashCode());
        int n = this.isEnabled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig notificationConfig = (NotificationConfig)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)notificationConfig.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)notificationConfig.description)) {
            return false;
        }
        if (this.configType != notificationConfig.configType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.features, notificationConfig.features)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configData, (Object)notificationConfig.configData)) {
            return false;
        }
        return this.isEnabled == notificationConfig.isEnabled;
    }

    private static final NotificationConfig reader$lambda-1(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new NotificationConfig(it);
    }

    @JvmStatic
    @NotNull
    public static final NotificationConfig parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfig$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<NotificationConfig> getReader() {
            return reader;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final NotificationConfig parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String name = null;
            String description = "";
            ConfigType configType = null;
            EnumSet<Feature> features = null;
            boolean isEnabled = true;
            BaseConfigData configData = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block25: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block25;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -109284052: {
                            if (string.equals("is_enabled")) {
                                n = 1;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string.equals("name")) {
                                n = 2;
                            }
                            break;
                        }
                        case 1208965191: {
                            if (string.equals("feature_list")) {
                                n = 3;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals("description")) {
                                n = 4;
                            }
                            break;
                        }
                        case 17530391: {
                            if (string.equals("config_type")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            name = parser.text();
                            continue block14;
                        }
                        case 4: {
                            Object object = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parser.text()");
                            description = object;
                            continue block14;
                        }
                        case 5: {
                            Object object = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parser.text()");
                            configType = ConfigType.Companion.fromTagOrDefault((String)object);
                            continue block14;
                        }
                        case 3: {
                            void $this$enumSet$iv;
                            Object object = parser;
                            EnumParser<Feature> enumParser$iv = Feature.Companion.getEnumParser();
                            boolean $i$f$enumSet = false;
                            Object object2 = EnumSet.noneOf(Feature.class);
                            Intrinsics.checkNotNullExpressionValue(object2, (String)"noneOf(E::class.java)");
                            EnumSet<Feature> retSet$iv = object2;
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)$this$enumSet$iv.currentToken(), (XContentParser)$this$enumSet$iv);
                            while ($this$enumSet$iv.nextToken() != XContentParser.Token.END_ARRAY) {
                                object2 = $this$enumSet$iv.text();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"text()");
                                retSet$iv.add(enumParser$iv.fromTagOrDefault((String)object2));
                            }
                            features = retSet$iv;
                            continue block14;
                        }
                        case 1: {
                            isEnabled = parser.booleanValue();
                            continue block14;
                        }
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
                ConfigType configTypeForTag = ConfigType.Companion.fromTagOrDefault(fieldName);
                if (configTypeForTag != ConfigType.NONE && configData == null) {
                    configData = ConfigDataProperties.INSTANCE.createConfigData(configTypeForTag, parser);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing configuration");
            }
            if (name == null) {
                throw new IllegalArgumentException("name field absent");
            }
            if (configType == null) {
                throw new IllegalArgumentException("config_type field absent");
            }
            if (features == null) {
                throw new IllegalArgumentException("feature_list field absent");
            }
            return new NotificationConfig(name, description, configType, features, configData, isEnabled);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

