/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.types;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.opensearch.jdbc.types.TypeHelper;

public class TimeType
implements TypeHelper<Time> {
    public static final TimeType INSTANCE = new TimeType();

    private TimeType() {
    }

    @Override
    public Time fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        Calendar calendar;
        if (value == null) {
            return null;
        }
        Calendar calendar2 = calendar = conversionParams != null ? (Calendar)conversionParams.get("calendar") : null;
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof String) {
            return this.asTime((String)value, calendar);
        }
        if (value instanceof Number) {
            return this.asTime((Number)value);
        }
        throw this.objectConversionException(value);
    }

    public Time asTime(String value, Calendar calendar) {
        Time time;
        LocalDateTime localDateTime;
        try {
            TemporalAccessor temporal = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).parse(value);
            localDateTime = LocalDateTime.from(temporal);
            time = Time.valueOf(localDateTime.toLocalTime());
        }
        catch (DateTimeParseException exception) {
            time = Time.valueOf(value);
        }
        if (calendar == null) {
            return time;
        }
        localDateTime = time.toLocalTime().atDate(LocalDate.now());
        return this.localDateTimeToTime(localDateTime, calendar);
    }

    public Time asTime(Number value) {
        return new Time(value.longValue());
    }

    @Override
    public String getTypeName() {
        return "Time";
    }

    private Time localDateTimeToTime(LocalDateTime ldt, Calendar calendar) {
        calendar.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        calendar.set(14, ldt.getNano() / 1000000);
        return new Time(new Timestamp(calendar.getTimeInMillis()).getTime());
    }
}

