/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.protocol.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.opensearch.jdbc.protocol.ColumnDescriptor;
import org.opensearch.jdbc.protocol.QueryResponse;
import org.opensearch.jdbc.protocol.RequestError;

public class JsonQueryResponse
implements QueryResponse {
    private List<SchemaEntry> schema;
    private List<List<Object>> datarows;
    private int size;
    private int total;
    private int status;
    private String cursor;
    private JsonRequestError error;

    public List<SchemaEntry> getColumnDescriptors() {
        return this.schema;
    }

    @Override
    public List<List<Object>> getDatarows() {
        return this.datarows;
    }

    public void setSchema(List<SchemaEntry> schema) {
        this.schema = schema;
    }

    public void setDatarows(List<List<Object>> datarows) {
        this.datarows = datarows;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public void setError(JsonRequestError error) {
        this.error = error;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getCursor() {
        return this.cursor;
    }

    @Override
    public RequestError getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonQueryResponse)) {
            return false;
        }
        JsonQueryResponse response = (JsonQueryResponse)o;
        return this.getSize() == response.getSize() && this.getTotal() == response.getTotal() && this.getStatus() == response.getStatus() && this.getCursor() == response.getCursor() && Objects.equals(this.schema, response.schema) && Objects.equals(this.getDatarows(), response.getDatarows()) && Objects.equals(this.getError(), response.getError());
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.getDatarows(), this.getSize(), this.getTotal(), this.getStatus(), this.getCursor(), this.getError());
    }

    public String toString() {
        return "JsonQueryResponse{schema=" + this.schema + "cursor=" + this.cursor + ", datarows=" + this.datarows + ", size=" + this.size + ", total=" + this.total + ", status=" + this.status + ", error=" + this.error + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonRequestError
    implements RequestError {
        private String reason;
        private String details;
        private String type;

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setDetails(String details) {
            this.details = details;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        @Override
        public String getDetails() {
            return this.details;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JsonRequestError)) {
                return false;
            }
            JsonRequestError that = (JsonRequestError)o;
            return Objects.equals(this.getReason(), that.getReason()) && Objects.equals(this.getDetails(), that.getDetails()) && Objects.equals(this.getType(), that.getType());
        }

        public int hashCode() {
            return Objects.hash(this.getReason(), this.getDetails(), this.getType());
        }

        public String toString() {
            return "JsonRequestError{reason='" + this.reason + '\'' + ", details='" + Objects.hashCode(this.details) + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SchemaEntry
    implements ColumnDescriptor {
        private String name;
        private String type;
        private String label;

        @JsonCreator
        public SchemaEntry(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="alias") String label) {
            this.name = name;
            this.type = type;
            this.label = label;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SchemaEntry)) {
                return false;
            }
            SchemaEntry that = (SchemaEntry)o;
            return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getLabel(), that.getLabel());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getType(), this.getLabel());
        }

        public String toString() {
            return "SchemaEntry{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", label='" + this.label + '\'' + '}';
        }
    }
}

