/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.protocol.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.message.BasicHeader;
import org.opensearch.jdbc.protocol.ClusterMetadata;
import org.opensearch.jdbc.protocol.ConnectionResponse;
import org.opensearch.jdbc.protocol.Protocol;
import org.opensearch.jdbc.protocol.QueryRequest;
import org.opensearch.jdbc.protocol.QueryResponse;
import org.opensearch.jdbc.protocol.exceptions.ResponseException;
import org.opensearch.jdbc.protocol.http.JsonClusterMetadata;
import org.opensearch.jdbc.protocol.http.JsonConnectionResponse;
import org.opensearch.jdbc.protocol.http.JsonHttpResponseHandler;
import org.opensearch.jdbc.protocol.http.JsonQueryRequest;
import org.opensearch.jdbc.protocol.http.JsonQueryResponse;
import org.opensearch.jdbc.transport.http.HttpParam;
import org.opensearch.jdbc.transport.http.HttpTransport;

public class JsonHttpProtocol
implements Protocol {
    public static final String DEFAULT_SQL_CONTEXT_PATH = "/_plugins/_sql";
    private static final Header acceptJson = new BasicHeader("Accept", "application/json");
    private static final Header contentTypeJson = new BasicHeader("Content-Type", "application/json");
    private static final HttpParam requestJdbcFormatParam = new HttpParam("format", "jdbc");
    protected static final Header[] defaultJsonHeaders = new Header[]{acceptJson, contentTypeJson};
    private static final Header[] defaultEmptyRequestBodyJsonHeaders = new Header[]{acceptJson};
    protected static final HttpParam[] defaultJdbcParams = new HttpParam[]{requestJdbcFormatParam};
    protected static final ObjectMapper mapper = new ObjectMapper();
    private String sqlContextPath;
    private HttpTransport transport;
    private JsonHttpResponseHandler jsonHttpResponseHandler;

    public JsonHttpProtocol(HttpTransport transport) {
        this(transport, DEFAULT_SQL_CONTEXT_PATH);
    }

    public JsonHttpProtocol(HttpTransport transport, String sqlContextPath) {
        this.transport = transport;
        this.sqlContextPath = sqlContextPath;
        this.jsonHttpResponseHandler = new JsonHttpResponseHandler(this);
    }

    public String getSqlContextPath() {
        return this.sqlContextPath;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public JsonHttpResponseHandler getJsonHttpResponseHandler() {
        return this.jsonHttpResponseHandler;
    }

    @Override
    public ConnectionResponse connect(int timeout) throws ResponseException, IOException {
        try (CloseableHttpResponse response = this.transport.doGet("/", defaultEmptyRequestBodyJsonHeaders, null, timeout);){
            ConnectionResponse connectionResponse = this.jsonHttpResponseHandler.handleResponse((HttpResponse)response, this::processConnectionResponse);
            return connectionResponse;
        }
    }

    @Override
    public QueryResponse execute(QueryRequest request) throws ResponseException, IOException {
        try (CloseableHttpResponse response = this.transport.doPost(this.sqlContextPath, defaultJsonHeaders, defaultJdbcParams, this.buildQueryRequestBody(request), 0);){
            QueryResponse queryResponse = this.jsonHttpResponseHandler.handleResponse((HttpResponse)response, this::processQueryResponse);
            return queryResponse;
        }
    }

    private String buildQueryRequestBody(QueryRequest queryRequest) throws IOException {
        JsonQueryRequest jsonQueryRequest = new JsonQueryRequest(queryRequest);
        String requestBody = mapper.writeValueAsString((Object)jsonQueryRequest);
        return requestBody;
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    private JsonConnectionResponse processConnectionResponse(InputStream contentStream) throws IOException {
        ClusterMetadata clusterMetadata = (ClusterMetadata)mapper.readValue(contentStream, JsonClusterMetadata.class);
        return new JsonConnectionResponse(clusterMetadata);
    }

    private JsonQueryResponse processQueryResponse(InputStream contentStream) throws IOException {
        return (JsonQueryResponse)mapper.readValue(contentStream, JsonQueryResponse.class);
    }
}

