/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.opensearch.jdbc.logging.Layout;
import org.opensearch.jdbc.logging.LogLevel;
import org.opensearch.jdbc.logging.Logger;

public class PrintWriterLogger
implements Logger {
    protected final PrintWriter printWriter;
    private LogLevel logLevel;
    private Layout layout;

    public PrintWriterLogger(PrintWriter printWriter, LogLevel logLevel, Layout layout) {
        this.printWriter = printWriter;
        this.logLevel = logLevel == null ? LogLevel.OFF : logLevel;
        this.layout = layout;
    }

    @Override
    public void fatal(String message) {
        this.printMessage(LogLevel.FATAL, message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.printMessage(LogLevel.FATAL, message, t);
    }

    @Override
    public void error(String message) {
        this.printMessage(LogLevel.ERROR, message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.printMessage(LogLevel.ERROR, message, t);
    }

    @Override
    public void warn(String message) {
        this.printMessage(LogLevel.WARN, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.printMessage(LogLevel.WARN, message, t);
    }

    private void printMessage(LogLevel severity, String message) {
        this.printWriter.println(this.layout.formatLogEntry(severity, message));
    }

    private void printMessage(LogLevel severity, String message, Throwable t) {
        String logMessage = this.buildMessageWithThrowable(message, t);
        this.printWriter.println(this.layout.formatLogEntry(severity, logMessage));
    }

    private String buildMessageWithThrowable(String message, Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        pw.println(message);
        t.printStackTrace(pw);
        pw.close();
        return stringWriter.toString();
    }

    @Override
    public void info(String message) {
        this.printMessage(LogLevel.INFO, message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.printMessage(LogLevel.INFO, message, t);
    }

    @Override
    public void debug(String message) {
        this.printMessage(LogLevel.DEBUG, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.printMessage(LogLevel.DEBUG, message, t);
    }

    @Override
    public void trace(String message) {
        this.printMessage(LogLevel.TRACE, message);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.printMessage(LogLevel.TRACE, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logLevel.isGreaterThanOrEqualTo(LogLevel.DEBUG);
    }

    @Override
    public LogLevel getLevel() {
        return this.logLevel;
    }

    @Override
    public void close() {
        this.printWriter.flush();
    }
}

