/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.logging;

import java.io.IOException;
import java.io.PrintWriter;
import org.opensearch.jdbc.logging.FilePrintWriterLogger;
import org.opensearch.jdbc.logging.Layout;
import org.opensearch.jdbc.logging.LogLevel;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.PrintWriterLogger;
import org.opensearch.jdbc.logging.StandardLayout;

public class LoggerFactory {
    public static Logger getLogger(String filePath, LogLevel logLevel) {
        return LoggerFactory.getLogger(filePath, logLevel, (Layout)StandardLayout.INSTANCE);
    }

    public static Logger getLogger(String filePath, LogLevel logLevel, Layout layout) {
        try {
            return new FilePrintWriterLogger(filePath, logLevel, layout);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Logger getLogger(PrintWriter printWriter, LogLevel logLevel) {
        return LoggerFactory.getLogger(printWriter, logLevel, (Layout)StandardLayout.INSTANCE);
    }

    public static Logger getLogger(PrintWriter printWriter, LogLevel logLevel, Layout layout) {
        return new PrintWriterLogger(printWriter, logLevel, layout);
    }
}

