/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.config;

import org.opensearch.jdbc.config.ConnectionProperty;
import org.opensearch.jdbc.config.ConnectionPropertyException;

public class BoolConnectionProperty
extends ConnectionProperty<Boolean> {
    public BoolConnectionProperty(String key) {
        super(key);
    }

    @Override
    protected Boolean parseValue(Object value) throws ConnectionPropertyException {
        if (value == null) {
            return this.getDefault();
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConnectionPropertyException(this.getKey(), String.format("Property %s requires a valid boolean. Invalid property value of type %s. ", this.getKey(), value.getClass().getName()));
    }

    @Override
    public Boolean getDefault() {
        return false;
    }
}

