/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.opensearch.jdbc.ConnectionImpl;
import org.opensearch.jdbc.config.ConnectionConfig;
import org.opensearch.jdbc.internal.Version;
import org.opensearch.jdbc.internal.util.UrlParser;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggerFactory;
import org.opensearch.jdbc.logging.LoggingSource;
import org.opensearch.jdbc.logging.NoOpLogger;

public class Driver
implements java.sql.Driver,
LoggingSource {
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        ConnectionConfig connectionConfig = ConnectionConfig.builder().setUrl(url).setProperties(info).build();
        Logger log = Driver.initLog(connectionConfig);
        log.debug(() -> this.logMessage("connect (%s, %s)", url, info == null ? "null" : info.toString()));
        log.debug(() -> this.logMessage("Opening connection using config: %s", connectionConfig));
        return new ConnectionImpl(connectionConfig, log);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return UrlParser.isAcceptable(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return Version.Current.getMajor();
    }

    @Override
    public int getMinorVersion() {
        return Version.Current.getMinor();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static Logger initLog(ConnectionConfig connectionConfig) {
        if (connectionConfig.getLogWriter() != null) {
            return LoggerFactory.getLogger(connectionConfig.getLogWriter(), connectionConfig.getLogLevel());
        }
        if (connectionConfig.getLogOutput() != null) {
            return LoggerFactory.getLogger(connectionConfig.getLogOutput(), connectionConfig.getLogLevel());
        }
        if (DriverManager.getLogWriter() != null) {
            return LoggerFactory.getLogger(DriverManager.getLogWriter(), connectionConfig.getLogLevel());
        }
        return NoOpLogger.INSTANCE;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException E) {
            throw new RuntimeException("Can't register driver!");
        }
    }
}

