/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.opensearch.jdbc.DatabaseMetaDataImpl;
import org.opensearch.jdbc.OpenSearchConnection;
import org.opensearch.jdbc.PreparedStatementImpl;
import org.opensearch.jdbc.StatementImpl;
import org.opensearch.jdbc.StructImpl;
import org.opensearch.jdbc.config.ConnectionConfig;
import org.opensearch.jdbc.internal.JdbcWrapper;
import org.opensearch.jdbc.internal.Version;
import org.opensearch.jdbc.internal.util.JavaUtil;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggingSource;
import org.opensearch.jdbc.protocol.ClusterMetadata;
import org.opensearch.jdbc.protocol.ConnectionResponse;
import org.opensearch.jdbc.protocol.Protocol;
import org.opensearch.jdbc.protocol.ProtocolFactory;
import org.opensearch.jdbc.protocol.exceptions.ResponseException;
import org.opensearch.jdbc.protocol.http.HttpException;
import org.opensearch.jdbc.protocol.http.JsonHttpProtocolFactory;
import org.opensearch.jdbc.transport.Transport;
import org.opensearch.jdbc.transport.TransportException;
import org.opensearch.jdbc.transport.TransportFactory;
import org.opensearch.jdbc.transport.http.ApacheHttpTransportFactory;

public class ConnectionImpl
implements OpenSearchConnection,
JdbcWrapper,
LoggingSource {
    private String url;
    private String user;
    private Logger log;
    private int fetchSize;
    private boolean open = false;
    private Transport transport;
    private Protocol protocol;
    private ClusterMetadata clusterMetadata;
    private final String INCORRECT_CREDENTIALS_SQLSTATE = "28000";

    public ConnectionImpl(ConnectionConfig connectionConfig, Logger log) throws SQLException {
        this(connectionConfig, ApacheHttpTransportFactory.INSTANCE, JsonHttpProtocolFactory.INSTANCE, log);
    }

    public ConnectionImpl(ConnectionConfig connectionConfig, TransportFactory transportFactory, ProtocolFactory protocolFactory, Logger log) throws SQLException {
        this.log = log;
        this.url = connectionConfig.getUrl();
        this.user = connectionConfig.getUser();
        this.fetchSize = connectionConfig.getFetchSize();
        try {
            this.transport = transportFactory.getTransport(connectionConfig, log, this.getUserAgent());
        }
        catch (TransportException te) {
            this.logAndThrowSQLException(log, new SQLNonTransientException("Could not initialize transport for the connection: " + te.getMessage(), te));
        }
        this.protocol = protocolFactory.getProtocol(connectionConfig, this.transport);
        log.debug(() -> this.logMessage("Initialized Transport: %s, Protocol: %s", this.transport, this.protocol));
        try {
            ConnectionResponse connectionResponse = this.protocol.connect(connectionConfig.getLoginTimeout() * 1000);
            this.clusterMetadata = connectionResponse.getClusterMetadata();
            this.open = true;
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 401) {
                this.logAndThrowSQLException(log, new SQLException("Connection error " + ex.getMessage(), "28000", ex));
            } else {
                this.logAndThrowSQLException(log, new SQLException("Connection error " + ex.getMessage(), ex));
            }
        }
        catch (IOException | ResponseException ex) {
            this.logAndThrowSQLException(log, new SQLException("Connection error " + ex.getMessage(), ex));
        }
    }

    public String getUser() {
        return this.user;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.log.debug(() -> this.logEntry("createStatement()", new Object[0]));
        Statement st = this.createStatementX();
        this.log.debug(() -> this.logExit("createStatement", st));
        return st;
    }

    public Statement createStatementX() throws SQLException {
        return new StatementImpl(this, this.log);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.log.debug(() -> this.logEntry("prepareStatment (%s)", sql));
        this.checkOpen();
        PreparedStatement pst = this.prepareStatementX(sql);
        this.log.debug(() -> this.logExit("prepareStatement", pst));
        return pst;
    }

    private PreparedStatement prepareStatementX(String sql) throws SQLException {
        return new PreparedStatementImpl(this, sql, this.log);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall is not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (!autoCommit) {
            throw new SQLNonTransientException("autoCommit can not be disabled.");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        throw new SQLNonTransientException("autoCommit is enabled on the connection.");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        throw new SQLNonTransientException("autoCommit is enabled on the connection.");
    }

    @Override
    public void close() throws SQLException {
        this.log.debug(() -> this.logEntry("close ()", new Object[0]));
        this.closeX();
    }

    private void closeX() throws SQLException {
        this.open = false;
        try {
            this.transport.close();
        }
        catch (TransportException te) {
            this.log.error(() -> this.logMessage("Exception closing transport: " + te), (Throwable)te);
        }
        this.log.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosedX();
    }

    protected boolean isClosedX() throws SQLException {
        return !this.open;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.log.debug(() -> this.logEntry("getMetaData()", new Object[0]));
        DatabaseMetaDataImpl dbmd = new DatabaseMetaDataImpl(this, this.log);
        this.log.debug(() -> this.logExit("getMetaData", dbmd));
        return dbmd;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!readOnly) {
            throw new SQLNonTransientException("read-only mode can not be disabled.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getClusterName();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        if (level != 0) {
            throw new SQLNonTransientException("Only TRANSACTION_NONE is supported.");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.log.debug(() -> this.logEntry("createStatement (%d, %d)", resultSetType, resultSetConcurrency));
        this.checkOpen();
        this.validateResultSetCharacteristics(resultSetType, resultSetConcurrency, 1);
        Statement st = this.createStatementX();
        this.log.debug(() -> this.logExit("createStatement", st));
        return st;
    }

    private void validateResultSetCharacteristics(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateResultSetType(resultSetType);
        this.validateResulSetConcurrency(resultSetConcurrency);
        this.validateResultSetHoldability(resultSetHoldability);
    }

    private void validateResultSetType(int resultSetType) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLNonTransientException("Only ResultSets of TYPE_FORWARD_ONLY are supported.");
        }
    }

    private void validateResulSetConcurrency(int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLNonTransientException("Only ResultSets with concurrency CONCUR_READ_ONLY are supported.");
        }
    }

    private void validateResultSetHoldability(int holdability) throws SQLException {
        if (holdability != 1) {
            throw new SQLNonTransientException("Only HOLD_CURSORS_OVER_COMMIT holdability is supported.");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.log.debug(() -> this.logEntry("prepareStatement (%s, %d, %d)", sql, resultSetType, resultSetConcurrency));
        this.checkOpen();
        this.validateResultSetCharacteristics(resultSetType, resultSetConcurrency, 1);
        PreparedStatement pst = this.prepareStatementX(sql);
        this.log.debug(() -> this.logExit("prepareStatement", pst));
        return pst;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall is not supported");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTypeMap is not supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        this.validateResultSetHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions and savepoints are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions and savepoints are not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions and savepoints are not supported.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.debug(() -> this.logEntry("createStatement (%d, %d, %d)", resultSetType, resultSetConcurrency, resultSetHoldability));
        this.checkOpen();
        this.validateResultSetCharacteristics(resultSetType, resultSetConcurrency, resultSetHoldability);
        Statement st = this.createStatementX();
        this.log.debug(() -> this.logExit("createStatment", st));
        return st;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.debug(() -> this.logEntry("prepareStatement (%s, %d, %d, %d)", sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        this.checkOpen();
        this.validateResultSetCharacteristics(resultSetType, resultSetConcurrency, resultSetHoldability);
        PreparedStatement pst = this.prepareStatementX(sql);
        this.log.debug(() -> this.logExit("prepareStatement", pst));
        return pst;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.log.debug(() -> this.logEntry("prepareStatement (%s, %d)", sql, autoGeneratedKeys));
        this.checkOpen();
        if (autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        PreparedStatement pst = this.prepareStatementX(sql);
        this.log.debug(() -> this.logExit("prepareStatement", pst));
        return pst;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Clob is not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Blob is not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("NClob is not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXML is not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.log.debug(() -> this.logEntry("isValid (%d)", timeout));
        boolean isValid = true;
        this.log.debug(() -> this.logExit("isValid", isValid));
        return isValid;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException("Client info is not supported.", null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException("Client info is not supported.", null);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("Array is not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new StructImpl(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return "";
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.log.debug(() -> this.logEntry("abort (%s) ", executor));
        this.closeX();
        this.log.debug(() -> this.logExit("abort"));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public String getUrl() {
        return this.url;
    }

    private void checkOpen() throws SQLException {
        if (this.isClosedX()) {
            this.logAndThrowSQLException(this.log, new SQLException("Connection is closed."));
        }
    }

    @Override
    public String getClusterName() throws SQLException {
        this.checkOpen();
        return this.clusterMetadata.getClusterName();
    }

    @Override
    public String getClusterUUID() throws SQLException {
        this.checkOpen();
        return this.clusterMetadata.getClusterUUID();
    }

    public ClusterMetadata getClusterMetadata() throws SQLException {
        this.checkOpen();
        return this.clusterMetadata;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Logger getLog() {
        return this.log;
    }

    private String getUserAgent() {
        return String.format("openes-jdbc/%s (Java %s)", Version.Current.getFullVersion(), JavaUtil.getJavaVersion());
    }
}

