/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.types;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Map;

public interface TypeHelper<T> {
    default public SQLDataException stringConversionException(String value, Throwable cause) {
        if (cause != null) {
            return new SQLDataException(String.format("Can not parse %s as a %s", value, this.getTypeName()), cause);
        }
        return new SQLDataException(String.format("Can not parse %s as a %s", value, this.getTypeName()));
    }

    default public SQLDataException objectConversionException(Object value) {
        if (value == null) {
            return new SQLDataException(String.format("Can not return null value as a %s", this.getTypeName()));
        }
        return new SQLDataException(String.format("Can not return value of type %s as a %s", value.getClass().getName(), this.getTypeName()));
    }

    default public SQLDataException valueOutOfRangeException(Object value) {
        return new SQLDataException(String.format("Object value %s out of range for type %s", value, this.getTypeName()));
    }

    public T fromValue(Object var1, Map<String, Object> var2) throws SQLException;

    public String getTypeName();
}

