/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.types;

import java.sql.SQLException;
import java.util.Map;
import org.opensearch.jdbc.types.NumberType;

public class ShortType
extends NumberType<Short> {
    public static final ShortType INSTANCE = new ShortType();

    private ShortType() {
    }

    @Override
    public Short fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return (short)0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return this.asShort((String)value);
        }
        if (value instanceof Number) {
            return this.asShort((Number)value);
        }
        throw this.objectConversionException(value);
    }

    private Short asShort(String value) throws SQLException {
        try {
            return this.asShort(Double.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            throw this.stringConversionException(value, nfe);
        }
    }

    private Short asShort(Number value) throws SQLException {
        return (short)this.getDoubleValueWithinBounds(value, -32768.0, 32767.0);
    }

    @Override
    public String getTypeName() {
        return "Short";
    }

    public static void main(String[] args) {
        Short.valueOf("45.50");
        System.out.println(Math.round(100.45));
        System.out.println(Math.round(100.95f));
    }
}

