/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.transport.http;

import org.apache.commons.logging.Log;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggingSource;

public class JclLoggerAdapter
implements Log,
LoggingSource {
    private final Logger logger;
    private String source;

    public JclLoggerAdapter(Logger logger, String source) {
        this.logger = logger;
        this.source = source;
    }

    public void debug(Object message) {
        this.logger.debug(() -> this.logMessage(String.valueOf(message)));
    }

    public void debug(Object message, Throwable t) {
        this.logger.debug(String.valueOf(message), t);
    }

    public void error(Object message) {
        this.logger.error(String.valueOf(message));
    }

    public void error(Object message, Throwable t) {
        this.logger.error(String.valueOf(message), t);
    }

    public void fatal(Object message) {
        this.logger.fatal(String.valueOf(message));
    }

    public void fatal(Object message, Throwable t) {
        this.logger.fatal(String.valueOf(message), t);
    }

    public void info(Object message) {
        this.logger.info(String.valueOf(message));
    }

    public void info(Object message, Throwable t) {
        this.logger.info(String.valueOf(message), t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return false;
    }

    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void trace(Object message) {
        this.logger.trace(() -> this.logMessage(String.valueOf(message)));
    }

    public void trace(Object message, Throwable t) {
        this.logger.trace(String.valueOf(message), t);
    }

    public void warn(Object message) {
        this.logger.warn(String.valueOf(message));
    }

    public void warn(Object message, Throwable t) {
        this.logger.warn(String.valueOf(message), t);
    }

    @Override
    public String getSource() {
        return this.source;
    }
}

