/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.opensearch.jdbc.protocol.QueryRequest;
import org.opensearch.jdbc.protocol.QueryResponse;
import org.opensearch.jdbc.protocol.exceptions.ResponseException;
import org.opensearch.jdbc.protocol.http.JsonCursorQueryRequest;
import org.opensearch.jdbc.protocol.http.JsonHttpProtocol;
import org.opensearch.jdbc.protocol.http.JsonQueryResponse;
import org.opensearch.jdbc.transport.http.HttpTransport;

public class JsonCursorHttpProtocol
extends JsonHttpProtocol {
    public JsonCursorHttpProtocol(HttpTransport transport) {
        this(transport, "/_plugins/_sql");
    }

    public JsonCursorHttpProtocol(HttpTransport transport, String sqlContextPath) {
        super(transport, sqlContextPath);
    }

    @Override
    public QueryResponse execute(QueryRequest request) throws ResponseException, IOException {
        try (CloseableHttpResponse response = this.getTransport().doPost(this.getSqlContextPath(), defaultJsonHeaders, defaultJdbcParams, this.buildQueryRequestBody(request), 0);){
            QueryResponse queryResponse = this.getJsonHttpResponseHandler().handleResponse((HttpResponse)response, this::processQueryResponse);
            return queryResponse;
        }
    }

    private String buildQueryRequestBody(QueryRequest queryRequest) throws IOException {
        JsonCursorQueryRequest jsonQueryRequest = new JsonCursorQueryRequest(queryRequest);
        String requestBody = mapper.writeValueAsString((Object)jsonQueryRequest);
        return requestBody;
    }

    private JsonQueryResponse processQueryResponse(InputStream contentStream) throws IOException {
        return (JsonQueryResponse)mapper.readValue(contentStream, JsonQueryResponse.class);
    }
}

