/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.protocol;

import java.util.List;
import java.util.Objects;
import org.opensearch.jdbc.protocol.JdbcQueryParam;
import org.opensearch.jdbc.protocol.QueryRequest;

public class JdbcQueryRequest
implements QueryRequest {
    private String statement;
    private int fetchSize;
    List<JdbcQueryParam> parameters;

    public JdbcQueryRequest(String sql) {
        this.statement = sql;
    }

    public JdbcQueryRequest(String sql, int fetchSize) {
        this.statement = sql;
        this.fetchSize = fetchSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcQueryRequest)) {
            return false;
        }
        JdbcQueryRequest that = (JdbcQueryRequest)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.getParameters(), that.getParameters());
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.getParameters());
    }

    @Override
    public String getQuery() {
        return this.statement;
    }

    public List<JdbcQueryParam> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<JdbcQueryParam> parameters) {
        this.parameters = parameters;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    public String toString() {
        return "JdbcQueryRequest{statement='" + this.statement + '\'' + ", fetchSize='" + this.fetchSize + '\'' + ", parameters=" + this.parameters + '}';
    }
}

