/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.logging;

import java.sql.SQLException;
import org.opensearch.jdbc.logging.LogLevel;
import org.opensearch.jdbc.logging.Logger;

public interface LoggingSource {
    default public String logMessage(String format, Object ... args) {
        return this.logMessage(String.format(format, args));
    }

    default public String logMessage(String message) {
        return this.buildMessage(message);
    }

    default public String logEntry(String format, Object ... args) {
        return this.logMessage(String.format(format, args) + " called");
    }

    default public String logExit(String message, Object returnValue) {
        return this.logMessage(message + " returning: " + returnValue);
    }

    default public String logExit(String message) {
        return this.logMessage(message + " returned");
    }

    default public String getSource() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    default public void logAndThrowSQLException(Logger log, SQLException sqlex) throws SQLException {
        this.logAndThrowSQLException(log, LogLevel.ERROR, sqlex);
    }

    default public void logAndThrowSQLException(Logger log, LogLevel severity, SQLException sqlex) throws SQLException {
        this.logAndThrowSQLException(log, severity, sqlex.getMessage(), sqlex);
    }

    default public void logAndThrowSQLException(Logger log, LogLevel severity, String message, SQLException sqlex) throws SQLException {
        if (log.isLevelEnabled(severity)) {
            String logMessage = this.buildMessage(message);
            switch (severity) {
                case OFF: {
                    break;
                }
                case INFO: {
                    log.info(logMessage, (Throwable)sqlex);
                    break;
                }
                case WARN: {
                    log.warn(logMessage, (Throwable)sqlex);
                    break;
                }
                case DEBUG: {
                    log.debug(logMessage, (Throwable)sqlex);
                    break;
                }
                case ERROR: {
                    log.error(logMessage, (Throwable)sqlex);
                    break;
                }
                case FATAL: {
                    log.fatal(logMessage, (Throwable)sqlex);
                    break;
                }
                case TRACE: {
                    log.trace(logMessage, (Throwable)sqlex);
                    break;
                }
                case ALL: {
                    log.error(logMessage, (Throwable)sqlex);
                }
            }
        }
        throw sqlex;
    }

    default public String buildMessage(String message) {
        return "[" + this.getSource() + "] " + message;
    }
}

