/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.internal.results;

import org.opensearch.jdbc.protocol.ColumnDescriptor;
import org.opensearch.jdbc.types.OpenSearchType;

public class ColumnMetaData {
    private String name;
    private String label;
    private String tableSchemaName;
    private int precision = -1;
    private int scale = -1;
    private String tableName;
    private String catalogName;
    private String openSearchTypeName;
    private OpenSearchType openSearchType;

    public ColumnMetaData(ColumnDescriptor descriptor) {
        this.name = descriptor.getName();
        this.label = descriptor.getLabel() == null ? this.name : descriptor.getLabel();
        this.openSearchTypeName = descriptor.getType();
        this.openSearchType = OpenSearchType.fromTypeName(this.openSearchTypeName);
        this.precision = this.openSearchType.getPrecision();
        this.scale = 0;
        this.tableName = "";
        this.catalogName = "";
        this.tableSchemaName = "";
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTableSchemaName() {
        return this.tableSchemaName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public OpenSearchType getOpenSearchType() {
        return this.openSearchType;
    }

    public String getOpenSearchTypeName() {
        return this.openSearchTypeName;
    }
}

