/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.config;

import org.opensearch.jdbc.config.ConnectionProperty;
import org.opensearch.jdbc.config.ConnectionPropertyException;

public class StringConnectionProperty
extends ConnectionProperty<String> {
    public StringConnectionProperty(String key) {
        super(key);
    }

    @Override
    protected String parseValue(Object value) throws ConnectionPropertyException {
        if (value == null) {
            return this.getDefault();
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new ConnectionPropertyException(this.getKey(), String.format("Property %s requires a valid string. Invalid value of type: %s specified.", this.getKey(), value.getClass().getName()));
    }

    @Override
    public String getDefault() {
        return null;
    }
}

