/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.config;

import org.opensearch.jdbc.config.ConnectionPropertyException;

public abstract class ConnectionProperty<T> {
    private final String key;
    private Object rawValue;
    private T parsedValue;
    private boolean parsed = false;

    public ConnectionProperty(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(Object rawValue) throws ConnectionPropertyException {
        this.rawValue = rawValue;
        this.parsed = false;
        this.parse();
    }

    public T getValue() {
        this.verifyParsed();
        return this.parsedValue;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public abstract T getDefault();

    protected Object preProcess(Object value) {
        if (value instanceof String) {
            return ((String)value).trim();
        }
        return value;
    }

    protected abstract T parseValue(Object var1) throws ConnectionPropertyException;

    private void parse() throws ConnectionPropertyException {
        if (!this.parsed) {
            this.parsedValue = this.parseValue(this.preProcess(this.rawValue));
            this.parsed = true;
        }
    }

    private void verifyParsed() {
        if (!this.isParsed()) {
            throw new IllegalStateException(String.format("Property %s is not yet successfully parsed.", this.getKey()));
        }
    }
}

