/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.config;

import java.util.Locale;
import org.opensearch.jdbc.auth.AuthenticationType;
import org.opensearch.jdbc.config.ConnectionProperty;
import org.opensearch.jdbc.config.ConnectionPropertyException;

public class AuthConnectionProperty
extends ConnectionProperty<AuthenticationType> {
    public static final String KEY = "auth";

    public AuthConnectionProperty() {
        super(KEY);
    }

    @Override
    protected AuthenticationType parseValue(Object rawValue) throws ConnectionPropertyException {
        if (rawValue == null) {
            return this.getDefault();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            try {
                return AuthenticationType.valueOf(stringValue.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException iae) {
                throw new ConnectionPropertyException(this.getKey(), String.format("Invalid value specified for the property \"%s\". Unknown authentication type \"%s\".", this.getKey(), stringValue));
            }
        }
        throw new ConnectionPropertyException(this.getKey(), String.format("Property \"%s\" requires a valid String matching a known authentication type. Invalid value of type: %s specified.", this.getKey(), rawValue.getClass().getName()));
    }

    @Override
    public AuthenticationType getDefault() {
        return AuthenticationType.NONE;
    }
}

