/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class StructImpl
implements Struct {
    private final String typeName;
    private final Object[] attributes;

    public StructImpl(String typeName, Object[] attributes) {
        this.typeName = typeName;
        this.attributes = attributes;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Struct other = (Struct)obj;
        try {
            if (!this.typeName.equals(other.getSQLTypeName()) || this.attributes.length != other.getAttributes().length) {
                return false;
            }
            List<Object> otherAttributes = Arrays.asList(other.getAttributes());
            return otherAttributes.containsAll(Arrays.asList(this.attributes));
        }
        catch (SQLException e) {
            return false;
        }
    }
}

