/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.opensearch.jdbc.ConnectionImpl;
import org.opensearch.jdbc.ResultSetImpl;
import org.opensearch.jdbc.internal.JdbcWrapper;
import org.opensearch.jdbc.internal.exceptions.ObjectClosedException;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggingSource;
import org.opensearch.jdbc.protocol.JdbcQueryRequest;
import org.opensearch.jdbc.protocol.QueryResponse;
import org.opensearch.jdbc.protocol.exceptions.InternalServerErrorException;
import org.opensearch.jdbc.protocol.exceptions.ResponseException;

public class StatementImpl
implements Statement,
JdbcWrapper,
LoggingSource {
    protected ConnectionImpl connection;
    protected boolean open = false;
    protected int fetchSize;
    protected ResultSetImpl resultSet;
    protected Logger log;
    private boolean closeOnCompletion;

    public StatementImpl(ConnectionImpl connection, Logger log) {
        this.connection = connection;
        this.open = true;
        this.fetchSize = connection.getFetchSize();
        this.log = log;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.log.debug(() -> this.logEntry("executeQuery (%s)", sql));
        ResultSet rs = this.executeQueryX(sql, this.fetchSize);
        this.log.debug(() -> this.logExit("executeQuery", rs));
        return rs;
    }

    protected ResultSet executeQueryX(String sql, int fetchSize) throws SQLException {
        JdbcQueryRequest jdbcQueryRequest = new JdbcQueryRequest(sql, fetchSize);
        return this.executeQueryRequest(jdbcQueryRequest);
    }

    protected ResultSet executeQueryRequest(JdbcQueryRequest jdbcQueryRequest) throws SQLException {
        this.closeResultSet(false);
        try {
            QueryResponse queryResponse = this.connection.getProtocol().execute(jdbcQueryRequest);
            if (queryResponse.getError() != null) {
                throw new InternalServerErrorException(queryResponse.getError().getReason(), queryResponse.getError().getType(), queryResponse.getError().getDetails());
            }
            this.resultSet = this.buildResultSet(queryResponse);
        }
        catch (IOException | ResponseException ex) {
            this.logAndThrowSQLException(this.log, new SQLException("Error executing query", ex));
        }
        return this.resultSet;
    }

    protected ResultSetImpl buildResultSet(QueryResponse queryResponse) throws SQLException {
        return new ResultSetImpl(this, queryResponse, this.log);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void close() throws SQLException {
        this.log.debug(() -> this.logEntry("close ()", new Object[0]));
        this.open = false;
        this.log.debug(() -> this.logExit("close"));
    }

    private void closeX() throws SQLException {
        this.open = false;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancel not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.log.debug(() -> this.logEntry("execute (%s)", sql));
        this.checkOpen();
        this.executeQueryX(sql, this.fetchSize);
        this.log.debug(() -> this.logExit("execute", true));
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.log.debug(() -> this.logEntry("getResultSet ()", new Object[0]));
        this.checkOpen();
        this.log.debug(() -> this.logExit("getResultSet", this.resultSet));
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        this.closeResultSet(true);
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch execution is not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch execution is not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch execution is not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.log.debug(() -> this.logEntry("execute (%s, %d)", sql, autoGeneratedKeys));
        this.checkOpen();
        if (autoGeneratedKeys != 2) {
            throw new SQLNonTransientException("Auto generated keys are not supported");
        }
        this.executeQueryX(sql, this.fetchSize);
        this.log.debug(() -> this.logExit("execute", true));
        return true;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLNonTransientException("Auto generated keys are not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLNonTransientException("Auto generated keys are not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosedX();
    }

    protected boolean isClosedX() throws SQLException {
        return !this.open;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosedX()) {
            throw new ObjectClosedException("Statement closed.");
        }
    }

    protected void closeResultSet(boolean closeStatement) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.closeX(closeStatement);
        }
    }

    void resultSetClosed(ResultSet rs, boolean closeStatement) throws SQLException {
        if (this.closeOnCompletion && closeStatement) {
            this.log.debug(() -> this.logMessage("Child ResultSet closed and closeOnCompletion is enabled. Closing statement."));
            this.closeX();
        }
    }

    private SQLException updatesNotSupportedException() {
        return new SQLFeatureNotSupportedException("Updates are not supported");
    }
}

