/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.jdbc.ConnectionImpl;
import org.opensearch.jdbc.ResultSetMetaDataImpl;
import org.opensearch.jdbc.StatementImpl;
import org.opensearch.jdbc.config.ConnectionConfig;
import org.opensearch.jdbc.internal.JdbcWrapper;
import org.opensearch.jdbc.internal.exceptions.ObjectClosedException;
import org.opensearch.jdbc.internal.results.ColumnMetaData;
import org.opensearch.jdbc.internal.results.Cursor;
import org.opensearch.jdbc.internal.results.Row;
import org.opensearch.jdbc.internal.results.Schema;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggingSource;
import org.opensearch.jdbc.protocol.ColumnDescriptor;
import org.opensearch.jdbc.protocol.QueryResponse;
import org.opensearch.jdbc.protocol.exceptions.InternalServerErrorException;
import org.opensearch.jdbc.protocol.exceptions.ResponseException;
import org.opensearch.jdbc.protocol.http.JdbcCursorQueryRequest;
import org.opensearch.jdbc.protocol.http.JsonCursorHttpProtocol;
import org.opensearch.jdbc.protocol.http.JsonCursorHttpProtocolFactory;
import org.opensearch.jdbc.transport.http.HttpTransport;
import org.opensearch.jdbc.types.TypeConverter;
import org.opensearch.jdbc.types.TypeConverters;
import org.opensearch.jdbc.types.UnrecognizedOpenSearchTypeException;

public class ResultSetImpl
implements ResultSet,
JdbcWrapper,
LoggingSource {
    private StatementImpl statement;
    protected Cursor cursor;
    private String cursorId;
    private boolean open = false;
    private boolean wasNull = false;
    private boolean afterLast = false;
    private boolean beforeFirst = true;
    private Logger log;

    public ResultSetImpl(StatementImpl statement, QueryResponse queryResponse, Logger log) throws SQLException {
        this(statement, queryResponse.getColumnDescriptors(), queryResponse.getDatarows(), queryResponse.getCursor(), log);
    }

    public ResultSetImpl(StatementImpl statement, List<? extends ColumnDescriptor> columnDescriptors, List<List<Object>> dataRows, Logger log) throws SQLException {
        this(statement, columnDescriptors, dataRows, null, log);
    }

    public ResultSetImpl(StatementImpl statement, List<? extends ColumnDescriptor> columnDescriptors, List<List<Object>> dataRows, String cursorId, Logger log) throws SQLException {
        this.statement = statement;
        this.log = log;
        try {
            Schema schema = new Schema(columnDescriptors.stream().map(ColumnMetaData::new).collect(Collectors.toList()));
            List<Row> rows = this.getRowsFromDataRows(dataRows);
            this.cursor = new Cursor(schema, rows);
            this.cursorId = cursorId;
            this.open = true;
        }
        catch (UnrecognizedOpenSearchTypeException ex) {
            this.logAndThrowSQLException(log, new SQLException("Exception creating a ResultSet.", ex));
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.log.debug(() -> this.logEntry("next()", new Object[0]));
        this.checkOpen();
        boolean next = this.cursor.next();
        if (!next && this.cursorId != null) {
            this.log.debug(() -> this.logEntry("buildNextPageFromCursorId()", new Object[0]));
            this.buildNextPageFromCursorId();
            this.log.debug(() -> this.logExit("buildNextPageFromCursorId()"));
            next = this.cursor.next();
        }
        if (next) {
            this.beforeFirst = false;
        } else {
            this.afterLast = true;
        }
        boolean finalNext = next;
        this.log.debug(() -> this.logExit("next", finalNext));
        return next;
    }

    protected void buildNextPageFromCursorId() throws SQLException {
        try {
            JdbcCursorQueryRequest jdbcCursorQueryRequest = new JdbcCursorQueryRequest(this.cursorId);
            JsonCursorHttpProtocolFactory protocolFactory = JsonCursorHttpProtocolFactory.INSTANCE;
            ConnectionImpl connection = (ConnectionImpl)this.statement.getConnection();
            JsonCursorHttpProtocol protocol = protocolFactory.getProtocol((ConnectionConfig)null, (HttpTransport)connection.getTransport());
            QueryResponse queryResponse = protocol.execute(jdbcCursorQueryRequest);
            if (queryResponse.getError() != null) {
                throw new InternalServerErrorException(queryResponse.getError().getReason(), queryResponse.getError().getType(), queryResponse.getError().getDetails());
            }
            this.cursor = new Cursor(this.cursor.getSchema(), this.getRowsFromDataRows(queryResponse.getDatarows()));
            this.cursorId = queryResponse.getCursor();
        }
        catch (IOException | ResponseException ex) {
            this.logAndThrowSQLException(this.log, new SQLException("Error executing cursor query", ex));
        }
    }

    private List<Row> getRowsFromDataRows(List<List<Object>> dataRows) {
        return dataRows.parallelStream().map(Row::new).collect(Collectors.toList());
    }

    @Override
    public void close() throws SQLException {
        this.log.debug(() -> this.logEntry("close()", new Object[0]));
        this.closeX(true);
        this.log.debug(() -> this.logExit("close"));
    }

    protected void closeX(boolean closeStatement) throws SQLException {
        this.cursor = null;
        this.open = false;
        if (this.statement != null) {
            this.statement.resultSetClosed(this, closeStatement);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getString (%d)", columnIndex));
        this.checkCursorOperationPossible();
        String value = this.getStringX(columnIndex);
        this.log.debug(() -> this.logExit("getString", value));
        return value;
    }

    private String getStringX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, String.class);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getBoolean (%d)", columnIndex));
        this.checkCursorOperationPossible();
        boolean value = this.getBooleanX(columnIndex);
        this.log.debug(() -> this.logExit("getBoolean", value));
        return value;
    }

    private boolean getBooleanX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, Boolean.class);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getByte (%d)", columnIndex));
        this.checkCursorOperationPossible();
        byte value = this.getByteX(columnIndex);
        this.log.debug(() -> this.logExit("getByte", value));
        return value;
    }

    private byte getByteX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, Byte.class);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getShort (%d)", columnIndex));
        this.checkCursorOperationPossible();
        short value = this.getShortX(columnIndex);
        this.log.debug(() -> this.logExit("getShort", value));
        return value;
    }

    private short getShortX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, Short.class);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getInt (%d)", columnIndex));
        this.checkCursorOperationPossible();
        int value = this.getIntX(columnIndex);
        this.log.debug(() -> this.logExit("getInt", value));
        return value;
    }

    private int getIntX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, Integer.class);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getLong (%d)", columnIndex));
        this.checkCursorOperationPossible();
        long value = this.getLongX(columnIndex);
        this.log.debug(() -> this.logExit("getLong", value));
        return value;
    }

    private long getLongX(int columnIndex) throws SQLException {
        this.checkCursorOperationPossible();
        return this.getObjectX(columnIndex, Long.class);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getFloat (%d)", columnIndex));
        this.checkCursorOperationPossible();
        float value = this.getFloatX(columnIndex);
        this.log.debug(() -> this.logExit("getFloat", Float.valueOf(value)));
        return value;
    }

    private float getFloatX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, Float.class).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getDouble (%d)", columnIndex));
        this.checkCursorOperationPossible();
        double value = this.getDoubleX(columnIndex);
        this.log.debug(() -> this.logExit("getDouble", value));
        return value;
    }

    private double getDoubleX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, Double.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.log.debug(() -> this.logEntry("getBigDecimal (%d, %d)", columnIndex, scale));
        this.checkCursorOperationPossible();
        BigDecimal value = this.getBigDecimalX(columnIndex, scale);
        this.log.debug(() -> this.logExit("getBigDecimal", value));
        return value;
    }

    private BigDecimal getBigDecimalX(int columnIndex, int scale) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("BigDecimal is not supported");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getBytes (%d)", columnIndex));
        this.checkCursorOperationPossible();
        byte[] value = this.getBytesX(columnIndex);
        this.log.debug(() -> this.logExit("getBytes", String.format("%s, length(%s)", value, value != null ? value.length : 0)));
        return value;
    }

    private byte[] getBytesX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, byte[].class);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getDate (%d)", columnIndex));
        this.checkCursorOperationPossible();
        Date value = this.getDateX(columnIndex, null);
        this.log.debug(() -> this.logExit("getDate", value));
        return value;
    }

    private Date getDateX(int columnIndex, Calendar calendar) throws SQLException {
        HashMap<String, Object> conversionParams = null;
        if (calendar != null) {
            conversionParams = new HashMap<String, Object>();
            conversionParams.put("calendar", calendar);
        }
        return this.getObjectX(columnIndex, Date.class, conversionParams);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getTime (%d)", columnIndex));
        this.checkCursorOperationPossible();
        Time value = this.getTimeX(columnIndex, null);
        this.log.debug(() -> this.logExit("getTime", value));
        return value;
    }

    private Time getTimeX(int columnIndex, Calendar calendar) throws SQLException {
        HashMap<String, Object> conversionParams = null;
        if (calendar != null) {
            conversionParams = new HashMap<String, Object>();
            conversionParams.put("calendar", calendar);
        }
        return this.getObjectX(columnIndex, Time.class, conversionParams);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getTimestamp (%d)", columnIndex));
        this.checkCursorOperationPossible();
        Timestamp value = this.getTimestampX(columnIndex, null);
        this.log.debug(() -> this.logExit("getTimestamp", value));
        return value;
    }

    private Timestamp getTimestampX(int columnIndex, Calendar calendar) throws SQLException {
        HashMap<String, Object> conversionParams = null;
        if (calendar != null) {
            conversionParams = new HashMap<String, Object>();
            conversionParams.put("calendar", calendar);
        }
        return this.getObjectX(columnIndex, Timestamp.class, conversionParams);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getString (%s)", columnLabel));
        this.checkCursorOperationPossible();
        String value = this.getStringX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getString", value));
        return value;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getBoolean (%s)", columnLabel));
        this.checkCursorOperationPossible();
        boolean value = this.getBooleanX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getBoolean", value));
        return value;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getByte (%s)", columnLabel));
        this.checkCursorOperationPossible();
        byte value = this.getByteX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getByte", value));
        return value;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getShort (%s)", columnLabel));
        this.checkCursorOperationPossible();
        short value = this.getShortX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getShort", value));
        return value;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getInt (%s)", columnLabel));
        this.checkCursorOperationPossible();
        int value = this.getIntX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getInt", value));
        return value;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getLong (%s)", columnLabel));
        this.checkCursorOperationPossible();
        long value = this.getLongX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getLong", value));
        return value;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getFloat (%s)", columnLabel));
        this.checkCursorOperationPossible();
        float value = this.getFloatX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getFloat", Float.valueOf(value)));
        return value;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getDouble (%s)", columnLabel));
        this.checkCursorOperationPossible();
        double value = this.getDoubleX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getDouble", value));
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.log.debug(() -> this.logEntry("getBigDecimal (%s, %d)", columnLabel, scale));
        this.checkCursorOperationPossible();
        BigDecimal value = this.getBigDecimalX(this.getColumnIndex(columnLabel), scale);
        this.log.debug(() -> this.logExit("getBigDecimal", value));
        return value;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getBytes (%s)", columnLabel));
        this.checkCursorOperationPossible();
        byte[] value = this.getBytesX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getBytes", String.format("%s, length(%s)", value, value != null ? value.length : 0)));
        return value;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getDate (%s)", columnLabel));
        this.checkCursorOperationPossible();
        Date value = this.getDateX(this.getColumnIndex(columnLabel), null);
        this.log.debug(() -> this.logExit("getDate", value));
        return value;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getTime (%s)", columnLabel));
        this.checkCursorOperationPossible();
        Time value = this.getTimeX(this.getColumnIndex(columnLabel), null);
        this.log.debug(() -> this.logExit("getTime", value));
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getTimestamp (%s)", columnLabel));
        this.checkCursorOperationPossible();
        Timestamp value = this.getTimestampX(this.getColumnIndex(columnLabel), null);
        this.log.debug(() -> this.logExit("getTimestamp", value));
        return value;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor name is not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new ResultSetMetaDataImpl(this, this.cursor.getSchema());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getObject (%d)", columnIndex));
        this.checkCursorOperationPossible();
        Object value = this.getObjectX(columnIndex);
        this.log.debug(() -> this.logExit("getObject", value != null ? "(" + value.getClass().getName() + ") " + value : "null"));
        return value;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getObject (%s)", columnLabel));
        this.checkCursorOperationPossible();
        Object value = this.getObjectX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getObject", value != null ? "(" + value.getClass().getName() + ") " + value : "null"));
        return value;
    }

    private Object getObjectX(int columnIndex) throws SQLException {
        return this.getObjectX(columnIndex, (Class)null);
    }

    protected <T> T getObjectX(int columnIndex, Class<T> javaClass) throws SQLException {
        return this.getObjectX(columnIndex, javaClass, null);
    }

    protected <T> T getObjectX(int columnIndex, Class<T> javaClass, Map<String, Object> conversionParams) throws SQLException {
        Object value = this.getColumn(columnIndex);
        TypeConverter tc = TypeConverters.getInstance(this.getColumnMetaData(columnIndex).getOpenSearchType().getJdbcType());
        if (null == tc) {
            throw new SQLException("Conversion from " + (Object)((Object)this.getColumnMetaData(columnIndex).getOpenSearchType()) + " not supported.");
        }
        return tc.convert(value, javaClass, conversionParams);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        return this.getColumnIndex(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("BigDecimal is not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("BigDecimal is not supported");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return this.beforeFirst;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        return this.afterLast;
    }

    private boolean isBeforeFirstX() throws SQLException {
        return this.beforeFirst;
    }

    private boolean isAfterLastX() throws SQLException {
        return this.afterLast;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkOpen();
        throw new SQLDataException("Illegal operation on ResultSet of type TYPE_FORWARD_ONLY");
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkOpen();
        throw new SQLDataException("Illegal operation on ResultSet of type TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean first() throws SQLException {
        this.checkOpen();
        throw new SQLDataException("Illegal operation on ResultSet of type TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkOpen();
        throw new SQLDataException("Illegal operation on ResultSet of type TYPE_FORWARD_ONLY");
    }

    @Override
    public int getRow() throws SQLException {
        return 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkOpen();
        throw new SQLDataException("Illegal operation on ResultSet of type TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkOpen();
        throw new SQLDataException("Illegal operation on ResultSet of type TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkOpen();
        throw new SQLDataException("Illegal operation on ResultSet of type TYPE_FORWARD_ONLY");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (direction != 1000) {
            throw new SQLDataException("The ResultSet only supports FETCH_FORWARD direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.log.debug(() -> this.logEntry("getObject (%d, %s)", columnIndex, map));
        Object value = this.getObjectX(columnIndex, map);
        this.log.debug(() -> this.logExit("getObject", value));
        return value;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Ref is not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blob is not supported");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clob is not supported");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Array is not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.log.debug(() -> this.logEntry("getObject (%s, %s)", columnLabel, map));
        Object value = this.getObjectX(this.getColumnIndex(columnLabel), map);
        this.log.debug(() -> this.logExit("getObject", value));
        return value;
    }

    private Object getObjectX(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        String columnSQLTypeName = null;
        Class<?> targetClass = null;
        if (map != null) {
            columnSQLTypeName = this.getColumnMetaData(columnIndex).getOpenSearchType().getJdbcType().getName();
            targetClass = map.get(columnSQLTypeName);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.logMessage("Column SQL Type is: %s. Target class retrieved from custom mapping: %s", columnSQLTypeName, targetClass));
        }
        return this.getObjectX(columnIndex, targetClass);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Ref is not supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blob is not supported");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clob is not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Array is not supported");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("getDate (%d, %s)", columnIndex, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkCursorOperationPossible();
        Date value = this.getDateX(columnIndex, cal);
        this.log.debug(() -> this.logExit("getDate", value));
        return value;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("getDate (%s, %s)", columnLabel, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkCursorOperationPossible();
        Date value = this.getDateX(this.getColumnIndex(columnLabel), cal);
        this.log.debug(() -> this.logExit("getDate", value));
        return value;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("getTime (%d, %s)", columnIndex, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkCursorOperationPossible();
        Time value = this.getTimeX(columnIndex, cal);
        this.log.debug(() -> this.logExit("getTime", value));
        return value;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("getTime (%s, %s)", columnLabel, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkCursorOperationPossible();
        Time value = this.getTimeX(this.getColumnIndex(columnLabel), cal);
        this.log.debug(() -> this.logExit("getTime", value));
        return value;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("getTimestamp (%d, %s)", columnIndex, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkCursorOperationPossible();
        Timestamp value = this.getTimestampX(columnIndex, cal);
        this.log.debug(() -> this.logExit("getTimestamp", value));
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("getTimestamp (%s, %s)", columnLabel, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkCursorOperationPossible();
        Timestamp value = this.getTimestampX(this.getColumnIndex(columnLabel), cal);
        this.log.debug(() -> this.logExit("getTimestamp", value));
        return value;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("RowId is not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("RowId is not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClob is not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClob is not supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXML is not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXML is not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.log.debug(() -> this.logEntry("getNString (%d)", columnIndex));
        String value = this.getStringX(columnIndex);
        this.log.debug(() -> this.logExit("getNString", value));
        return value;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.log.debug(() -> this.logEntry("getNString (%s)", columnLabel));
        String value = this.getStringX(this.getColumnIndex(columnLabel));
        this.log.debug(() -> this.logExit("getNString", value));
        return value;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Streams are not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw this.updatesNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.log.debug(() -> this.logEntry("getObject(%d, %s)", columnIndex, type));
        Object value = this.getObjectX(columnIndex, type);
        this.log.debug(() -> this.logExit("getObject", value));
        return value;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.log.debug(() -> this.logEntry("getObject(%d, %s)", columnLabel, type));
        Object value = this.getObjectX(this.getColumnIndex(columnLabel), type);
        this.log.debug(() -> this.logExit("getObject", value));
        return value;
    }

    private int getColumnIndex(String columnLabel) throws SQLException {
        Integer index = this.cursor.findColumn(columnLabel);
        if (index == null) {
            this.logAndThrowSQLException(this.log, new SQLDataException("Column '" + columnLabel + "' not found."));
        }
        return index + 1;
    }

    protected Object getColumn(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object columnData = this.getColumnFromCursor(columnIndex);
        this.wasNull = columnData == null;
        return columnData;
    }

    protected Object getColumnFromCursor(int columnIndex) {
        return this.cursor.getColumn(columnIndex - 1);
    }

    private ColumnMetaData getColumnMetaData(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return this.cursor.getSchema().getColumnMetaData(columnIndex - 1);
    }

    protected void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.cursor.getColumnCount()) {
            this.logAndThrowSQLException(this.log, new SQLDataException("Column index out of range."));
        }
    }

    protected void checkCursorOperationPossible() throws SQLException {
        this.checkOpen();
        this.checkValidCursorPosition();
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            this.logAndThrowSQLException(this.log, new ObjectClosedException("ResultSet closed."));
        }
    }

    private void checkValidCursorPosition() throws SQLException {
        if (this.isBeforeFirstX()) {
            this.logAndThrowSQLException(this.log, new SQLNonTransientException("Illegal operation before start of ResultSet."));
        } else if (this.isAfterLastX()) {
            this.logAndThrowSQLException(this.log, new SQLNonTransientException("Illegal operation after end of ResultSet."));
        }
    }

    private SQLException updatesNotSupportedException() {
        return new SQLFeatureNotSupportedException("Updates are not supported");
    }
}

