/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opensearch.jdbc.ConnectionImpl;
import org.opensearch.jdbc.PreparedStatementImpl;
import org.opensearch.jdbc.ResultSetImpl;
import org.opensearch.jdbc.StatementImpl;
import org.opensearch.jdbc.internal.JdbcWrapper;
import org.opensearch.jdbc.internal.Version;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggingSource;
import org.opensearch.jdbc.protocol.ColumnDescriptor;
import org.opensearch.jdbc.protocol.QueryResponse;
import org.opensearch.jdbc.types.OpenSearchType;

public class DatabaseMetaDataImpl
implements DatabaseMetaData,
JdbcWrapper,
LoggingSource {
    private ConnectionImpl connection;
    private Logger log;

    public DatabaseMetaDataImpl(ConnectionImpl connection, Logger log) {
        this.connection = connection;
        this.log = log;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "OpenSearch";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getClusterMetadata().getVersion().getFullVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "OpenSearch JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return Version.Current.getFullVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return Version.Current.getMajor();
    }

    @Override
    public int getDriverMinorVersion() {
        return Version.Current.getMinor();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "clusterName";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("PROCEDURE_CAT"), DatabaseMetaDataImpl.rscd("PROCEDURE_SCHEM"), DatabaseMetaDataImpl.rscd("PROCEDURE_NAME"), DatabaseMetaDataImpl.rscd("RESERVED4"), DatabaseMetaDataImpl.rscd("RESERVED5"), DatabaseMetaDataImpl.rscd("RESERVED6"), DatabaseMetaDataImpl.rscd("REMARKS"), DatabaseMetaDataImpl.rscd("PROCEDURE_TYPE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("PROCEDURE_CAT"), DatabaseMetaDataImpl.rscd("PROCEDURE_SCHEM"), DatabaseMetaDataImpl.rscd("PROCEDURE_NAME"), DatabaseMetaDataImpl.rscd("COLUMN_NAME"), DatabaseMetaDataImpl.rscd("COLUMN_TYPE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("DATA_TYPE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("TYPE_NAME"), DatabaseMetaDataImpl.rscd("PRECISION", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("LENGTH", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("SCALE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("RADIX", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("NULLABLE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("REMARKS"), DatabaseMetaDataImpl.rscd("COLUMN_DEF"), DatabaseMetaDataImpl.rscd("SQL_DATA_TYPE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("SQL_DATETIME_SUB", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("CHAR_OCTET_LENGTH", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("ORDINAL_POSITION", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("IS_NULLABLE"), DatabaseMetaDataImpl.rscd("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.log.debug(() -> this.logMessage("getTables(%s, %s, %s, %s)", catalog, schemaPattern, tableNamePattern, Arrays.toString(types)));
        PreparedStatement pst = this.connection.prepareStatement("SHOW TABLES LIKE '" + (tableNamePattern == null ? "%" : tableNamePattern) + "'");
        ResultSet resultSet = pst.executeQuery();
        this.log.debug(() -> this.logMessage("getTables returning: " + resultSet));
        return resultSet;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.log.debug(() -> this.logMessage("getSchemas()"));
        ResultSet resultSet = this.getSchemasX(null, null);
        this.log.debug(() -> this.logMessage("getSchemas() returning: " + resultSet));
        return resultSet;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.log.debug(() -> this.logMessage("getSchemas(%s, %s)", catalog, schemaPattern));
        ResultSet resultSet = this.getSchemasX(catalog, schemaPattern);
        this.log.debug(() -> this.logMessage("getSchemas() returning: %s", resultSet));
        return resultSet;
    }

    private ResultSet getSchemasX(String catalog, String schemaPattern) throws SQLException {
        ArrayList<ResultSetColumnDescriptor> columnDescriptors = new ArrayList<ResultSetColumnDescriptor>();
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("TABLE_SCHEM"));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("TABLE_CATALOG"));
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        if (this.clusterCatalogMatches(catalog) && this.clusterSchemaMatches(schemaPattern)) {
            dataRows.add(Arrays.asList("", this.getClusterCatalogName()));
        }
        return new ResultSetImpl(null, columnDescriptors, dataRows, this.log);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.log.debug(() -> this.logMessage("getCatalogs()"));
        ArrayList<ResultSetColumnDescriptor> columnDescriptors = new ArrayList<ResultSetColumnDescriptor>();
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("TABLE_CAT"));
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        dataRows.add(Arrays.asList(this.getClusterCatalogName()));
        ResultSetImpl resultSet = new ResultSetImpl(null, columnDescriptors, dataRows, this.log);
        this.log.debug(() -> this.logMessage("getCatalogs() returning: %s", resultSet));
        return resultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.log.debug(() -> this.logMessage("getTableTypes()"));
        ArrayList<ResultSetColumnDescriptor> columnDescriptors = new ArrayList<ResultSetColumnDescriptor>();
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("TABLE_TYPE"));
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        dataRows.add(Arrays.asList("BASE TABLE"));
        ResultSetImpl resultSet = new ResultSetImpl(null, columnDescriptors, dataRows, this.log);
        this.log.debug(() -> this.logMessage("getTableTypes() returning: %s", resultSet));
        return resultSet;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.log.debug(() -> this.logMessage("getColumns(%s, %s, %s, %s)", catalog, schemaPattern, tableNamePattern, columnNamePattern));
        ColumnMetadataStatement statement = new ColumnMetadataStatement(this.connection, tableNamePattern, columnNamePattern, this.log);
        ResultSet resultSet = statement.executeQuery();
        this.log.debug(() -> this.logMessage("getColumns() returning: %s", resultSet));
        return resultSet;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Privileges are not supported");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Privileges are not supported");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Row identifiers are not supported");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("Version columns are not supported");
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("Primary keys are not supported");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("Primary and Foreign keys are not supported");
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("Primary and Foreign keys are not supported");
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Primary and Foreign keys are not supported");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this.log.debug(() -> this.logMessage("getTypeInfo()"));
        ArrayList<ResultSetColumnDescriptor> columnDescriptors = new ArrayList<ResultSetColumnDescriptor>();
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("TYPE_NAME"));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("DATA_TYPE", OpenSearchType.INTEGER.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("PRECISION", OpenSearchType.INTEGER.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("LITERAL_PREFIX"));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("LITERAL_SUFFIX"));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("CREATE_PARAMS"));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("NULLABLE", OpenSearchType.SHORT.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("CASE_SENSITIVE", OpenSearchType.BOOLEAN.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("SEARCHABLE", OpenSearchType.SHORT.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("UNSIGNED_ATTRIBUTE", OpenSearchType.BOOLEAN.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("FIXED_PREC_SCALE", OpenSearchType.BOOLEAN.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("AUTO_INCREMENT", OpenSearchType.BOOLEAN.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("LOCAL_TYPE_NAME"));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("MINIMUM_SCALE", OpenSearchType.SHORT.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("MAXIMUM_SCALE", OpenSearchType.SHORT.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("SQL_DATA_TYPE", OpenSearchType.INTEGER.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("SQL_DATETIME_SUB", OpenSearchType.INTEGER.getTypeName()));
        columnDescriptors.add(DatabaseMetaDataImpl.rscd("NUM_PREC_RADIX", OpenSearchType.INTEGER.getTypeName()));
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        for (OpenSearchType openSearchType : OpenSearchType.values()) {
            dataRows.add(Arrays.asList(openSearchType.name(), openSearchType.getJdbcType().getVendorTypeNumber(), openSearchType.getPrecision(), "'", "'", null, 2, openSearchType == OpenSearchType.TEXT || openSearchType == OpenSearchType.KEYWORD, 3, !openSearchType.isSigned(), false, false, null, null, null, null, null, 10));
        }
        ResultSetImpl resultSet = new ResultSetImpl(null, columnDescriptors, dataRows, this.log);
        this.log.debug(() -> this.logMessage("getTypeInfo() returning: %s", resultSet));
        return resultSet;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new SQLFeatureNotSupportedException("Table indices are not supported");
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && 1007 == concurrency;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("TYPE_CAT"), DatabaseMetaDataImpl.rscd("TYPE_SCHEM"), DatabaseMetaDataImpl.rscd("TYPE_NAME"), DatabaseMetaDataImpl.rscd("CLASS_NAME"), DatabaseMetaDataImpl.rscd("DATA_TYPE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("REMARKS"), DatabaseMetaDataImpl.rscd("BASE_TYPE", OpenSearchType.SHORT.getTypeName()));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("TYPE_CAT"), DatabaseMetaDataImpl.rscd("TYPE_SCHEM"), DatabaseMetaDataImpl.rscd("TYPE_NAME"), DatabaseMetaDataImpl.rscd("SUPERTYPE_CAT"), DatabaseMetaDataImpl.rscd("SUPERTYPE_SCHEM"), DatabaseMetaDataImpl.rscd("SUPERTYPE_NAME"));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("TABLE_CAT"), DatabaseMetaDataImpl.rscd("TABLE_SCHEM"), DatabaseMetaDataImpl.rscd("TABLE_NAME"), DatabaseMetaDataImpl.rscd("SUPERTABLE_NAME"));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("TYPE_CAT"), DatabaseMetaDataImpl.rscd("TYPE_SCHEM"), DatabaseMetaDataImpl.rscd("TYPE_NAME"), DatabaseMetaDataImpl.rscd("ATTR_NAME"), DatabaseMetaDataImpl.rscd("DATA_TYPE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("ATTR_TYPE_NAME"), DatabaseMetaDataImpl.rscd("ATTR_SIZE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("DECIMAL_DIGITS", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("NUM_PREC_RADIX", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("NULLABLE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("REMARKS"), DatabaseMetaDataImpl.rscd("ATTR_DEF"), DatabaseMetaDataImpl.rscd("SQL_DATA_TYPE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("SQL_DATETIME_SUB", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("CHAR_OCTET_LENGTH", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("ORDINAL_POSITION", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("IS_NULLABLE"), DatabaseMetaDataImpl.rscd("SCOPE_CATALOG"), DatabaseMetaDataImpl.rscd("SCOPE_SCHEMA"), DatabaseMetaDataImpl.rscd("SCOPE_TABLE"), DatabaseMetaDataImpl.rscd("SOURCE_DATA_TYPE", OpenSearchType.SHORT.getTypeName()));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getClusterMetadata().getVersion().getMajor();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getClusterMetadata().getVersion().getMinor();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLException("Client info not implemented yet");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("FUNCTION_CAT"), DatabaseMetaDataImpl.rscd("FUNCTION_SCHEM"), DatabaseMetaDataImpl.rscd("FUNCTION_NAME"), DatabaseMetaDataImpl.rscd("REMARKS"), DatabaseMetaDataImpl.rscd("FUNCTION_TYPE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("FUNCTION_CAT"), DatabaseMetaDataImpl.rscd("FUNCTION_SCHEM"), DatabaseMetaDataImpl.rscd("FUNCTION_NAME"), DatabaseMetaDataImpl.rscd("COLUMN_NAME"), DatabaseMetaDataImpl.rscd("COLUMN_TYPE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("DATA_TYPE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("TYPE_NAME"), DatabaseMetaDataImpl.rscd("PRECISION", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("LENGTH", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("SCALE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("RADIX", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("NULLABLE", OpenSearchType.SHORT.getTypeName()), DatabaseMetaDataImpl.rscd("REMARKS"), DatabaseMetaDataImpl.rscd("CHAR_OCTET_LENGTH", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("ORDINAL_POSITION", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("IS_NULLABLE"), DatabaseMetaDataImpl.rscd("SPECIFIC_NAME"));
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return DatabaseMetaDataImpl.emptyResultSet(this.log, DatabaseMetaDataImpl.rscd("TABLE_CAT"), DatabaseMetaDataImpl.rscd("TABLE_SCHEM"), DatabaseMetaDataImpl.rscd("TABLE_NAME"), DatabaseMetaDataImpl.rscd("COLUMN_NAME"), DatabaseMetaDataImpl.rscd("DATA_TYPE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("COLUMN_SIZE", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("DECIMAL_DIGITS", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("NUM_PREC_RADIX", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("COLUMN_USAGE"), DatabaseMetaDataImpl.rscd("REMARKS"), DatabaseMetaDataImpl.rscd("CHAR_OCTET_LENGTH", OpenSearchType.INTEGER.getTypeName()), DatabaseMetaDataImpl.rscd("IS_NULLABLE"));
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    static ResultSetColumnDescriptor rscd(String name) {
        return DatabaseMetaDataImpl.rscd(name, OpenSearchType.TEXT.getTypeName(), null);
    }

    static ResultSetColumnDescriptor rscd(String name, String type) {
        return DatabaseMetaDataImpl.rscd(name, type, null);
    }

    static ResultSetColumnDescriptor rscd(String name, String type, String label) {
        return new ResultSetColumnDescriptor(name, type, label);
    }

    private String getClusterCatalogName() throws SQLException {
        return this.connection.getClusterMetadata().getClusterName();
    }

    private boolean clusterCatalogMatches(String catalog) throws SQLException {
        return catalog == null || "%".equalsIgnoreCase(catalog) || catalog.equalsIgnoreCase(this.getClusterCatalogName());
    }

    private boolean clusterSchemaMatches(String schema) {
        return schema == null || schema.equals("%") || schema.equals("");
    }

    private static ResultSetImpl emptyResultSet(Logger log, ResultSetColumnDescriptor ... resultSetColumnDescriptors) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(0);
        return new ResultSetImpl(null, Arrays.asList(resultSetColumnDescriptors), rows, log);
    }

    static class ColumnMetadataStatement
    extends PreparedStatementImpl {
        ColumnMetadataStatement(ConnectionImpl connection, String tableNamePattern, String columnNamePattern, Logger log) throws SQLException {
            super(connection, "DESCRIBE TABLES LIKE '" + tableNamePattern + (columnNamePattern != null ? "' COLUMNS LIKE '" + columnNamePattern + "'" : "'"), log);
        }

        @Override
        protected ResultSetImpl buildResultSet(QueryResponse queryResponse) throws SQLException {
            ArrayList<ResultSetColumnDescriptor> columnDescriptors = new ArrayList<ResultSetColumnDescriptor>();
            for (ColumnDescriptor columnDescriptor : queryResponse.getColumnDescriptors()) {
                if ("DATA_TYPE".equals(columnDescriptor.getName()) || "COLUMN_SIZE".equals(columnDescriptor.getName())) {
                    columnDescriptors.add(DatabaseMetaDataImpl.rscd(columnDescriptor.getName(), OpenSearchType.INTEGER.getTypeName()));
                    continue;
                }
                columnDescriptors.add(DatabaseMetaDataImpl.rscd(columnDescriptor.getName(), columnDescriptor.getType()));
            }
            return new ColumnMetadataResultSet(this, columnDescriptors, queryResponse.getDatarows(), this.log);
        }

        static class ColumnMetadataResultSet
        extends ResultSetImpl {
            ColumnMetadataResultSet(StatementImpl statement, List<? extends ColumnDescriptor> columnDescriptors, List<List<Object>> dataRows, Logger log) throws SQLException {
                super(statement, columnDescriptors, dataRows, log);
            }

            private int getDataType() {
                String esDataType = (String)this.cursor.getColumn(5);
                return OpenSearchType.fromTypeName(esDataType, false).sqlTypeNumber();
            }

            private String getDataTypeName() {
                String esDataType = (String)this.cursor.getColumn(5);
                return OpenSearchType.fromTypeName(esDataType, false).name();
            }

            private int getColumnSize() {
                String esDataType = (String)this.cursor.getColumn(5);
                return OpenSearchType.fromTypeName(esDataType, false).getPrecision();
            }

            @Override
            protected Object getColumnFromCursor(int columnIndex) {
                Object columnData = null;
                switch (columnIndex) {
                    case 5: {
                        columnData = this.getDataType();
                        break;
                    }
                    case 6: {
                        columnData = this.getDataTypeName();
                        break;
                    }
                    case 7: {
                        columnData = this.getColumnSize();
                        break;
                    }
                    default: {
                        columnData = super.getColumnFromCursor(columnIndex);
                    }
                }
                return columnData;
            }
        }
    }

    public static class ResultSetColumnDescriptor
    implements ColumnDescriptor {
        private String name;
        private String type;
        private String label;

        public ResultSetColumnDescriptor(String name, String type, String label) {
            this.name = name;
            this.type = type;
            this.label = label;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }
}

