/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.types;

import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opensearch.jdbc.types.UnrecognizedOpenSearchTypeException;

public enum OpenSearchType {
    BOOLEAN(JDBCType.BOOLEAN, Boolean.class, 1, 1, false),
    BYTE(JDBCType.TINYINT, Byte.class, 3, 5, true),
    SHORT(JDBCType.SMALLINT, Short.class, 5, 6, true),
    INTEGER(JDBCType.INTEGER, Integer.class, 10, 11, true),
    LONG(JDBCType.BIGINT, Long.class, 19, 20, true),
    HALF_FLOAT(JDBCType.REAL, Float.class, 7, 15, true),
    FLOAT(JDBCType.REAL, Float.class, 7, 15, true),
    DOUBLE(JDBCType.DOUBLE, Double.class, 15, 25, true),
    SCALED_FLOAT(JDBCType.DOUBLE, Double.class, 15, 25, true),
    KEYWORD(JDBCType.VARCHAR, String.class, 256, 0, false),
    TEXT(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, 0, false),
    STRING(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, 0, false),
    IP(JDBCType.VARCHAR, String.class, 15, 0, false),
    NESTED(JDBCType.STRUCT, null, 0, 0, false),
    OBJECT(JDBCType.STRUCT, null, 0, 0, false),
    DATE(JDBCType.DATE, Date.class, 10, 10, false),
    TIME(JDBCType.TIME, Time.class, 8, 8, false),
    DATETIME(JDBCType.TIMESTAMP, Timestamp.class, 29, 29, false),
    TIMESTAMP(JDBCType.TIMESTAMP, Timestamp.class, 29, 29, false),
    BINARY(JDBCType.VARBINARY, String.class, Integer.MAX_VALUE, 0, false),
    NULL(JDBCType.NULL, null, 0, 0, false),
    UNDEFINED(JDBCType.NULL, null, 0, 0, false),
    UNSUPPORTED(JDBCType.OTHER, null, 0, 0, false);

    private static final Map<JDBCType, OpenSearchType> jdbcTypeToOpenSearchTypeMap;
    private final String typeName = this.name().toLowerCase(Locale.ROOT);
    private final JDBCType jdbcType;
    private final String javaClassName;
    private final int precision;
    private final int displaySize;
    private final boolean isSigned;

    private OpenSearchType(JDBCType jdbcType, Class<?> javaClass, int precision, int displaySize, boolean isSigned) {
        this.jdbcType = jdbcType;
        this.javaClassName = javaClass == null ? null : javaClass.getName();
        this.precision = precision;
        this.displaySize = displaySize;
        this.isSigned = isSigned;
    }

    public static OpenSearchType fromJdbcType(JDBCType jdbcType) {
        if (!jdbcTypeToOpenSearchTypeMap.containsKey(jdbcType)) {
            throw new IllegalArgumentException("Unsupported JDBC type \"" + jdbcType + "\"");
        }
        return jdbcTypeToOpenSearchTypeMap.get(jdbcType);
    }

    public static OpenSearchType fromTypeName(String typeName) {
        return OpenSearchType.fromTypeName(typeName, false);
    }

    public static OpenSearchType fromTypeName(String typeName, boolean errorOnUnknownType) {
        try {
            return OpenSearchType.valueOf(typeName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException iae) {
            if (errorOnUnknownType) {
                throw new UnrecognizedOpenSearchTypeException("Unknown Type: \"" + typeName + "\"", iae);
            }
            return UNSUPPORTED;
        }
    }

    public int sqlTypeNumber() {
        return this.jdbcType.getVendorTypeNumber();
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    static {
        jdbcTypeToOpenSearchTypeMap = new HashMap<JDBCType, OpenSearchType>();
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.NULL, UNDEFINED);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.BOOLEAN, BOOLEAN);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.TINYINT, BYTE);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.SMALLINT, SHORT);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.INTEGER, INTEGER);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.BIGINT, LONG);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.DOUBLE, DOUBLE);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.REAL, FLOAT);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.FLOAT, DOUBLE);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.VARCHAR, KEYWORD);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.TIMESTAMP, TIMESTAMP);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.TIME, TIME);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.DATE, DATE);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.VARBINARY, BINARY);
        jdbcTypeToOpenSearchTypeMap.put(JDBCType.STRUCT, OBJECT);
    }
}

